/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.user.UserPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.SelfLinkBuilder;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserIdentity;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import io.atlassian.fugue.Either;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="user/properties")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class UserPropertyResource {
    private final BasePropertyResource<ApplicationUser> delegate;
    private final I18nHelper i18n;
    private final ResponseFactory responseFactory;
    private final UserManager userManager;
    private final SelfLinkBuilder.SelfLink selfLink;

    @Inject
    protected UserPropertyResource(UserPropertyService userPropertyService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, ResponseFactory responseFactory, UserManager userManager, SelfLinkBuilder selfLinkBuilder) {
        this.responseFactory = responseFactory;
        this.userManager = userManager;
        this.selfLink = selfLinkBuilder.path("user/properties/");
        this.delegate = new BasePropertyResource(userPropertyService, authenticationContext, jiraBaseUrls, i18n, this::getSelf, EntityPropertyType.COMMENT_PROPERTY);
        this.i18n = i18n;
    }

    private String getSelf(Long userId, String propertyKey) {
        return this.selfLink.path(propertyKey, new String[0]).queryParam("userKey", ((UserIdentity)this.userManager.getUserIdentityById(userId).get()).getKey()).toString();
    }

    @GET
    @Operation(summary="Get keys of all properties for a user", description="Returns the keys of all properties for the user identified by the key or by the id.")
    @Parameters(value={@Parameter(name="userKey", description="Key of the user whose properties are to be returned"), @Parameter(name="username", description="Username of the user whose properties are to be returned")})
    @ApiResponses(value={@ApiResponse(description="Returned if the user was found.", responseCode="200"), @ApiResponse(description="Returned if the user key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to browse the user.", responseCode="403"), @ApiResponse(description="Returned if the user with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getPropertiesKeys(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username) {
        return (Response)this.withUserId(userKey, username).left().on(this.delegate::getPropertiesKeys);
    }

    @PUT
    @Path(value="/{propertyKey}")
    @Operation(summary="Set the value of a specified user's property", description="Sets the value of the specified user's property.\nYou can use this resource to store a custom data against the user identified by the key or by the id. The user\nwho stores the data is required to have permissions to administer the user.")
    @Parameters(value={@Parameter(name="username", description="Username of the user whose property is to be set"), @Parameter(name="userKey", description="Key of the user whose property is to be set"), @Parameter(name="propertyKey", description="The key of the user's property. The maximum length of the key is 255 bytes.")})
    @RequestBody(description="The request containing value of the user's property. The value has to be a valid, non-empty JSON conforming to http://tools.ietf.org/html/rfc4627. The maximum length of the property value is 32768 bytes.", content={@Content(schema=@Schema(implementation=String.class))})
    @ApiResponses(value={@ApiResponse(description="Returned if the user property is successfully updated.", responseCode="200"), @ApiResponse(description="Returned if the user property is successfully created.", responseCode="201"), @ApiResponse(description="Returned if the user key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to administer the user.", responseCode="403"), @ApiResponse(description="Returned if the user with given key or id does not exist.", responseCode="404")})
    public Response setProperty(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return (Response)this.withUserId(userKey, username).left().on(input -> this.delegate.setProperty((String)input, propertyKey, request));
    }

    @GET
    @Path(value="/{propertyKey}")
    @Operation(summary="Get the value of a specified user's property", description="Returns the value of the property with a given key from the user identified by the key or by the id.")
    @Parameters(value={@Parameter(name="userKey", description="Key of the user whose property is to be returned"), @Parameter(name="username", description="Username of the user whose property is to be returned"), @Parameter(name="propertyKey", description="The key of the user's property", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the user property was found.", responseCode="200"), @ApiResponse(description="Returned if the user key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to browse the user.", responseCode="403"), @ApiResponse(description="Returned if the user with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response getProperty(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username, @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.withUserId(userKey, username).left().on(input -> this.delegate.getProperty((String)input, propertyKey));
    }

    @DELETE
    @Path(value="/{propertyKey}")
    @Operation(summary="Delete a specified user's property", description="Removes the property from the user identified by the key or by the id. The user who removes the property is required to have permissions to administer the user.")
    @Parameters(value={@Parameter(name="userKey", description="Key of the user whose property is to be removed"), @Parameter(name="username", description="Username of the user whose property is to be removed"), @Parameter(name="propertyKey", description="The key of the user's property", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the user property was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if the user key or id is invalid.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the calling user does not have permission to edit the user.", responseCode="403"), @ApiResponse(description="Returned if the user with given key or id does not exist or if the property with given key is not found.", responseCode="404")})
    public Response deleteProperty(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username, @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.withUserId(userKey, username).left().on(input -> this.delegate.deleteProperty((String)input, propertyKey));
    }

    private Either<Response, String> withUserId(String userKey, String username) {
        if (username == null == (userKey == null)) {
            return Either.left((Object)this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.user.properties.id.not.specified"), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED)));
        }
        Optional userIdentity = username != null ? this.userManager.getUserIdentityByUsername(username) : this.userManager.getUserIdentityByKey(userKey);
        return userIdentity.isPresent() ? Either.right((Object)((UserIdentity)userIdentity.get()).getId().toString()) : Either.left((Object)this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.user.error.not.found.general"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND)));
    }
}

