/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.upgrade;

import com.atlassian.jira.rest.bind.DateTimeAdapter;
import com.atlassian.scheduler.status.RunDetails;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class UpgradeResultBean {
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @XmlElement
    @Schema(example="2013-09-25T10:15:00.000+0000")
    private Date startTime;
    @XmlElement
    @Schema(example="2001")
    private Long duration;
    @XmlElement
    @Schema(example="SUCCESS")
    private String outcome;
    @XmlElement
    @Schema(example="")
    private String message;

    public UpgradeResultBean() {
    }

    UpgradeResultBean(Date startTime, Long duration, String outcome, String message) {
        this.startTime = startTime;
        this.duration = duration;
        this.outcome = outcome;
        this.message = message;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getMessage() {
        return this.message;
    }

    public static UpgradeResultBean fromRunDetails(@Nonnull RunDetails runDetails) {
        return new UpgradeResultBean(runDetails.getStartTime(), runDetails.getDurationInMillis(), runDetails.getRunOutcome().toString(), runDetails.getMessage());
    }
}

