/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.upgrade;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.cluster.zdu.DatabaseUpgradeStateManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.upgrade.UpgradeResultBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeScheduler;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.status.RunDetails;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="upgrade")
@AdminOnly
public class UpgradeResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final UpgradeService upgradeService;
    private final UpgradeScheduler upgradeScheduler;
    private final DatabaseUpgradeStateManager databaseUpgradeStateManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final SchedulerHistoryService schedulerHistoryService;

    @Inject
    public UpgradeResource(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, UpgradeService upgradeService, @ComponentImport DatabaseUpgradeStateManager databaseUpgradeStateManager, JiraBaseUrls jiraBaseUrls, SchedulerHistoryService schedulerHistoryService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.upgradeService = upgradeService;
        this.upgradeScheduler = (UpgradeScheduler)ComponentAccessor.getComponent(UpgradeScheduler.class);
        this.databaseUpgradeStateManager = databaseUpgradeStateManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.schedulerHistoryService = schedulerHistoryService;
    }

    @POST
    @Operation(summary="Run pending upgrade tasks", description="Runs any pending delayed upgrade tasks. Need Admin permissions to do this.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="OK response if successful, array of error messages if schedule fails.", responseCode="200"), @ApiResponse(description="Returned if the user does not have admin permissions.", responseCode="403"), @ApiResponse(description="Returned if ZDU cluster upgrade in progress.", responseCode="409")})
    public Response runUpgradesNow() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(44, user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.databaseUpgradeStateManager.areDelayedUpgradesHandledByCluster()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"ZDU cluster upgrade in progress").build();
        }
        UpgradeResult status = this.upgradeScheduler.scheduleUpgrades(0);
        if (status.successful()) {
            URI location = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path("upgrade").build(new Object[0]);
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).header("Retry-After", (Object)10).cacheControl(CacheControl.never()).build();
        }
        return Response.serverError().cacheControl(CacheControl.never()).entity((Object)status.getErrors()).build();
    }

    @GET
    @Operation(summary="Get result of the last upgrade task", description="Returns the result of the last upgrade task.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns the result of the last upgrade.", responseCode="200", content={@Content(schema=@Schema(implementation=UpgradeResultBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the upgrade task is still running.", responseCode="303"), @ApiResponse(description="Returned if no prior upgrade task exists.", responseCode="404")})
    public Response getUpgradeResult() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.upgradeService.areUpgradesRunning()) {
            URI location = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path("upgrade").build(new Object[0]);
            return Response.status((Response.Status)Response.Status.SEE_OTHER).location(location).header("Retry-After", (Object)10).cacheControl(CacheControl.never()).build();
        }
        Optional<RunDetails> lastUpgradeResult = Optional.ofNullable(this.schedulerHistoryService.getLastRunForJob(UpgradeScheduler.UPGRADES_JOB_ID));
        return lastUpgradeResult.map(result -> Response.ok((Object)this.upgradeService.areUpgradesRunning()).entity((Object)UpgradeResultBean.fromRunDetails(result)).cacheControl(CacheControl.never()).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }
}

