/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.securitylevel;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecurityLevelJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.securitylevel.SecurityListLevelJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/securitylevel")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectSecurityLevelResource {
    private final ProjectFinder projectFinder;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final JiraBaseUrls baseUrls;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ResponseFactory responseFactory;

    @Inject
    public ProjectSecurityLevelResource(ProjectFinder projectFinder, IssueSecurityLevelManager issueSecurityLevelManager, JiraBaseUrls baseUrls, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, ResponseFactory responseFactory) {
        this.projectFinder = projectFinder;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.baseUrls = baseUrls;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.responseFactory = responseFactory;
    }

    @GET
    @Operation(summary="Get all security levels for project", description="Returns all security levels for the project that the current logged in user has access to. If the user does not have the Set Issue Security permission, the list will be empty.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectKeyOrId", description="Key or id of project to list the security levels for", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of all security levels in a project for which the current user has access.", responseCode="200", content={@Content(schema=@Schema(implementation=SecurityListLevelJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project is not found or the user does not have permissions to browse it.", responseCode="404")})
    public Response getSecurityLevelsForProject(@PathParam(value="projectKeyOrId") String projectKeyOrId) {
        ApplicationUser user = this.authenticationContext.getUser();
        ProjectService.GetProjectResult getProjectResult = this.projectFinder.getGetProjectByIdOrKey(user, projectKeyOrId);
        if (getProjectResult.isValid()) {
            if (!this.permissionManager.hasPermission(ProjectPermissions.SET_ISSUE_SECURITY, getProjectResult.getProject(), user)) {
                List<SecurityLevelJsonBean> empty = Collections.emptyList();
                return this.responseFactory.okNoCache(SecurityListLevelJsonBean.of(empty));
            }
            List usersSecurityLevels = this.issueSecurityLevelManager.getUsersSecurityLevels(getProjectResult.getProject(), user);
            return this.responseFactory.okNoCache(SecurityListLevelJsonBean.of(SecurityLevelJsonBean.shortBeans((Collection)usersSecurityLevels, (JiraBaseUrls)this.baseUrls)));
        }
        return this.responseFactory.errorResponse(getProjectResult.getErrorCollection());
    }
}

