/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBean;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

class UserListResolver {
    static final String DO_NOT_COUNT_USERS_ON_SHARED_FILTER_FEATURE = "com.atlassian.jira.rest.v2.search.UserListResolver.getShareCount.disabled";
    private static final String EMPTY_QUERY = "";
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final LicenseCountService licenseCountService;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final SchemeManager schemeManager;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;
    private final UserSearchService userSearchService;
    private final Collection<FilterPermissionBean> permissions;
    private LazyReference<Collection<ApplicationUser>> sharedUsers = new LazyReference<Collection<ApplicationUser>>(){

        protected Collection<ApplicationUser> create() throws Exception {
            return UserListResolver.this.getShareUsersInternal();
        }
    };

    public UserListResolver(JiraAuthenticationContext authContext, UserManager userManager, GroupManager groupManager, LicenseCountService licenseCountService, ProjectManager projectManager, PermissionManager permissionManager, ProjectRoleManager projectRoleManager, SchemeManager schemeManager, FeatureManager featureManager, UserSearchService userSearchService, Collection<FilterPermissionBean> permissions) {
        this.authContext = authContext;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.licenseCountService = licenseCountService;
        this.projectRoleManager = projectRoleManager;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.schemeManager = schemeManager;
        this.featureManager = featureManager;
        this.userSearchService = userSearchService;
        this.permissions = permissions;
    }

    private Collection<ApplicationUser> getShareUsersInternal() {
        ImmutableSet.Builder sharedUsersBuilder = ImmutableSet.builder();
        if (this.permissionManager.hasPermission(27, this.authContext.getUser())) {
            for (FilterPermissionBean sharePermission : this.permissions) {
                String type = sharePermission.getType();
                if (type.equals(ShareType.Name.GLOBAL.toString())) {
                    return ImmutableList.copyOf(this.getAllActiveUsers());
                }
                if (type.equals(ShareType.Name.AUTHENTICATED.toString())) {
                    return ImmutableList.copyOf(this.getAllActiveUsers());
                }
                if (type.equals(ShareType.Name.GROUP.toString())) {
                    GroupJsonBean groupJsonBean = sharePermission.getGroup();
                    Group group = this.groupManager.getGroup(groupJsonBean.getName());
                    if (!Objects.nonNull(group)) continue;
                    sharedUsersBuilder.addAll(this.activeUsers(this.groupManager.getUsersInGroup(group)));
                    continue;
                }
                if (type.equals(ShareType.Name.PROJECT.toString())) {
                    ProjectBean projectBean = sharePermission.getProject();
                    Project project = this.projectManager.getProjectObjByName(projectBean.getName());
                    ProjectRoleBean roleBean = sharePermission.getRole();
                    if (roleBean == null) {
                        sharedUsersBuilder.addAll(this.activeUsers(this.schemeManager.getUsers(Long.valueOf(10L), project)));
                        continue;
                    }
                    ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleBean.name);
                    sharedUsersBuilder.addAll(this.activeUsers(this.projectRoleManager.getProjectRoleActors(projectRole, project).getUsers()));
                    continue;
                }
                if (type.equals(ShareType.Name.PROJECT_UNKNOWN.toString()) || type.equals(ShareType.Name.GROUP_UNKNOWN.toString())) continue;
                if (type.equals(ShareType.Name.USER.toString())) {
                    UserBean userBean = sharePermission.getUser();
                    ApplicationUser user = this.userManager.getUserByKey(userBean.getKey());
                    if (!Objects.nonNull(user)) continue;
                    sharedUsersBuilder.add((Object)user);
                    continue;
                }
                if (type.equals(ShareType.Name.USER_UNKNOWN.toString())) continue;
                throw new IllegalStateException("Unknown share type of: " + type);
            }
        }
        return sharedUsersBuilder.build();
    }

    public Collection<ApplicationUser> getShareUsers() {
        return (Collection)this.sharedUsers.get();
    }

    public int getShareCount() {
        boolean shareUserCountEnabled;
        boolean bl = shareUserCountEnabled = !this.featureManager.isEnabled(DO_NOT_COUNT_USERS_ON_SHARED_FILTER_FEATURE);
        if (shareUserCountEnabled && this.permissionManager.hasPermission(27, this.authContext.getUser())) {
            for (FilterPermissionBean sharePermission : this.permissions) {
                String type = sharePermission.getType();
                if (!type.equals(ShareType.Name.GLOBAL.toString()) && !type.equals(ShareType.Name.AUTHENTICATED.toString())) continue;
                return this.licenseCountService.totalBillableUsers();
            }
            return this.getShareUsers().size();
        }
        return 0;
    }

    private Iterable<ApplicationUser> getAllActiveUsers() {
        return this.userSearchService.findUsers(EMPTY_QUERY, UserSearchParams.LIMITED_ACTIVE_USERS_ALLOW_EMPTY_QUERY);
    }

    private Iterable<ApplicationUser> activeUsers(Collection<ApplicationUser> users) {
        return users.stream().filter(user -> user != null && user.isActive()).collect(Collectors.toList());
    }
}

