/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.type.ShareType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class SharePermissionInputBean {
    public static final SharePermissionInputBean DOC_EXAMPLE_GROUP = new SharePermissionInputBean("group", null, "jira-administrators", null, null, true, false);
    public static final SharePermissionInputBean DOC_EXAMPLE_USER = new SharePermissionInputBean("user", null, null, null, "userKey", true, true);
    public static final List<SharePermissionInputBean> DOC_LIST_EXAMPLE = Lists.newArrayList((Object[])new SharePermissionInputBean[]{DOC_EXAMPLE_GROUP, DOC_EXAMPLE_USER});
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="groupname")
    private String groupname;
    @JsonProperty(value="projectRoleId")
    private String projectRoleId;
    @JsonProperty(value="userKey")
    private String userKey;
    @JsonProperty(value="view")
    private boolean view;
    @JsonProperty(value="edit")
    private boolean edit;

    public SharePermissionInputBean() {
    }

    SharePermissionInputBean(String type, String projectId, String groupname, String projectRoleId, String userKey, boolean view, boolean edit) {
        this.type = type;
        this.projectId = projectId;
        this.groupname = groupname;
        this.projectRoleId = projectRoleId;
        this.userKey = userKey;
        this.view = view;
        this.edit = edit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    public String getProjectRoleId() {
        return this.projectRoleId;
    }

    public void setProjectRoleId(String projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public boolean isView() {
        return this.view;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    static enum Type {
        PROJECT("project", inputBean -> new SharePermissionImpl(ShareType.Name.PROJECT, inputBean.projectId, null, Type.getShareRights(inputBean))),
        GROUP("group", inputBean -> new SharePermissionImpl(ShareType.Name.GROUP, inputBean.groupname, null, Type.getShareRights(inputBean))),
        PROJECT_ROLE("projectRole", inputBean -> new SharePermissionImpl(ShareType.Name.PROJECT, inputBean.projectId, inputBean.projectRoleId, Type.getShareRights(inputBean))),
        GLOBAL("global", inputBean -> new SharePermissionImpl(ShareType.Name.GLOBAL, null, null, Type.getShareRights(inputBean))),
        AUTHENTICATED("authenticated", inputBean -> new SharePermissionImpl(ShareType.Name.AUTHENTICATED, null, null, Type.getShareRights(inputBean))),
        USER("user", inputBean -> new SharePermissionImpl(ShareType.Name.USER, inputBean.userKey, null, Type.getShareRights(inputBean)));

        private final String value;
        private final Function<SharePermissionInputBean, SharePermission> mapFunction;

        private Type(String value, Function<SharePermissionInputBean, SharePermission> mapFunction) {
            this.value = value;
            this.mapFunction = mapFunction;
        }

        public String getValue() {
            return this.value;
        }

        public static Optional<Type> fromValue(String type) {
            for (Type value : Type.values()) {
                if (!value.value.equals(type)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }

        public SharePermission buildSharePermission(SharePermissionInputBean inputBean) {
            return this.mapFunction.apply(inputBean);
        }

        private static ShareRight getShareRights(SharePermissionInputBean inputBean) {
            return SharePermissionUtils.ShareRightUtils.fromBooleans((boolean)inputBean.isView(), (boolean)inputBean.isEdit());
        }
    }
}

