/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(content=JsonInclude.Include.NON_NULL)
public class SearchResultsBean {
    @Schema(example="0")
    public String expand;
    @Schema(example="0")
    public Integer startAt;
    @Schema(example="50")
    public Integer maxResults;
    @Schema(example="1")
    public Integer total;
    public List<IssueBean> issues;
    @Schema(example="[]")
    public Set<String> warningMessages;
    @Schema(example="{}")
    public HashMap<String, String> names;
    @Schema(example="{}")
    public Map<String, JsonTypeBean> schema;

    public SearchResultsBean() {
    }

    public SearchResultsBean(Integer startAt, Integer maxResults, Integer total, List<IssueBean> issues) {
        this.startAt = startAt;
        this.maxResults = maxResults;
        this.total = total;
        this.issues = issues;
        this.pullUpSchemaAndNames(issues);
    }

    public SearchResultsBean(Integer startAt, Integer maxResults, Integer total, List<IssueBean> issues, Set<String> warningMessages) {
        this(startAt, maxResults, total, issues);
        if (warningMessages != null && !warningMessages.isEmpty()) {
            this.warningMessages = warningMessages;
        }
    }

    private void pullUpSchemaAndNames(List<IssueBean> issues) {
        for (IssueBean issue : issues) {
            this.pullUpNames(issue);
            this.pullUpSchema(issue);
        }
    }

    private void pullUpNames(IssueBean issue) {
        this.pullUpExpandParam(issue, "names");
        this.addToNames(issue.names());
        issue.names(null);
    }

    private void pullUpSchema(IssueBean issue) {
        this.pullUpExpandParam(issue, "schema");
        this.addToSchema(issue.schema());
        issue.schema(null);
    }

    private void pullUpExpandParam(IssueBean issue, String field) {
        Set<String> fieldToRemove = Collections.singleton(field);
        Sets.SetView issueExpand = Sets.difference((Set)Sets.newHashSet(issue.expand()), fieldToRemove);
        issue.expand((Iterable<String>)issueExpand);
        HashSet searchExpand = Sets.newHashSet(StringList.fromQueryParam(this.expand).asList());
        this.expand = StringList.fromList((Iterable<String>)Sets.union((Set)searchExpand, Collections.singleton(field))).toQueryParam();
    }

    private void addToSchema(@Nullable Map<String, JsonTypeBean> issueSchema) {
        if (issueSchema != null) {
            if (this.schema == null) {
                this.schema = Maps.newHashMap();
            }
            this.schema.putAll(issueSchema);
        }
    }

    private void addToNames(@Nullable Map<String, String> issueNames) {
        if (issueNames != null) {
            if (this.names == null) {
                this.names = Maps.newHashMap();
            }
            this.names.putAll(issueNames);
        }
    }
}

