/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder2;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.search.SearchRequestBean;
import com.atlassian.jira.rest.v2.search.SearchResultsBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.api.internal.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.api.internal.expand.resolver.SelfExpandingEntityExpanderResolver;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="search")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchResource {
    static final int DEFAULT_ISSUES_RETURNED = 50;
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueSearchLimits searchLimits;
    private final BeanBuilderFactory beanBuilderFactory;
    private final MauEventService mauEventService;
    private final SelfExpandingEntityExpanderResolver selfExpandingEntityExpanderResolver;
    private final EntityCrawler entityCrawler;

    @Inject
    public SearchResource(SearchService searchService, JiraAuthenticationContext jiraAuthenticationContext, IssueSearchLimits searchLimits, BeanBuilderFactory beanBuilderFactory, MauEventService mauEventService, SelfExpandingEntityExpanderResolver selfExpandingEntityExpanderResolver, EntityCrawler entityCrawler) {
        this.searchService = searchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchLimits = searchLimits;
        this.beanBuilderFactory = beanBuilderFactory;
        this.mauEventService = mauEventService;
        this.selfExpandingEntityExpanderResolver = selfExpandingEntityExpanderResolver;
        this.entityCrawler = entityCrawler;
    }

    @GET
    @Operation(summary="Get issues using JQL", description="Searches for issues using JQL.\nSorting\nthe jql parameter is a full <a href=\"http://confluence.atlassian.com/display/JIRA/Advanced+Searching\">JQL</a>\nexpression, and includes an ORDER BY clause.\nThe fields param (which can be specified multiple times) gives a comma-separated list of fields\nto include in the response. This can be used to retrieve a subset of fields.\nA particular field can be excluded by prefixing it with a minus.\nBy default, only navigable (*navigable) fields are returned in this search resource. Note: the default is different\nin the get-issue resource -- the default there all fields (*all).\n*all - include all fields\n*navigable - include just navigable fields\nsummary,comment - include just the summary and comments\n-description - include navigable fields except the description (the default is *navigable for search)\n*all,-comment - include everything except comments\nGET vs POST:\nIf the JQL query is too large to be encoded as a query param you should instead\nPOST to this resource.\nExpanding Issues in the Search Result:\nIt is possible to expand the issues returned by directly specifying the expansion on the expand parameter passed\nin to this resources.\nFor instance, to expand the changelog for all the issues on the search result, it is necessary to\nspecify changelog as one of the values to expand.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="jql", description="a JQL query string"), @Parameter(name="startAt", description="the index of the first issue to return (0-based)"), @Parameter(name="maxResults", description="the maximum number of issues to return (defaults to 50)"), @Parameter(name="validateQuery", description="whether to validate the JQL query"), @Parameter(name="fields", description="the list of fields to return for each issue"), @Parameter(name="expand", description="A comma-separated list of the parameters to expand")})
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the search results.", responseCode="200", content={@Content(schema=@Schema(implementation=SearchResultsBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is a problem with the JQL query.", responseCode="400")})
    public SearchResultsBean search(@QueryParam(value="jql") String jql, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="validateQuery") @DefaultValue(value="true") Boolean validateQuery, @QueryParam(value="fields") List<StringList> fields, @QueryParam(value="expand") StringList expand) throws SearchException {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql == null ? "" : jql);
        if (!parseResult.isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(parseResult.getErrors().getErrorMessages()));
        }
        MessageSet result = this.searchService.validateQuery(user, parseResult.getQuery());
        if ((validateQuery == null || validateQuery.booleanValue()) && result.hasAnyErrors()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(result.getErrorMessages()).addErrorMessages(result.getWarningMessages()));
        }
        PagerFilter filter = this.createFilter(startAt, maxResults);
        SearchResults searchResult = this.searchService.search(user, parseResult.getQuery(), filter);
        IncludedFields includeFields = IncludedFields.includeNavigableByDefault(fields);
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return this.asResultsBean((SearchResults<Issue>)searchResult, filter, includeFields, expand, result.getWarningMessages());
    }

    @POST
    @Operation(summary="Perform search with JQL", description="Performs a search using JQL.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="a JSON object containing the search request", required=true, content={@Content(schema=@Schema(implementation=SearchRequestBean.class))})
    @ApiResponses(value={@ApiResponse(description="Returns a JSON representation of the search results.", responseCode="200", content={@Content(schema=@Schema(implementation=SearchResultsBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is a problem with the JQL query.", responseCode="400")})
    public SearchResultsBean searchUsingSearchRequest(SearchRequestBean searchRequest) throws SearchException {
        List<StringList> fields = searchRequest.fields != null ? Collections.singletonList(new StringList(searchRequest.fields)) : null;
        StringList expand = searchRequest.expand != null ? StringList.fromList(searchRequest.expand) : null;
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return this.search(searchRequest.jql, searchRequest.startAt, searchRequest.maxResults, searchRequest.validateQuery, fields, expand);
    }

    protected SearchResultsBean asResultsBean(SearchResults<Issue> results, PagerFilter filter, IncludedFields fields, StringList expand, Set<String> warningMessages) {
        ArrayList issues = Lists.newArrayList((Iterable)Lists.transform((List)results.getResults(), (Function)new IssueToIssueBean(fields, expand)));
        return new SearchResultsBean(results.getStart(), filter.getMax(), results.getTotal(), issues, warningMessages);
    }

    protected PagerFilter createFilter(Integer startAt, Integer maxResults) {
        int searchMaxLimit = this.searchLimits.getMaxResults();
        int startIndex = startAt != null ? Math.max(0, startAt) : 0;
        int endIndex = SearchResource.determinePagerFilterMaxResultCounts(maxResults, searchMaxLimit);
        return new PagerFilter(startIndex, endIndex);
    }

    private static int determinePagerFilterMaxResultCounts(Integer intendedMaxResultsToReturn, int maxSearchResultsLimitFromConfig) {
        if (intendedMaxResultsToReturn == null) {
            return 50;
        }
        if (intendedMaxResultsToReturn < 0) {
            return maxSearchResultsLimitFromConfig;
        }
        if (maxSearchResultsLimitFromConfig < 0) {
            return intendedMaxResultsToReturn;
        }
        return Math.min(maxSearchResultsLimitFromConfig, intendedMaxResultsToReturn);
    }

    private class IssueToIssueBean
    implements Function<Issue, IssueBean> {
        private final IncludedFields fields;
        private final ExpandParameter expand;
        private final String expandAsString;
        private final IssueBeanBuilder2 issueBeanBuilder;

        public IssueToIssueBean(IncludedFields fields, StringList expand) {
            this.fields = fields;
            this.expand = new DefaultExpandParameter(expand != null ? expand.asList() : Collections.emptyList());
            this.expandAsString = expand != null ? expand.toQueryParam() : null;
            this.issueBeanBuilder = SearchResource.this.beanBuilderFactory.newIssueBeanBuilder2(fields, this.expandAsString);
        }

        public IssueBean apply(@Nullable Issue issue) {
            IssueBean bean = this.issueBeanBuilder.build(issue);
            SearchResource.this.entityCrawler.crawl((Object)bean, this.expand, (EntityExpanderResolver)SearchResource.this.selfExpandingEntityExpanderResolver);
            return bean;
        }
    }
}

