/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.issue.search.jql.LastJqlFieldsService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.internal.jql.FieldAndPredicateAutoCompleteResultGenerator;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="jql/autocompletedata")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchAutoCompleteResource {
    public static final Logger log = LoggerFactory.getLogger(SearchAutoCompleteResource.class);
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final FieldAndPredicateAutoCompleteResultGenerator fieldAndPredicateAutoCompleteResultGenerator;
    private final LastJqlFieldsService lastJqlFieldsService;
    private final AccessDisablingHelper accessDisablingHelper;
    private final PermissionManager permissionManager;

    @Inject
    public SearchAutoCompleteResource(AutoCompleteJsonGenerator autoCompleteJsonGenerator, JiraAuthenticationContext authContext, I18nHelper i18n, FieldAndPredicateAutoCompleteResultGenerator fieldAndPredicateAutoCompleteResultGenerator, LastJqlFieldsService lastJqlFieldsService, AccessDisablingHelper accessDisablingHelper, PermissionManager permissionManager) {
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.authContext = authContext;
        this.i18n = i18n;
        this.fieldAndPredicateAutoCompleteResultGenerator = fieldAndPredicateAutoCompleteResultGenerator;
        this.lastJqlFieldsService = lastJqlFieldsService;
        this.accessDisablingHelper = accessDisablingHelper;
        this.permissionManager = permissionManager;
    }

    @GET
    @Operation(summary="Get auto complete data for JQL searches", description="Returns the auto complete data required for JQL searches", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="The auto complete data required for JQL searches.", responseCode="200", content={@Content(schema=@Schema(implementation=AutoCompleteResponseBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if an error occurs while generating the response.", responseCode="500")})
    public Response getAutoComplete() {
        this.blockAccessIfNeeded();
        ApplicationUser user = this.authContext.getLoggedInUser();
        Locale locale = this.authContext.getLocale();
        try {
            String entity = "{\"visibleFieldNames\": " + this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(user, locale) + ",\"visibleFunctionNames\": " + this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(user, locale) + ",\"jqlReservedWords\": " + this.autoCompleteJsonGenerator.getJqlReservedWordsJson() + "}";
            return Response.ok((Object)entity).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        catch (JSONException e) {
            throw new RESTException(ErrorCollection.of(this.i18n.getText("rest.error.generating.response")).reason(ErrorCollection.Reason.SERVER_ERROR));
        }
    }

    @Path(value="suggestions")
    @GET
    @Operation(summary="Get auto complete suggestions for JQL search", description="Returns auto complete suggestions for JQL search", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="fieldName", description="The field name for which the suggestions are generated."), @Parameter(name="fieldValue", description="The portion of the field value that has already been provided by the user."), @Parameter(name="predicateName", description="The predicate for which the suggestions are generated. Suggestions are generated only for: \"by\", \"from\" and \"to\"."), @Parameter(name="predicateValue", description="The portion of the predicate value that has already been provided by the user.")})
    @ApiResponse(description="The autocompletion suggestions for JQL search.", responseCode="200", content={@Content(schema=@Schema(implementation=AutoCompleteResultWrapper.class), mediaType="application/json")})
    public Response getFieldAutoCompleteForQueryString(@QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue, @QueryParam(value="predicateName") String predicateName, @QueryParam(value="predicateValue") String predicateValue) {
        ImmutableList.Builder results = ImmutableList.builder();
        if (fieldName != null) {
            results.addAll(this.fieldAndPredicateAutoCompleteResultGenerator.getAutoCompleteResultsForField(fieldName, (String)StringUtils.defaultIfEmpty((CharSequence)fieldValue, (CharSequence)"")));
            ApplicationUser user = this.authContext.getLoggedInUser();
            try {
                if (user != null) {
                    this.lastJqlFieldsService.addOneField(user, fieldName);
                }
            }
            catch (JSONException e) {
                log.warn("Error during saving of new recent field '{}' for user {}", new Object[]{fieldName, user.getUsername(), e});
            }
        }
        if (predicateName != null) {
            results.addAll(this.fieldAndPredicateAutoCompleteResultGenerator.getAutoCompleteResultsForPredicate(predicateName, predicateValue, fieldName));
        }
        return Response.ok((Object)AutoCompleteResultWrapper.wrap((ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result>)results.build())).cacheControl(CacheControl.NO_CACHE).build();
    }

    private void blockAccessIfNeeded() {
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockAnyoneNotFulfillingCondition(user -> this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user)).build())) {
            throw new NotAuthorisedWebException();
        }
    }

    public static class AutoCompleteResultWrapper {
        @XmlElement
        private List<AutoCompleteResultBean> results;

        public AutoCompleteResultWrapper(Iterable<AutoCompleteResultBean> results) {
            this.results = ImmutableList.copyOf(results);
        }

        public static AutoCompleteResultWrapper wrap(ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result> results) {
            return new AutoCompleteResultWrapper(Iterables.transform(results, result -> new AutoCompleteResultBean(result.getValue(), result.getDisplayName())));
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class AutoCompleteResponseBean {
        @Schema(example="[\n    {\n        \"value\": \"affectedVersion\",\n        \"displayName\": \"affectedVersion\",\n        \"auto\": \"true\",\n        \"orderable\": \"true\",\n        \"searchable\": \"true\",\n        \"operators\": [\"=\", \"!=\", \"in\", \"not in\", \"is\", \"is not\", \"<\", \"<=\", \">\", \">=\"],\n        \"types\": [\"com.atlassian.crowd.embedded.api.User\"]\n    },\n    {\n        \"value\": \"assignee\",\n        \"displayName\": \"assignee\",\n        \"auto\": \"true\",\n        \"orderable\": \"true\",\n        \"searchable\": \"true\",\n        \"operators\": [\"!=\", \"was not in\", \"not in\", \"was not\", \"is\", \"was in\", \"was\", \"=\", \"in\", \"changed\", \"is not\"],\n        \"types\": [\"com.atlassian.crowd.embedded.api.User\"]\n    }\n]")
        public List<String> visibleFieldNames;
        @Schema(example="[\n    {\n        \"value\": \"currentLogin()\",\n        \"displayName\": \"currentLogin()\",\n        \"types\": [\"java.util.Date\"]\n    },\n    {\n        \"value\": \"currentUser()\",\n        \"displayName\": \"currentUser()\",\n        \"types\": [\"com.atlassian.crowd.embedded.api.User\"]\n    }\n]")
        public List<String> visibleFunctionNames;
        @Schema(example="[\"empty\", \"and\", \"or\", \"in\", \"distinct\"]")
        public List<String> jqlReservedWords;

        private AutoCompleteResponseBean() {
        }
    }

    @XmlRootElement
    public static class AutoCompleteResultBean {
        @XmlElement
        private String value;
        @XmlElement
        private String displayName;

        public AutoCompleteResultBean(String value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }
    }
}

