/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.ColumnsBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.util.FilterPermissionHelper;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.rest.v2.search.DefaultShareScopeBean;
import com.atlassian.jira.rest.v2.search.FilterBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBeanFactory;
import com.atlassian.jira.rest.v2.search.SharePermissionFactory;
import com.atlassian.jira.rest.v2.search.SharePermissionInputBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.api.internal.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.api.internal.expand.resolver.ListWrapperEntityExpanderResolver;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@Path(value="filter")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FilterResource {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final FavouritesService favouritesService;
    private final SearchService searchService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final UserSharingPreferencesUtil userSharingPreferencesUtil;
    private final PermissionManager permissionsManager;
    private final UserManager userManager;
    private final UserPreferencesManager userPreferencesManager;
    private final ColumnLayoutManager columnLayoutManager;
    private final ColumnService columnService;
    private final FilterPermissionBeanFactory filterPermissionBeanFactory;
    private final ResponseFactory responseFactory;
    private final SharePermissionFactory sharePermissionFactory;
    private final FilterPermissionHelper filterPermissionHelper;
    private final MauEventService mauEventService;
    private final ListWrapperEntityExpanderResolver entityExpanderResolver;
    private final EntityCrawler entityCrawler;

    @Inject
    public FilterResource(JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService, FavouritesService favouritesService, SearchService searchService, BeanBuilderFactory beanBuilderFactory, UserSharingPreferencesUtil userSharingPreferencesUtil, PermissionManager permissionsManager, UserManager userManager, UserPreferencesManager userPreferencesManager, ColumnLayoutManager columnLayoutManager, ColumnService columnService, FilterPermissionBeanFactory filterPermissionBeanFactory, ResponseFactory responseFactory, SharePermissionFactory sharePermissionFactory, FilterPermissionHelper filterPermissionHelper, MauEventService mauEventService, @ComponentImport ListWrapperEntityExpanderResolver entityExpanderResolver, EntityCrawler entityCrawler) {
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.favouritesService = favouritesService;
        this.searchService = searchService;
        this.beanBuilderFactory = beanBuilderFactory;
        this.userSharingPreferencesUtil = userSharingPreferencesUtil;
        this.permissionsManager = permissionsManager;
        this.userManager = userManager;
        this.userPreferencesManager = userPreferencesManager;
        this.columnLayoutManager = columnLayoutManager;
        this.columnService = columnService;
        this.filterPermissionBeanFactory = filterPermissionBeanFactory;
        this.responseFactory = responseFactory;
        this.sharePermissionFactory = sharePermissionFactory;
        this.filterPermissionHelper = filterPermissionHelper;
        this.mauEventService = mauEventService;
        this.entityExpanderResolver = entityExpanderResolver;
        this.entityCrawler = entityCrawler;
    }

    @Path(value="{id}")
    @GET
    @Operation(summary="Get a filter by ID", description="Returns a filter given an id", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a filter", responseCode="200", content={@Content(schema=@Schema(implementation=FilterBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged-in and don't have access to any project", responseCode="401")})
    public Response getFilter(@PathParam(value="id") Long id, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)context, id);
        if (filter == null) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return this.responseFactory.okNoCache(new SearchRequestToFilterBean(uriInfo, expand).apply(filter));
    }

    @POST
    @Operation(summary="Create a new filter", description="Creates a new filter, and returns newly created filter. Currently sets permissions just using the users default sharing permissions", security={@SecurityRequirement(name="basic")})
    @Parameter(name="bean", description="The filter being created", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a newly created filter", responseCode="200", content={@Content(schema=@Schema(implementation=FilterBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. filter name was not provided).", responseCode="400")})
    public Response createFilter(final FilterBean bean, final @Context UriInfo uriInfo, final @QueryParam(value="expand") StringList expand) {
        final ApplicationUser user = this.authenticationContext.getLoggedInUser();
        final JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        SearchRequest copiedFromFilter = null;
        Query queryToCopy = null;
        if (bean.getId() != null) {
            copiedFromFilter = this.searchRequestService.getFilter((JiraServiceContext)context, Long.valueOf(Long.parseLong(bean.getId())));
            if (copiedFromFilter == null) {
                return this.responseFactory.errorResponse(context.getErrorCollection());
            }
            if (bean.getJql() == null) {
                queryToCopy = copiedFromFilter.getQuery();
            }
        }
        if (queryToCopy == null) {
            SearchService.ParseResult parseResult = this.parseAndValidateJql(bean.getJql(), null, user, (JiraServiceContext)context);
            queryToCopy = parseResult.getQuery();
        }
        Either<Response, SearchRequest> responseSearchRequestEither = this.processFilterBeanForCreate(bean, queryToCopy, (JiraServiceContext)context);
        final SearchRequest finalCopiedFromFilter = copiedFromFilter;
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return (Response)responseSearchRequestEither.left().on((java.util.function.Function)new java.util.function.Function<SearchRequest, Response>(){

            @Override
            @Nullable
            public Response apply(SearchRequest newFilter) {
                if (newFilter == null) {
                    return FilterResource.this.responseFactory.errorResponse(context.getErrorCollection());
                }
                newFilter = FilterResource.this.searchRequestService.createFilter((JiraServiceContext)new JiraServiceContextImpl(user), newFilter, bean.isFavourite());
                if (finalCopiedFromFilter != null) {
                    FilterResource.this.applyFilterColumnsToFilter(finalCopiedFromFilter, newFilter);
                }
                return FilterResource.this.getFilter(newFilter.getId(), uriInfo, expand);
            }
        });
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Update an existing filter", description="Updates an existing filter, and returns its new value. The following properties of a filter can be updated: 'jql', 'name', 'description'. Additionally, administrators can also update the 'owner' field. To get, set or unset 'favourite', use rest/api/1.0/filters/{id}/favourite with GET, PUT and DELETE methods instead.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true), @Parameter(name="bean", description="The filter being updated", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns the updated filter", responseCode="200", content={@Content(schema=@Schema(implementation=FilterBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the input is invalid (e.g. filter name was not provided).", responseCode="400")})
    public Response editFilter(@PathParam(value="id") Long filterId, FilterBean bean, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        SearchService.ParseResult parseResult;
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)context, filterId);
        if (searchRequest == null) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        if (bean.getJql() != null && (parseResult = this.parseAndValidateJql(bean.getJql(), filterId, user, (JiraServiceContext)context)).isValid()) {
            searchRequest.setQuery(parseResult.getQuery());
        }
        if (bean.getName() != null) {
            searchRequest.setName(bean.getName());
        }
        if (bean.getDescription() != null) {
            searchRequest.setDescription(bean.getDescription());
        }
        this.searchRequestService.validateFilterForUpdate((JiraServiceContext)context, searchRequest);
        if (context.getErrorCollection().hasAnyErrors()) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        if (bean.getOwner() != null) {
            ApplicationUser ownerUser = this.userManager.getUserByName(bean.getOwner().getName());
            if (ownerUser == null) {
                context.getErrorCollection().addError("searchOwnerUserName", context.getI18nBean().getText("admin.errors.filters.userdoesnotexist", bean.getOwner().getName()));
            } else if (ownerUser.equals((Object)searchRequest.getOwner())) {
                this.searchRequestService.updateFilter((JiraServiceContext)context, searchRequest);
            } else {
                JiraServiceContextImpl contextWithOwner = new JiraServiceContextImpl(ownerUser, context.getErrorCollection(), context.getI18nBean());
                searchRequest.setOwner(ownerUser);
                this.searchRequestService.updateFilterOwner((JiraServiceContext)contextWithOwner, user, searchRequest);
            }
        } else {
            this.searchRequestService.updateFilter((JiraServiceContext)context, searchRequest);
        }
        if (context.getErrorCollection().hasAnyErrors()) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        return this.getFilter(searchRequest.getId(), uriInfo, expand);
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Delete a filter", description="Delete a filter", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The ID of the filter to delete.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the filter was removed successfully.", responseCode="204"), @ApiResponse(description="Returned if an error occurs.", responseCode="400"), @ApiResponse(description="Returned if the calling user is not authenticated.", responseCode="401")})
    public Response deleteFilter(@PathParam(value="id") Long id) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        this.searchRequestService.deleteFilter((JiraServiceContext)context, id);
        if (context.getErrorCollection().hasAnyErrors()) {
            return this.responseFactory.errorResponse(context.getErrorCollection());
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void applyFilterColumnsToFilter(SearchRequest filter, SearchRequest newFilter) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (filter != null) {
            try {
                ColumnLayout filterColumnLayout = this.columnLayoutManager.getColumnLayout(user, filter);
                if (filterColumnLayout != null) {
                    this.columnLayoutManager.storeEditableSearchRequestColumnLayout((EditableSearchRequestColumnLayout)new EditableSearchRequestColumnLayoutImpl(filterColumnLayout.getColumnLayoutItems(), user, newFilter));
                }
            }
            catch (ColumnLayoutStorageException e) {
                throw new RuntimeException("Failed to store column layout for filter [" + newFilter.getId() + "]", e);
            }
        }
    }

    private Either<Response, SearchRequest> processFilterBeanForCreate(FilterBean bean, Query query, JiraServiceContext context) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        SearchRequest request = new SearchRequest(query);
        if (StringUtils.isBlank((CharSequence)bean.getName())) {
            context.getErrorCollection().addError("filterName", i18nHelper.getText("saveasfilter.specify.name"));
        }
        if (bean.getOwner() != null && !user.getUsername().equals(bean.getOwner().getName())) {
            context.getErrorCollection().addErrorMessage(i18nHelper.getText("admin.errors.filters.must.be.owner"));
        }
        request.setName(bean.getName());
        request.setOwner(user);
        request.setDescription(bean.getDescription());
        request.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (this.isEditEnabled()) {
            request.setPermissions(this.userSharingPreferencesUtil.getDefaultSharePermissions(user));
        }
        this.searchRequestService.validateFilterForCreate(context, request);
        if (context.getErrorCollection().hasAnyErrors()) {
            return Either.left((Object)this.responseFactory.errorResponse(context.getErrorCollection()));
        }
        return Either.right((Object)request);
    }

    private SearchService.ParseResult parseAndValidateJql(String jql, Long filterId, ApplicationUser user, JiraServiceContext context) {
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            context.getErrorCollection().addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
        } else {
            MessageSet validationResults = this.searchService.validateQuery(user, parseResult.getQuery(), filterId);
            if (validationResults.hasAnyErrors()) {
                context.getErrorCollection().addErrorMessages((Collection)validationResults.getErrorMessages());
            }
        }
        return parseResult;
    }

    @Path(value="favourite")
    @GET
    @Operation(summary="Get favourite filters", description="Returns the favourite filters of the logged-in user", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of favourite filters", responseCode="200", content={@Content(schema=@Schema(implementation=FilterBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged-in and don't have access to any project", responseCode="401")})
    public List<FilterBean> getFavouriteFilters(@Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Collection favouriteFilters = this.searchRequestService.getFavouriteFilters(user);
        Iterable favouriteFilterBeans = Iterables.transform((Iterable)favouriteFilters, (Function)new SearchRequestToFilterBean(uriInfo, expand, true));
        return Lists.newArrayList((Iterable)favouriteFilterBeans);
    }

    @Path(value="defaultShareScope")
    @GET
    @Operation(summary="Get default share scope", description="Returns the default share scope of the logged-in user", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns the default share scope of the logged-in user", responseCode="200", content={@Content(schema=@Schema(implementation=DefaultShareScopeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is a problem looking up preferences for the logged-in user", responseCode="400")})
    public Response getDefaultShareScope() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        DefaultShareScopeBean shareScope = this.isEditEnabled() && this.userSharingPreferencesUtil.getDefaultSharePermissions(user).isGlobal() ? new DefaultShareScopeBean(DefaultShareScopeBean.Scope.GLOBAL) : (this.isEditEnabled() && this.userSharingPreferencesUtil.getDefaultSharePermissions(user).isAuthenticated() ? new DefaultShareScopeBean(DefaultShareScopeBean.Scope.AUTHENTICATED) : new DefaultShareScopeBean(DefaultShareScopeBean.Scope.PRIVATE));
        return this.responseFactory.okNoCache(shareScope);
    }

    @Path(value="defaultShareScope")
    @PUT
    @Operation(summary="Set default share scope", description="Sets the default share scope of the logged-in user. Available values are: AUTHENTICATED (for sharing with all logged-in users) and PRIVATE (for no shares).", security={@SecurityRequirement(name="basic")})
    @Parameter(name="shareScope", description="The new default share scope", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns the new default share scope of the logged-in user", responseCode="200", content={@Content(schema=@Schema(implementation=DefaultShareScopeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if there is a problem setting the preferences for the logged-in user", responseCode="400")})
    public Response setDefaultShareScope(DefaultShareScopeBean shareScope) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        Preferences userPreferences = this.userPreferencesManager.getPreferences(user);
        try {
            boolean defaultToPrivate = DefaultShareScopeBean.Scope.PRIVATE.equals((Object)shareScope.getScope());
            userPreferences.setBoolean("user.default.share.private", defaultToPrivate);
        }
        catch (AtlassianCoreException e) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.getDefaultShareScope();
    }

    @GET
    @Path(value="{id}/columns")
    @Operation(summary="Get default columns for filter", description="Returns the default columns for the given filter. Currently logged in user will be used as the user making such request.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of columns for configured for the given user", responseCode="200", content={@Content(schema=@Schema(implementation=ColumnLayout.class), mediaType="application/json")}), @ApiResponse(description="Returned if the filter does not have any columns.", responseCode="404"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response defaultColumns(@PathParam(value="id") Long filterId) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceOutcome outcome = this.columnService.getColumnLayout(currentUser, filterId);
        if (outcome.isValid()) {
            ColumnLayout columnLayout = (ColumnLayout)outcome.getReturnedValue();
            if (columnLayout == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
            }
            List columnLayoutItems = columnLayout.getColumnLayoutItems();
            return this.responseFactory.okNoCache(ColumnOptions.toColumnOptions(columnLayoutItems));
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @PUT
    @Path(value="{id}/columns")
    @Consumes(value={"*/*"})
    @Operation(summary="Set default columns for filter", description="Sets the default columns for the given filter", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true), @Parameter(name="fields", description="List of column ids", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned when the columns are saved successfully", responseCode="200"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response setColumns(@PathParam(value="id") Long filterId, @FormParam(value="columns") List<String> fields) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceResult outcome = this.columnService.setColumns(currentUser, filterId, fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @PUT
    @Path(value="{id}/columns")
    @Consumes(value={"application/json"})
    @Operation(summary="Reset columns for filter", description="Sets the default columns for the given filter", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true), @Parameter(name="fields", description="List of column ids", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned when the columns are saved successfully", responseCode="200"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response setColumns(@PathParam(value="id") Long filterId, ColumnsBean fields) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceResult outcome = this.columnService.setColumns(currentUser, filterId, fields.getColumns());
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @DELETE
    @Path(value="{id}/columns")
    @Consumes(value={"*/*"})
    @Operation(summary="Reset columns for filter", description="Resets the columns for the given filter such that the filter no longer has its own column config", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned when the columns are reset/removed successfully", responseCode="204"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response resetColumns(@PathParam(value="id") Long filterId) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        ServiceResult outcome = this.columnService.resetColumns(currentUser, filterId);
        if (outcome.isValid()) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        return this.responseFactory.errorResponse(outcome.getErrorCollection());
    }

    @GET
    @Path(value="{id}/permission")
    @Operation(summary="Get all share permissions of filter", description="Returns all share permissions of the given filter", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of share permissions associated with the given filter", responseCode="200", content={@Content(schema=@Schema(implementation=FilterPermissionBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned when filter with given id does not exist or when the user does not have permissions to view the filter.", responseCode="404")})
    public Response getSharePermissions(@PathParam(value="id") Long id) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        if (currentUser == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            Collection<FilterPermissionBean> beans = this.getSharePermissionBeans(currentUser, (SearchRequest)filter);
            return Response.ok(beans).build();
        }));
    }

    private Collection<FilterPermissionBean> getSharePermissionBeans(ApplicationUser user, SearchRequest filter) {
        Set permissionSet = filter.getPermissions().getPermissionSet();
        return permissionSet.stream().map(permission -> this.filterPermissionBeanFactory.buildPermissionBean(user, (SharePermission)permission)).collect(Collectors.toList());
    }

    @GET
    @Path(value="{id}/permission/{permissionId}")
    @Operation(summary="Get a single share permission of filter", description="Returns a single share permission of the given filter", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true), @Parameter(name="permissionId", description="The permission id.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns a share permission associated with the given filter and permission-id", responseCode="200", content={@Content(schema=@Schema(implementation=FilterPermissionBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned when filter or permission with given id does not exist or when the user does not have permissions to view the filter.", responseCode="404")})
    public Response getSharePermission(@PathParam(value="id") Long id, @PathParam(value="permissionId") Long permissionId) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        if (currentUser == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            Set permissionSet = filter.getPermissions().getPermissionSet();
            return permissionSet.stream().filter(sharePermission -> sharePermission.getId().equals(permissionId)).map(permission -> this.filterPermissionBeanFactory.buildPermissionBean(currentUser, (SharePermission)permission)).findFirst().map(this.responseFactory::okNoCache).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }));
    }

    @POST
    @Path(value="{id}/permission")
    @Operation(summary="Add share permissions to filter", description="Adds a share permissions to the given filter. Adding a global permission removes all previous permissions from the filter", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="sharePermissionInputBean", description="The share permission input bean", required=true), @Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns share permissions associated with the given filter", responseCode="201", content={@Content(schema=@Schema(implementation=FilterPermissionBean.class), mediaType="application/json")}), @ApiResponse(description="Returned given permission input bean is invalid or when user does not have the permission to share filters or when the user cannot edit the given filter.", responseCode="400"), @ApiResponse(description="Returned if user is not logged in.", responseCode="401"), @ApiResponse(description="Returned when filter with given id does not exist or when the user does not have permissions to view the filter.", responseCode="404")})
    public Response addSharePermission(SharePermissionInputBean sharePermissionInputBean, @PathParam(value="id") Long id) {
        ApplicationUser currentUser = this.authenticationContext.getLoggedInUser();
        if (currentUser == null) {
            return this.responseFactory.notLoggedInResponse();
        }
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            ServiceOutcome<SharePermission> sharePermissionOutcome = this.sharePermissionFactory.fromBean(sharePermissionInputBean, context.getI18nBean());
            if (!sharePermissionOutcome.isValid()) {
                return this.responseFactory.errorResponse(sharePermissionOutcome.getErrorCollection());
            }
            ServiceOutcome<SearchRequest> outcome = this.filterPermissionHelper.addSharePermissionToSavedFilter(currentUser, (SearchRequest)filter, (SharePermission)sharePermissionOutcome.get());
            if (!outcome.isValid()) {
                return this.responseFactory.errorResponse(outcome.getErrorCollection());
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity(this.getSharePermissionBeans(currentUser, (SearchRequest)outcome.get())).build();
        }));
    }

    @DELETE
    @Path(value="{id}/permission/{permission-id}")
    @Operation(summary="Remove share permissions from filter", description="Removes a share permissions from the given filter", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The filter id.", in=ParameterIn.PATH, required=true), @Parameter(name="permissionId", description="The permission id.", in=ParameterIn.PATH, required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if successful.", responseCode="204"), @ApiResponse(description="Returned when filter or permission with given id does not exist or when the user does not have permissions to view the filter.", responseCode="404")})
    public Response deleteSharePermission(@PathParam(value="id") Long id, @PathParam(value="permission-id") Long permissionId) {
        return this.withJiraServiceContext(context -> this.withFilter(id, (JiraServiceContext)context, filter -> {
            ServiceOutcome<SearchRequest> outcome = this.filterPermissionHelper.removeSharePermissionFromSavedFilter(context.getLoggedInApplicationUser(), (SearchRequest)filter, permissionId);
            if (!outcome.isValid()) {
                return this.responseFactory.errorResponse(outcome.getErrorCollection());
            }
            return Response.noContent().build();
        }));
    }

    private Response withFilter(Long id, JiraServiceContext context, java.util.function.Function<SearchRequest, Response> responseFunction) {
        SearchRequest filter = this.searchRequestService.getFilter(context, id);
        if (filter == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return responseFunction.apply(filter);
    }

    private <T> T withJiraServiceContext(java.util.function.Function<JiraServiceContext, T> responseFunction) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        return responseFunction.apply((JiraServiceContext)context);
    }

    private boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.authenticationContext.getLoggedInUser());
    }

    private class SearchRequestToFilterBean
    implements Function<SearchRequest, FilterBean> {
        private final UriInfo uriInfo;
        private final ExpandParameter expand;
        private final Boolean isFavourite;

        public SearchRequestToFilterBean(UriInfo uriInfo, StringList expand) {
            this(uriInfo, expand, null);
        }

        public SearchRequestToFilterBean(UriInfo uriInfo, StringList expand, Boolean isFavourite) {
            this.uriInfo = uriInfo;
            this.expand = new DefaultExpandParameter(expand != null ? expand.asList() : Collections.emptyList());
            this.isFavourite = isFavourite;
        }

        public FilterBean apply(SearchRequest filter) {
            ApplicationUser loggedInUser = FilterResource.this.authenticationContext.getLoggedInUser();
            boolean isFavourite = this.isFavourite == null ? loggedInUser != null && FilterResource.this.favouritesService.isFavourite(loggedInUser, (SharedEntity)filter) : this.isFavourite;
            FilterBean bean = FilterResource.this.beanBuilderFactory.newFilterBeanBuilder().filter(filter).context(this.uriInfo).owner(filter.getOwner()).favourite(isFavourite).build();
            FilterResource.this.entityCrawler.crawl((Object)bean, this.expand, (EntityExpanderResolver)FilterResource.this.entityExpanderResolver);
            return bean;
        }
    }
}

