/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.project.type;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.project.type.ProjectTypeBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="project/type")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectTypeResource {
    private final ProjectTypeManager projectTypeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final AccessDisablingHelper accessDisablingHelper;

    @Inject
    public ProjectTypeResource(ProjectTypeManager projectTypeManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, AccessDisablingHelper accessDisablingHelper) {
        this.projectTypeManager = (ProjectTypeManager)Preconditions.checkNotNull((Object)projectTypeManager);
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.accessDisablingHelper = (AccessDisablingHelper)Preconditions.checkNotNull((Object)accessDisablingHelper);
    }

    @GET
    @Operation(summary="Get all project types", description="Returns all the project types defined on the Jira instance, not taking into account whether the license to use those project types is valid or not. In case of anonymous checks if they can access at least one project.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list with all the project types defined on the Jira instance", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectTypeBean.class))}), @ApiResponse(description="A response status of 401 indicates that there is not a logged in user and therefore this operation can't be performed", responseCode="401")})
    public Response getAllProjectTypes() {
        this.blockAnonymousIfNeeded();
        ArrayList projectTypes = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.projectTypeManager.getAllProjectTypes(), this::toBean));
        return Response.ok((Object)projectTypes).build();
    }

    @GET
    @Path(value="{projectTypeKey}")
    @Operation(summary="Get project type by key", description="Returns the project type with the given key. In case of anonymous checks if they can access at least one project.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectTypeKey", description="The key of the project type", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a representation of the project type with the given id", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectTypeBean.class), mediaType="application/json")}), @ApiResponse(description="A response status of 401 indicates that there is not a logged in user and therefore this operation can't be performed", responseCode="401")})
    public Response getProjectTypeByKey(@PathParam(value="projectTypeKey") String projectTypeKey) {
        this.blockAnonymousIfNeeded();
        Option projectType = this.projectTypeManager.getByKey(new ProjectTypeKey(projectTypeKey));
        if (projectType.isDefined()) {
            return Response.ok((Object)this.toBean((ProjectType)projectType.get())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{projectTypeKey}/accessible")
    @Operation(summary="Get project type by key", description="Returns the project type with the given key, if it is accessible to the logged in user. This takes into account whether the user is licensed on the Application that defines the project type.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectTypeKey", description="The key of the project type", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a representation of the project type with the given id", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectTypeBean.class), mediaType="application/json")}), @ApiResponse(description="A response status of 401 indicates that there is not a logged in user and therefore this operation can't be performed", responseCode="401"), @ApiResponse(description="A response status of 404 indicates that the project type is not accessible for the logged in user", responseCode="404")})
    public Response getAccessibleProjectTypeByKey(@PathParam(value="projectTypeKey") String projectTypeKey) {
        if (this.authenticationContext.isLoggedInUser()) {
            Option projectType = this.projectTypeManager.getAccessibleProjectType(this.authenticationContext.getLoggedInUser(), new ProjectTypeKey(projectTypeKey));
            if (projectType.isDefined()) {
                return Response.ok((Object)this.toBean((ProjectType)projectType.get())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private ProjectTypeBean toBean(ProjectType projectType) {
        return new ProjectTypeBean(projectType.getKey().getKey(), projectType.getDescriptionI18nKey(), projectType.getIcon(), projectType.getColor());
    }

    private void blockAnonymousIfNeeded() {
        AccessDisablingHelperConfig config = AccessDisablingHelperConfig.builder().logDeprecatedSinceVersion("10.5.0").blockAccessSinceVersion("10.0.0").blockAnyoneNotFulfillingCondition(this::canUserAccess).featureFlag(JiraFeatureFlagRegistrar.PROJECT_TYPE_ANONYMOUS_ACCESS.featureKey()).build();
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(config)) {
            throw new NotAuthorisedWebException();
        }
    }

    private boolean canUserAccess(ApplicationUser user) {
        return user != null || this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null);
    }
}

