/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.project.type;

import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ProjectTypeBean {
    @JsonProperty
    @Schema(example="software")
    private String key;
    @JsonProperty
    @Schema(example="Software")
    private String formattedKey;
    @JsonProperty
    @Schema(example="Project type for software projects")
    private String descriptionI18nKey;
    @JsonProperty
    @Schema(example="PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOC4xLjEsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCAzMiAzMiIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMzIgMzIiIHhtbDpzcGFjZT0icHJlc2VydmUiPg0KPGc+DQoJPHBhdGggZmlsbD0iIzY2NjY2NiIgZD0iTTE2LDBDNy4yLDAsMCw3LjIsMCwxNmMwLDguOCw3LjIsMTYsMTYsMTZjOC44LDAsMTYtNy4yLDE2LTE2QzMyLDcuMiwyNC44LDAsMTYsMHogTTI1LjcsMjMNCgkJYzAsMS44LTEuNCwzLjItMy4yLDMuMkg5LjJDNy41LDI2LjIsNiwyNC44LDYsMjNWOS44QzYsOCw3LjUsNi42LDkuMiw2LjZoMTMuMmMwLjIsMCwwLjQsMCwwLjcsMC4xbC0yLjgsMi44SDkuMg0KCQlDOSw5LjQsOC44LDkuNiw4LjgsOS44VjIzYzAsMC4yLDAuMiwwLjQsMC40LDAuNGgxMy4yYzAuMiwwLDAuNC0wLjIsMC40LTAuNHYtNS4zbDIuOC0yLjhWMjN6IE0xNS45LDIxLjNMMTEsMTYuNGwyLTJsMi45LDIuOQ0KCQlMMjYuNCw2LjhjMC42LDAuNywxLjIsMS41LDEuNywyLjNMMTUuOSwyMS4zeiIvPg0KPC9nPg0KPC9zdmc+")
    private String icon;
    @JsonProperty
    @Schema(example="#FFFFFF")
    private String color;

    public ProjectTypeBean(String key, String descriptionI18nKey, String icon, String color) {
        this.key = key;
        this.formattedKey = ProjectTypeKeyFormatter.format((ProjectTypeKey)new ProjectTypeKey(key));
        this.descriptionI18nKey = descriptionI18nKey;
        this.icon = icon;
        this.color = color;
    }

    public String getKey() {
        return this.key;
    }

    public String getFormattedKey() {
        return this.formattedKey;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectTypeBean that = (ProjectTypeBean)o;
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.descriptionI18nKey != null ? !this.descriptionI18nKey.equals(that.descriptionI18nKey) : that.descriptionI18nKey != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.descriptionI18nKey != null ? this.descriptionI18nKey.hashCode() : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }
}

