/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.priority;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ProjectKeyOrId;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.common.IdBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeBean;
import com.atlassian.jira.rest.v2.priority.PrioritySchemeBeansFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="project/{projectKeyOrId}/priorityscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public final class ProjectPrioritySchemeResource {
    private final PrioritySchemeService prioritySchemeService;
    private final ResponseFactory responseFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PrioritySchemeBeansFactory prioritySchemeBeansFactory;

    @Inject
    public ProjectPrioritySchemeResource(PrioritySchemeService prioritySchemeService, ResponseFactory responseFactory, JiraAuthenticationContext jiraAuthenticationContext, PrioritySchemeBeansFactory prioritySchemeBeansFactory) {
        this.prioritySchemeService = prioritySchemeService;
        this.responseFactory = responseFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.prioritySchemeBeansFactory = prioritySchemeBeansFactory;
    }

    @PUT
    @ExperimentalApi
    @Operation(summary="Assign project with priority scheme", description="Assigns project with priority scheme. Priority scheme assign with migration is possible from the UI. Operation will fail if migration is needed as a result of operation eg. there are issues with priorities invalid in the destination scheme. All project keys associated with the priority scheme will only be returned if additional query parameter is provided expand=projectKeys.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="uriInfo", description="a UriInfo", required=true), @Parameter(name="projectKeyOrId", description="Key or id of the project", required=true)})
    @RequestBody(description="Object that contains an id of the scheme", required=true, content={@Content(schema=@Schema(implementation=IdBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Affected priority scheme.", responseCode="200", content={@Content(schema=@Schema(implementation=PrioritySchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is not valid and the priority scheme could not be updated. Eg. migration is needed as a result of operation.", responseCode="400"), @ApiResponse(description="Returned if the user does not have rights to assign priority schemes.", responseCode="403"), @ApiResponse(description="Returned if project or priority scheme is not found.", responseCode="404")})
    public Response assignPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="projectKeyOrId") String projectKeyOrId, IdBean prioritySchemeId) {
        ServiceOutcome result = this.prioritySchemeService.assignProject(this.jiraAuthenticationContext.getLoggedInUser(), prioritySchemeId.getId(), ProjectKeyOrId.parse(projectKeyOrId), true);
        if (!result.isValid()) {
            return this.responseFactory.errorResponse(result.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.jiraAuthenticationContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)result.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    @ExperimentalApi
    @Operation(summary="Unassign project from priority scheme", description="Unassigns project from priority scheme. Operation will fail for defualt priority scheme, project is not found or project is not associated with provided priority scheme. All project keys associated with the priority scheme will only be returned if additional query parameter is provided expand=projectKeys.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="uriInfo", description="a UriInfo", required=true), @Parameter(name="projectKeyOrId", description="Key or id of the project", required=true), @Parameter(name="schemeId", description="Object that contains an id of the scheme", required=true)})
    @ApiResponses(value={@ApiResponse(description="Affected priority scheme.", responseCode="200", content={@Content(schema=@Schema(implementation=PrioritySchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is not valid and the priority scheme could not be updated. Eg. provided scheme is default priority scheme or project is not associated with scheme.", responseCode="400"), @ApiResponse(description="Returned if the user does not have rights to assign priority schemes.", responseCode="403"), @ApiResponse(description="Returned if project or priority scheme is not found.", responseCode="404")})
    public Response unassignPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="projectKeyOrId") String projectKeyOrId, @PathParam(value="schemeId") Long schemeId) {
        ServiceOutcome result = this.prioritySchemeService.unassignProject(this.jiraAuthenticationContext.getLoggedInUser(), schemeId, ProjectKeyOrId.parse(projectKeyOrId));
        if (!result.isValid()) {
            return this.responseFactory.errorResponse(result.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.jiraAuthenticationContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)result.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ExperimentalApi
    @Operation(summary="Get assigned priority scheme", description="Gets a full representation of a priority scheme in JSON format used by specified project. User must be global administrator or project administrator. All project keys associated with the priority scheme will only be returned if additional query parameter is provided expand=projectKeys.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="uriInfo", description="a UriInfo", required=true), @Parameter(name="projectKeyOrId", description="Key or id of the project", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the priority scheme exists and the user has permission to view it.", responseCode="200", content={@Content(schema=@Schema(implementation=PrioritySchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user does not have rights to view priority scheme.", responseCode="403"), @ApiResponse(description="Returned if project or priority scheme is not found.", responseCode="404")})
    public Response getAssignedPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="projectKeyOrId") String projectKeyOrId) {
        ServiceOutcome outcome = this.prioritySchemeService.getSchemeForProject(this.jiraAuthenticationContext.getLoggedInUser(), ProjectKeyOrId.parse(projectKeyOrId));
        if (!outcome.isValid()) {
            return this.responseFactory.errorResponse(outcome.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.jiraAuthenticationContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)outcome.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }
}

