/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.priority;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeResource;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Supplier;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrioritySchemeBeansFactory {
    private final PrioritySchemeManager prioritySchemeManager;
    private final PermissionManager permissionManager;

    @Autowired
    public PrioritySchemeBeansFactory(@ComponentImport PrioritySchemeManager prioritySchemeManager, @ComponentImport PermissionManager permissionManager) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.permissionManager = permissionManager;
    }

    public PrioritySchemeBean buildResponseBean(ApplicationUser user, UriInfo uriInfo, FieldConfigScheme fieldConfigScheme) {
        FieldConfig fieldConfigForDefaultMapping = this.prioritySchemeManager.getFieldConfigForDefaultMapping(fieldConfigScheme);
        Supplier<List<String>> projectKeysSupplier = this.getProjectKeysSupplier(user, fieldConfigScheme);
        PrioritySchemeBean.Builder builder = new PrioritySchemeBean.Builder().id(fieldConfigScheme.getId()).name(fieldConfigScheme.getName()).description(fieldConfigScheme.getDescription()).optionIds(this.prioritySchemeManager.getOptions(fieldConfigForDefaultMapping)).defaultOptionId(this.prioritySchemeManager.getDefaultOption(fieldConfigForDefaultMapping)).self(this.createSelfURI(uriInfo, fieldConfigScheme.getId())).defaultScheme(this.prioritySchemeManager.isDefaultScheme(fieldConfigScheme)).projectKeysSupplier(projectKeysSupplier);
        return builder.build();
    }

    private Supplier<List<String>> getProjectKeysSupplier(ApplicationUser user, FieldConfigScheme fieldConfigScheme) {
        return () -> (List)this.prioritySchemeManager.getProjectsWithScheme(fieldConfigScheme).stream().filter(project -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)).map(Project::getKey).collect(CollectorsUtil.toImmutableList());
    }

    private URI createSelfURI(UriInfo info, Long id) {
        return info.getBaseUriBuilder().path(PrioritySchemeResource.class).path(id.toString()).build(new Object[0]);
    }
}

