/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.preference;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="mypreferences")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class CurrentUserPreferencesResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;

    @Inject
    public CurrentUserPreferencesResource(JiraAuthenticationContext jiraAuthenticationContext, UserPreferencesManager userPreferencesManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = userPreferencesManager;
    }

    @GET
    @Operation(summary="Get user preference by key", description="Returns preference of the currently logged in user. Preference key must be provided as input parameter (key). The value is returned exactly as it is. If key parameter is not provided or wrong - status code 404. If value is found  - status code 200.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="key", description="Key of the preference to be returned.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns the value of one preference of currently logged in user.", responseCode="200", content={@Content(schema=@Schema(type="string"), mediaType="application/json")}), @ApiResponse(description="Key not found.", responseCode="404")})
    public Response getPreference(@QueryParam(value="key") String key) {
        this.fieldValueMustBeProvided("key", key);
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
        String value = preferences.getString(key);
        if (value == null) {
            this.throwError("key not found: '" + key + "'");
        }
        return Response.ok((Object)value).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Operation(summary="Update user preference", description="Sets preference of the currently logged in user. Preference key must be provided as input parameters (key). Value must be provided as post body. If key or value parameter is not provided - status code 404. If preference is set - status code 204.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="key", description="Key of the preference to be set.", required=true), @Parameter(name="value", description="Value of the preference to be set.", required=true)})
    @ApiResponse(description="Confirmation that the preference was set.", responseCode="204")
    public Response setPreference(@QueryParam(value="key") String key, String value) throws AtlassianCoreException {
        this.fieldValueMustBeProvided("key", key);
        this.fieldValueMustBeProvided("value", value);
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
        preferences.setString(key, value);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Operation(summary="Delete user preference", description="Removes preference of the currently logged in user. Preference key must be provided as input parameters (key). If key parameter is not provided or wrong - status code 404. If preference is unset - status code 204.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="key", description="Key of the preference to be removed.", required=true)
    @ApiResponse(description="Confirmation that the preference was removed.", responseCode="204")
    public Response removePreference(@QueryParam(value="key") String key) throws AtlassianCoreException {
        this.fieldValueMustBeProvided("key", key);
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
        if (!preferences.containsValue(key)) {
            this.throwError("key not found: '" + key + "'");
        }
        preferences.remove(key);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void fieldValueMustBeProvided(String fieldName, String fieldValue) {
        if (fieldValue == null || fieldValue.length() == 0) {
            this.throwError("input parameter '" + fieldName + "' must be provided");
        }
    }

    private void throwError(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build());
    }
}

