/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.permission;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.common.IdBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/permissionscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public final class ProjectPermissionSchemeResource {
    private final PermissionSchemeService permissionSchemeService;
    private final ProjectFinder projectFinder;
    private final ResponseFactory responseFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionSchemeBeansFactory beansFactory;
    private final PermissionGrantBeanExpander expander;

    @Inject
    public ProjectPermissionSchemeResource(PermissionSchemeService permissionSchemeService, ProjectFinder projectFinder, ResponseFactory responseFactory, JiraAuthenticationContext jiraAuthenticationContext, PermissionSchemeBeansFactory beansFactory, PermissionGrantBeanExpander expander) {
        this.permissionSchemeService = permissionSchemeService;
        this.projectFinder = projectFinder;
        this.responseFactory = responseFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.beansFactory = beansFactory;
        this.expander = expander;
    }

    @PUT
    @Operation(summary="Assign permission scheme to project", description="Assigns a permission scheme with a project", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectKeyOrId", description="Key or id of the project", required=true), @Parameter(name="expand", description="Use expand to include additional information about permission schemes in the response. This parameter accepts a comma-separated list of expandable options. Expand options include: all and field.")})
    @RequestBody(description="Object that contains an id of the scheme", required=true, content={@Content(schema=@Schema(implementation=IdBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Shortened details of the newly associated permission scheme.", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the user does not have permissions to edit project's permission schemes. In practice the user needs to be a Jira administrator.", responseCode="403"), @ApiResponse(description="Returned if the project or permission scheme is not found.", responseCode="404")})
    public Response assignPermissionScheme(@PathParam(value="projectKeyOrId") String projectKeyOrId, IdBean permissionSchemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.expander.parseExpandQuery(expand)).left().on(expands -> {
            ApplicationUser user = this.jiraAuthenticationContext.getUser();
            ProjectService.GetProjectResult projectGetResult = this.projectFinder.getGetProjectForActionByIdOrKey(user, projectKeyOrId, ProjectAction.VIEW_PROJECT);
            return (Response)this.responseFactory.validateOutcome(projectGetResult).left().on(project -> {
                ServiceResult serviceResult = this.permissionSchemeService.assignPermissionSchemeToProject(user, permissionSchemeId.getId(), project.getId());
                if (serviceResult.isValid()) {
                    return this.getProjectPermissionScheme(user, (Project)project, (List<PermissionSchemeExpandParam>)expands);
                }
                return this.responseFactory.errorResponse(serviceResult.getErrorCollection());
            });
        });
    }

    @GET
    @Operation(summary="Get assigned permission scheme", description="Gets a permission scheme assigned with a project", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectKeyOrId", description="Key or id of the project", required=true), @Parameter(name="expand", description="Use expand to include additional information about permission schemes in the response. This parameter accepts a comma-separated list of expandable options. Expand options include: all and field.")})
    @ApiResponses(value={@ApiResponse(description="The associated permission scheme.", responseCode="200", content={@Content(schema=@Schema(implementation=PermissionSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the user does not have permissions to view the project's configuration. In practice the user needs to be a Jira administrator.", responseCode="403"), @ApiResponse(description="Returned if the project is not found (or the user does not have permissions to view the project).", responseCode="404")})
    public Response getAssignedPermissionScheme(@PathParam(value="projectKeyOrId") String projectKeyOrId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.expander.parseExpandQuery(expand)).left().on(expands -> {
            ApplicationUser user = this.jiraAuthenticationContext.getUser();
            ProjectService.GetProjectResult projectGetResult = this.projectFinder.getGetProjectForActionByIdOrKey(user, projectKeyOrId, ProjectAction.VIEW_PROJECT);
            return (Response)this.responseFactory.validateOutcome(projectGetResult).left().on(project -> this.getProjectPermissionScheme(user, (Project)project, (List<PermissionSchemeExpandParam>)expands));
        });
    }

    private Response getProjectPermissionScheme(ApplicationUser user, Project project, List<PermissionSchemeExpandParam> expands) {
        return (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getSchemeAssignedToProject(user, project.getId())).left().on(input -> this.responseFactory.okNoCache(this.beansFactory.toBean((PermissionScheme)input, expands)));
    }
}

