/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.password;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.rest.v2.password.PasswordPolicyCreateUserBean;
import com.atlassian.jira.rest.v2.password.PasswordPolicyUpdateUserBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="password")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class PasswordResource {
    private final PasswordPolicyManager passwordPolicyManager;
    private final UserManager userManager;

    @Inject
    public PasswordResource(PasswordPolicyManager passwordPolicyManager, UserManager userManager) {
        this.passwordPolicyManager = passwordPolicyManager;
        this.userManager = userManager;
    }

    @GET
    @Path(value="policy")
    @Operation(summary="Get current password policy requirements", description="Returns the list of requirements for the current password policy. For example, \"The password must have at least 10 characters.\", \"The password must not be similar to the user's name or email address.\", etc.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="hasOldPassword", description="Whether or not the user will be required to enter their current password.  Use false (the default) if this is a new user or if an administrator is forcibly changing another user's password.", schema=@Schema(type="boolean", defaultValue="false"))
    @ApiResponse(description="Returns a JSON array of the user-facing messages.", responseCode="200", content={@Content(schema=@Schema(type="array", implementation=String.class), mediaType="application/json")})
    public Response getPasswordPolicy(@QueryParam(value="hasOldPassword") @DefaultValue(value="false") boolean hasOldPassword) {
        return Response.ok((Object)this.passwordPolicyManager.getPolicyDescription(hasOldPassword)).build();
    }

    @POST
    @Path(value="policy/createUser")
    @Operation(summary="Get reasons for password policy disallowance on user creation", description="Returns a list of statements explaining why the password policy would disallow a proposed password for a new user.\nYou can use this method to test the password policy validation. This could be done prior to an action\nwhere a new user and related password are created, using methods like the ones in\n<a href=\"https://docs.atlassian.com/jira/latest/com/atlassian/jira/bc/user/UserService.html\">UserService</a>.\nFor example, you could use this to validate a password in a create user form in the user interface, as the user enters it.\nThe username and new password must be not empty to perform the validation.\nNote, this method will help you validate against the policy only. It won't check any other validations that might be performed\nwhen creating a new user, e.g. checking whether a user with the same name already exists.\n", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The intended parameters for the user that would be created.\nThe username and new password must be specified.  The old password should be specified for\nupdates where the user would be required to enter it and omitted for those like a password\nreset or forced change by the administrator where the old password would not be known.", required=true, content={@Content(schema=@Schema(implementation=PasswordPolicyCreateUserBean.class), mediaType="application/json")})
    @Parameter(name="bean", description="The intended parameters for the user that would be created.", required=true, schema=@Schema(implementation=PasswordPolicyCreateUserBean.class))
    @ApiResponses(value={@ApiResponse(description="Returns a JSON array of the user-facing messages.", responseCode="200", content={@Content(schema=@Schema(type="array", implementation=String.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid, such as if the username or password is left unspecified.", responseCode="400")})
    public Response policyCheckCreateUser(PasswordPolicyCreateUserBean bean) {
        if (bean == null || StringUtils.isEmpty((CharSequence)bean.getUsername()) || StringUtils.isEmpty((CharSequence)bean.getPassword())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok(PasswordResource.snippets(this.passwordPolicyManager.checkPolicy(bean.getUsername(), bean.getDisplayName(), bean.getEmailAddress(), bean.getPassword()))).build();
    }

    @POST
    @Path(value="policy/updateUser")
    @Operation(summary="Get reasons for password policy disallowance on user password update", description="Returns a list of statements explaining why the password policy would disallow a proposed new password for a user with an existing password.\nYou can use this method to test the password policy validation. This could be done prior to an action where the password\nis actually updated, using methods like ChangePassword or ResetPassword.\nFor example, you could use this to validate a password in a change password form in the user interface, as the user enters it.\nThe user must exist and the username and new password must be not empty, to perform the validation.\nNote, this method will help you validate against the policy only. It won't check any other validations that might be performed\nwhen submitting a password change/reset request, e.g. verifying whether the old password is valid.\n", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The intended parameters for the update that would be performed.\nThe username and new password must be specified.  The old password should be specified for\nupdates where the user would be required to enter it and omitted for those like a password\nreset or forced change by the administrator where the old password would not be known.", required=true, content={@Content(schema=@Schema(implementation=PasswordPolicyUpdateUserBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns a JSON array of the user-facing messages. If no policy is set, then his will be an empty list.", responseCode="200", content={@Content(schema=@Schema(type="array", implementation=String.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid, such as if the username or new password is left unspecified.", responseCode="400"), @ApiResponse(description="Returned if the username does not correspond to any existing user.", responseCode="404")})
    public Response policyCheckUpdateUser(PasswordPolicyUpdateUserBean bean) {
        if (bean == null || StringUtils.isEmpty((CharSequence)bean.getUsername()) || StringUtils.isEmpty((CharSequence)bean.getNewPassword())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ApplicationUser existing = this.userManager.getUserByName(bean.getUsername());
        if (existing == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(PasswordResource.snippets(this.passwordPolicyManager.checkPolicy(existing, bean.getOldPassword(), bean.getNewPassword()))).build();
    }

    private static List<String> snippets(Collection<WebErrorMessage> messages) {
        ImmutableList.Builder snippets = ImmutableList.builder();
        for (WebErrorMessage message : messages) {
            snippets.add((Object)message.getSnippet());
        }
        return snippets.build();
    }
}

