/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.notification;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.notification.NotificationScheme;
import com.atlassian.jira.notification.NotificationSchemeService;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBeanFactory;
import com.atlassian.jira.rest.api.notification.NotificationSchemeExpandParam;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="project/{projectKeyOrId}/notificationscheme")
@Produces(value={"application/json"})
@LicensedOnly
public class ProjectNotificationSchemeResource {
    private final ResponseFactory responseFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final NotificationSchemeService notificationSchemeService;
    private final NotificationSchemeBeanFactory notificationSchemeBeanFactory;

    @Inject
    public ProjectNotificationSchemeResource(ResponseFactory responseFactory, JiraAuthenticationContext jiraAuthenticationContext, NotificationSchemeService notificationSchemeService, NotificationSchemeBeanFactory notificationSchemeBeanFactory) {
        this.responseFactory = responseFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.notificationSchemeService = notificationSchemeService;
        this.notificationSchemeBeanFactory = notificationSchemeBeanFactory;
    }

    @GET
    @Operation(summary="Get notification scheme associated with the project", description="Gets a notification scheme associated with the project. Follow the documentation of /notificationscheme/{id} resource for all details about returned value.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectKeyOrId", description="Key or id of the project", required=true), @Parameter(name="expand", description="Optional information to be expanded in the response: group, user, projectRole or field.")})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of the notification scheme with given id", responseCode="200", content={@Content(schema=@Schema(implementation=NotificationSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="The user is not logged in", responseCode="401"), @ApiResponse(description="The user is allowed to access the project, but is not an administrator of the project or Jira and therefore can't see the notification scheme of the project", responseCode="403"), @ApiResponse(description="The notification scheme does not exist, or is not visible to the calling user", responseCode="404")})
    public Response getNotificationScheme(@PathParam(value="projectKeyOrId") String projectKeyOrId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.notificationSchemeBeanFactory.parseExpandQuery(expand)).left().on(expands -> {
            ApplicationUser user = this.jiraAuthenticationContext.getUser();
            ServiceOutcome<NotificationScheme> schemeForProject = this.getNotificationSchemeForProject(user, projectKeyOrId);
            return (Response)this.responseFactory.validateOutcome(schemeForProject).left().on(notificationScheme -> this.responseFactory.okNoCache(this.notificationSchemeBeanFactory.createNotificationSchemeBean((NotificationScheme)notificationScheme, (List<NotificationSchemeExpandParam>)expands)));
        });
    }

    private ServiceOutcome<NotificationScheme> getNotificationSchemeForProject(ApplicationUser user, String projectKeyOrId) {
        try {
            return this.notificationSchemeService.getNotificationSchemeForProject(user, Long.valueOf(Long.parseLong(projectKeyOrId)));
        }
        catch (NumberFormatException e) {
            return this.notificationSchemeService.getNotificationSchemeForProject(user, projectKeyOrId);
        }
    }
}

