/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.notification;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.notification.NotificationScheme;
import com.atlassian.jira.notification.NotificationSchemeService;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBeanFactory;
import com.atlassian.jira.rest.api.notification.NotificationSchemeExpandParam;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="notificationscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class NotificationSchemeResource {
    private static final Integer MAX_RESULTS = 50;
    private final NotificationSchemeService notificationSchemeService;
    private final JiraAuthenticationContext authContext;
    private final ResponseFactory responseFactory;
    private final NotificationSchemeBeanFactory notificationSchemeBeanFactory;

    @Inject
    public NotificationSchemeResource(NotificationSchemeService notificationSchemeService, JiraAuthenticationContext authContext, ResponseFactory responseFactory, NotificationSchemeBeanFactory notificationSchemeBeanFactory) {
        this.notificationSchemeService = notificationSchemeService;
        this.authContext = authContext;
        this.responseFactory = responseFactory;
        this.notificationSchemeBeanFactory = notificationSchemeBeanFactory;
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get full notification scheme details", description="Returns a full representation of the notification scheme for the given id. This resource will return a\nnotification scheme containing a list of events and recipient configured to receive notifications for these events. Consumer\nshould allow events without recipients to appear in response. User accessing\nthe data is required to have permissions to administer at least one project associated with the requested notification scheme.\nNotification recipients can be:\n- current assignee - the value of the notificationType is CurrentAssignee\n- issue reporter - the value of the notificationType is Reporter\n- current user - the value of the notificationType is CurrentUser\n- project lead - the value of the notificationType is ProjectLead\n- component lead - the value of the notificationType is ComponentLead\n- all watchers - the value of the notification type is AllWatchers\n<li>configured user - the value of the notification type is User. Parameter will contain key of the user. Information about the user will be provided\nif <b>user</b> expand parameter is used.\n- configured group - the value of the notification type is Group. Parameter will contain name of the group. Information about the group will be provided\nif <b>group</b> expand parameter is used.\n- configured email address - the value of the notification type is EmailAddress, additionally information about the email will be provided.\n- users or users in groups in the configured custom fields - the value of the notification type is UserCustomField or GroupCustomField. Parameter\nwill contain id of the custom field. Information about the field will be provided if <b>field</b> expand parameter is used.\n- configured project role - the value of the notification type is ProjectRole. Parameter will contain project role id. Information about the project role\nwill be provided if <b>projectRole</b> expand parameter is used.\nPlease see the example for reference.\nThe events can be Jira system events or events configured by administrator. In case of the system events, data about theirs\nids, names and descriptions is provided. In case of custom events, the template event is included as well.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The id of the notification scheme to retrieve", required=true), @Parameter(name="expand", description="Optional information to be expanded in the response: group, user, projectRole or field.")})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of the notification scheme with given id", responseCode="200", content={@Content(schema=@Schema(implementation=NotificationSchemeBean.class), mediaType="application/json")}), @ApiResponse(description="The notification scheme does not exist, or is not visible to the calling user", responseCode="404")})
    public Response getNotificationScheme(@PathParam(value="id") Long notificationSchemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.notificationSchemeBeanFactory.parseExpandQuery(expand)).left().on(expands -> {
            ServiceOutcome notificationSchemeOutcome = this.notificationSchemeService.getNotificationScheme(this.authContext.getUser(), notificationSchemeId);
            return (Response)this.responseFactory.validateOutcome(notificationSchemeOutcome).left().on(notificationScheme -> this.responseFactory.okNoCache(this.notificationSchemeBeanFactory.createNotificationSchemeBean((NotificationScheme)notificationScheme, (List<NotificationSchemeExpandParam>)expands)));
        });
    }

    @GET
    @Operation(summary="Get paginated notification schemes", description="Returns a paginated list of notification schemes. In order to access notification scheme, the calling user is\nrequired to have permissions to administer at least one project associated with the requested notification scheme. Each scheme contains\na list of events and recipient configured to receive notifications for these events. Consumer should allow events without recipients to appear in response.\nThe list is ordered by the scheme's name.\nFollow the documentation of /notificationscheme/{id} resource for all details about returned value.\n", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="startAt", description="The index of the first notification scheme to return (0 based)."), @Parameter(name="maxResults", description="The maximum number of notification schemes to return (max 50)."), @Parameter(name="expand", description="Optional information to be expanded in the response: group, user, projectRole or field.")})
    @ApiResponse(description="Paginated list of notification schemes to which the user has permissions.", responseCode="200", content={@Content(schema=@Schema(implementation=PageBean.class), mediaType="application/json")})
    public Response getNotificationSchemes(@QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="expand") String expand) {
        return (Response)this.responseFactory.toResponse(this.notificationSchemeBeanFactory.parseExpandQuery(expand)).left().on(expands -> {
            PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)((Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)MAX_RESULTS)));
            Page notificationSchemes = this.notificationSchemeService.getNotificationSchemes(this.authContext.getLoggedInUser(), pageRequest);
            PageBean<NotificationSchemeBean> pageBean = PageBean.from(pageRequest, notificationSchemes).build(scheme -> this.notificationSchemeBeanFactory.createNotificationSchemeBean((NotificationScheme)scheme, (List<NotificationSchemeExpandParam>)expands));
            return this.responseFactory.okNoCache(pageBean);
        });
    }
}

