/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public abstract class MonitoringController {
    private final GlobalPermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    protected MonitoringController(@Nonnull GlobalPermissionManager permissionManager, @Nonnull JiraAuthenticationContext jiraAuthenticationContext) {
        this.permissionManager = Objects.requireNonNull(permissionManager, "permissionManager");
        this.jiraAuthenticationContext = Objects.requireNonNull(jiraAuthenticationContext, "jiraAuthenticationContext");
    }

    protected Response onlyAsAdmin(Supplier<Response> runOnlyAsAdmin) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return runOnlyAsAdmin.get();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

