/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.monitoring.jmx.analytics.JmxStartExposingAnalyticsEvent;
import com.atlassian.jira.monitoring.jmx.analytics.JmxStopExposingAnalyticsEvent;
import com.atlassian.jira.rest.v2.monitoring.MonitoringController;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="monitoring/jmx")
@AdminOnly
public class JmxMonitoringController
extends MonitoringController {
    private final JmxMetricsExposer jmxMetricsExposer;
    private final EventPublisher eventPublisher;

    @Inject
    public JmxMonitoringController(@Nonnull @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @Nonnull @ComponentImport GlobalPermissionManager permissionManager, @Nonnull @ComponentImport JmxMetricsExposer jmxMetricsExposer, @Nonnull @ComponentImport EventPublisher eventPublisher) {
        super(permissionManager, jiraAuthenticationContext);
        this.jmxMetricsExposer = Objects.requireNonNull(jmxMetricsExposer, "jmxMetricsExposer");
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
    }

    @POST
    @WebSudoRequired
    @Path(value="startExposing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Start exposing JMX metrics", description="Starts exposing JMX metrics", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Confirmation that the JMX metrics are being exposed.", responseCode="200")
    public Response start() {
        return this.onlyAsAdmin(() -> {
            this.eventPublisher.publish((Object)new JmxStartExposingAnalyticsEvent());
            this.jmxMetricsExposer.startExposing();
            this.jmxMetricsExposer.publishRefreshMessage();
            return Response.ok().build();
        });
    }

    @POST
    @WebSudoRequired
    @Path(value="stopExposing")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Stop exposing JMX metrics", description="Stops exposing JMX metrics", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Confirmation that the JMX metrics are no longer being exposed.", responseCode="200")
    public Response stop() {
        return this.onlyAsAdmin(() -> {
            this.eventPublisher.publish((Object)new JmxStopExposingAnalyticsEvent());
            this.jmxMetricsExposer.stopExposing();
            this.jmxMetricsExposer.publishRefreshMessage();
            return Response.ok().build();
        });
    }

    @GET
    @Path(value="getAvailableMetrics")
    @Produces(value={"application/json"})
    @Operation(summary="Get the available JMX metrics", description="Gets the available JMX metrics", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns the available JMX metrics.", responseCode="200", content={@Content(schema=@Schema(type="array", implementation=String.class), mediaType="application/json")})
    public Response getAvailableMetrics() {
        return this.onlyAsAdmin(() -> Response.ok((Object)this.jmxMetricsExposer.getExposedMetricNames()).build());
    }

    @GET
    @Path(value="areMetricsExposed")
    @Produces(value={"application/json"})
    @Operation(summary="Check if JMX metrics are being exposed", description="Checks if JMX metrics are being exposed", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns whether JMX metrics are being exposed.", responseCode="200", content={@Content(schema=@Schema(type="boolean"), mediaType="application/json")})
    public Response areMetricsExposed() {
        return this.onlyAsAdmin(() -> Response.ok((Object)this.jmxMetricsExposer.isJmxEnabled()).build());
    }
}

