/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.monitoring.IpdMonitoringControlService;
import com.atlassian.jira.rest.v2.monitoring.MonitoringController;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="monitoring/ipd")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
public class IpdMonitoringController
extends MonitoringController {
    private final IpdMonitoringControlService ipdMonitoringMetricsService;

    @Inject
    public IpdMonitoringController(@Nonnull @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @Nonnull @ComponentImport GlobalPermissionManager permissionManager, @Nonnull @ComponentImport IpdMonitoringControlService ipdMonitoringMetricsService) {
        super(permissionManager, jiraAuthenticationContext);
        this.ipdMonitoringMetricsService = Objects.requireNonNull(ipdMonitoringMetricsService, "ipdMonitoringMetricsService");
    }

    @GET
    @WebSudoRequired
    @Operation(summary="Get if IPD Monitoring is enabled", description="Checks if IPD Monitoring is enabled", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns the status of IPD Monitoring.", responseCode="200", content={@Content(schema=@Schema(implementation=IpdMonitoringRestEntity.class), mediaType="application/json")})
    public Response isIpdMonitoringEnabled() {
        return this.onlyAsAdmin(() -> Response.ok((Object)new IpdMonitoringRestEntity(this.ipdMonitoringMetricsService.isIpdMonitoringEnabled())).build());
    }

    @POST
    @WebSudoRequired
    @Operation(summary="Update IPD Monitoring status", description="Enables or disables IPD Monitoring", security={@SecurityRequirement(name="basic")})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="The status to set for IPD Monitoring.", required=true, content={@Content(schema=@Schema(implementation=IpdMonitoringRestEntity.class), mediaType="application/json")})
    @ApiResponse(description="Confirmation that the status was set.", responseCode="204")
    public Response setAppMonitoringEnabled(@RequestBody IpdMonitoringRestEntity ipdMonitoringRequest) {
        return this.onlyAsAdmin(() -> {
            this.ipdMonitoringMetricsService.setIpdMonitoringEnabled(ipdMonitoringRequest.isEnabled().booleanValue());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @VisibleForTesting
    public static class IpdMonitoringRestEntity {
        @Schema(example="true")
        private Boolean isEnabled;

        public IpdMonitoringRestEntity(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public IpdMonitoringRestEntity() {
        }

        public void setEnabled(Boolean enabled) {
            this.isEnabled = enabled;
        }

        public Boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

