/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.jira.monitoring.AppMonitoringMetricsService;
import com.atlassian.jira.rest.v2.monitoring.MonitoringController;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="monitoring/app")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
public class AppMonitoringController
extends MonitoringController {
    private final AppMonitoringMetricsService appMonitoringMetricsService;

    @Inject
    public AppMonitoringController(@Nonnull @ComponentImport GlobalPermissionManager permissionManager, @Nonnull @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @Nonnull @ComponentImport AppMonitoringMetricsService appMonitoringMetricsService) {
        super(permissionManager, jiraAuthenticationContext);
        this.appMonitoringMetricsService = Objects.requireNonNull(appMonitoringMetricsService, "appMonitoringMetricsService");
    }

    @GET
    @WebSudoRequired
    @Operation(summary="Get App Monitoring status", description="Checks if App Monitoring is enabled", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns the status of App Monitoring.", responseCode="200", content={@Content(schema=@Schema(implementation=AppMonitoringRestEntity.class), mediaType="application/json")})
    public Response isAppMonitoringEnabled() {
        return this.onlyAsAdmin(() -> Response.ok((Object)new AppMonitoringRestEntity(this.appMonitoringMetricsService.isAppMonitoringEnabled())).build());
    }

    @POST
    @WebSudoRequired
    @Operation(summary="Update App Monitoring status", description="Enables or disables App Monitoring", security={@SecurityRequirement(name="basic")})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(description="The status to set for App Monitoring.", required=true, content={@Content(schema=@Schema(implementation=AppMonitoringRestEntity.class), mediaType="application/json")})
    @ApiResponse(description="Sets the status of App Monitoring.", responseCode="204")
    public Response setAppMonitoringEnabled(@RequestBody AppMonitoringRestEntity appMonitoringRequest) {
        return this.onlyAsAdmin(() -> {
            this.appMonitoringMetricsService.setAppMonitoringEnabled(appMonitoringRequest.isEnabled().booleanValue());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        });
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @VisibleForTesting
    public static class AppMonitoringRestEntity {
        @Schema(example="true")
        private Boolean isEnabled;

        public AppMonitoringRestEntity(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public AppMonitoringRestEntity() {
        }

        public void setEnabled(Boolean enabled) {
            this.isEnabled = enabled;
        }

        public Boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

