/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.license;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.rest.v2.license.LicenseValidationResults;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="licenseValidator")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LicenceValidator {
    private final I18nHelper i18nHelper;
    private final JiraLicenseService licenseService;

    @Inject
    public LicenceValidator(JiraLicenseService licenseService, I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.licenseService = licenseService;
    }

    @POST
    @Operation(summary="Validate a Jira license", description="Validates a Jira license", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The license string to validate.", required=true, content={@Content(schema=@Schema(implementation=String.class), mediaType="application/json")})
    @ApiResponse(description="The validation results of the license.", responseCode="200", content={@Content(schema=@Schema(implementation=LicenseValidationResults.class), mediaType="application/json")})
    public LicenseValidationResults validate(String license) {
        JiraLicenseService.ValidationResult validationResults = this.licenseService.validate(this.i18nHelper, license);
        return this.extractValidationDetails(validationResults);
    }

    private LicenseValidationResults extractValidationDetails(JiraLicenseService.ValidationResult validationResults) {
        LicenseValidationResults results = new LicenseValidationResults();
        results.setErrors(validationResults.getErrorCollection().getErrors());
        results.setLicenseString(validationResults.getLicenseString());
        return results;
    }
}

