/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.worklog;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.worklog.DeletedWorklog;
import com.atlassian.jira.bc.issue.worklog.WorklogChangedSincePage;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.fields.rest.json.WorklogBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogChangeBean;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogChangedSinceBean;
import com.atlassian.jira.rest.v2.issue.worklog.WorklogIdsRequestBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Path(value="worklog")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@LicensedOnly
public class WorklogResource {
    private final ResponseFactory responseFactory;
    private final WorklogService worklogService;
    private final JiraAuthenticationContext authenticationContext;
    private final WorklogBeanFactory worklogBeanFactory;
    private final JiraBaseUrls jiraBaseUrls;

    @Inject
    public WorklogResource(ResponseFactory responseFactory, WorklogService worklogService, JiraAuthenticationContext authenticationContext, WorklogBeanFactory worklogBeanFactory, JiraBaseUrls jiraBaseUrls) {
        this.responseFactory = responseFactory;
        this.worklogService = worklogService;
        this.authenticationContext = authenticationContext;
        this.worklogBeanFactory = worklogBeanFactory;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    @Path(value="updated")
    @Operation(description="Returns worklogs id and update time of worklogs that was updated since given time. The returns set of worklogs is limited to 1000 elements. This API will not return worklogs updated during last minute.", summary="Returns worklogs updated since given time.")
    @Parameter(name="since", description="a date time in unix timestamp format since when updated worklogs will be returned.", required=true)
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the worklog changes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorklogChangedSinceBean.class))})
    public Response getIdsOfWorklogsModifiedSince(@QueryParam(value="since") @DefaultValue(value="0") Long since) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        WorklogChangedSincePage worklogsUpdatedSince = this.worklogService.getWorklogsUpdatedSince(user, since);
        WorklogChangedSinceBean worklogChangedSinceBean = this.createUpdatedSinceBean((WorklogChangedSincePage<Worklog>)worklogsUpdatedSince);
        return this.responseFactory.okNoCache(worklogChangedSinceBean);
    }

    @GET
    @Path(value="deleted")
    @Operation(description="Returns worklogs id and delete time of worklogs that was deleted since given time. The returns set of worklogs is limited to 1000 elements. This API will not return worklogs deleted during last minute.", summary="Returns worklogs deleted since given time.")
    @Parameter(name="since", description="a date time in unix timestamp format since when deleted worklogs will be returned.", required=true)
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the worklog changes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorklogChangedSinceBean.class))})
    public Response getIdsOfWorklogsDeletedSince(@QueryParam(value="since") @DefaultValue(value="0") Long since) {
        WorklogChangedSincePage worklogsDeletedSince = this.worklogService.getWorklogsDeletedSince(this.authenticationContext.getLoggedInUser(), since);
        WorklogChangedSinceBean worklogChangedSinceBean = this.createDeletedSinceBean((WorklogChangedSincePage<DeletedWorklog>)worklogsDeletedSince);
        return this.responseFactory.okNoCache(worklogChangedSinceBean);
    }

    @POST
    @Path(value="list")
    @Operation(description="Returns worklogs for given worklog ids. Only worklogs to which the calling user has permissions, will be included in the result. The returns set of worklogs is limited to 1000 elements.", summary="Returns worklogs for given ids.")
    @RequestBody(description="a JSON object containing ids of worklogs to return", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=WorklogIdsRequestBean.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns a JSON representation of the worklogs.", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorklogJsonBean.class, type="array"))}), @ApiResponse(responseCode="400", description="Returned if the request contains more than 1000 ids or is null")})
    public Response getWorklogsForIds(WorklogIdsRequestBean request) {
        final ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(loggedInUser, (ErrorCollection)new SimpleErrorCollection(), this.authenticationContext.getI18nHelper());
        if (request.getIds() == null) {
            return this.responseFactory.badRequest("worklog.rest.error.null.set", new String[0]);
        }
        final ServiceOutcome worklogsForIds = this.worklogService.getWorklogsForIds((JiraServiceContext)serviceContext, request.getIds());
        return (Response)this.responseFactory.validateOutcome(worklogsForIds).left().on((Function)new Function<Set<Worklog>, Response>(){

            @Override
            @Nullable
            public Response apply(Set<Worklog> worklogs) {
                return WorklogResource.this.responseFactory.okNoCache(((Set)worklogsForIds.get()).stream().map(worklog -> WorklogResource.this.worklogBeanFactory.createBean(worklog, loggedInUser)).collect(Collectors.toSet()));
            }
        });
    }

    private WorklogChangedSinceBean createUpdatedSinceBean(WorklogChangedSincePage<Worklog> updatedWorklogs) {
        return this.createChangeSinceBean("updated", updatedWorklogs, worklog -> worklog.getUpdated().getTime());
    }

    private WorklogChangedSinceBean createDeletedSinceBean(WorklogChangedSincePage<DeletedWorklog> worklogsDeletedSince) {
        return this.createChangeSinceBean("deleted", worklogsDeletedSince, deletedWorklog -> deletedWorklog.getDeletionTime().getTime());
    }

    private <T extends WithId> WorklogChangedSinceBean createChangeSinceBean(String restApiPath, WorklogChangedSincePage<T> changedSincePage, Function<T, Long> timeMappingFunction) {
        Long since = changedSincePage.getSince();
        Long until = changedSincePage.getChangedSince().isEmpty() ? changedSincePage.getSince() : timeMappingFunction.apply((WithId)Iterables.getLast((Iterable)changedSincePage.getChangedSince()));
        List<WorklogChangeBean> changeBeans = changedSincePage.getChangedSince().stream().map(t -> new WorklogChangeBean(t.getId(), (Long)timeMappingFunction.apply((WithId)t))).collect(Collectors.toList());
        WorklogChangedSinceBean.Builder builder = WorklogChangedSinceBean.builder().setValues(changeBeans).setSince(since).setUntil(until).setIsLastPage(changedSincePage.isLastPage()).setSelf(this.getSelf(restApiPath, since));
        if (!changedSincePage.isLastPage()) {
            return builder.setNextPage(this.getSelf(restApiPath, until)).build();
        }
        return builder.build();
    }

    private URI getSelf(String restApiPath, Long since) {
        return UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(WorklogResource.class).path(restApiPath).queryParam("since", new Object[]{since}).build(new Object[0]);
    }
}

