/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.worklog;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.worklog.IssueWorklogResource;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import javax.ws.rs.core.Response;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum WorklogOperation {
    ADD{

        @Override
        public Worklog validateAndPerformAndLeaveEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogResult worklogResult = WorklogOperation.getWorklogService().validateCreate(serviceContext, worklogInputParameters);
            return WorklogOperation.getWorklogService().createAndRetainRemainingEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public Worklog validateAndPerformAndAutoAdjustEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogResult worklogResult = WorklogOperation.getWorklogService().validateCreate(serviceContext, worklogInputParameters);
            return WorklogOperation.getWorklogService().createAndAutoAdjustRemainingEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public Worklog validateAndPerformAndManualAdjustEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogAdjustmentAmountResult worklogResult = WorklogOperation.getWorklogService().validateCreateWithManuallyAdjustedEstimate(serviceContext, (WorklogAdjustmentAmountInputParameters)worklogInputParameters);
            return WorklogOperation.getWorklogService().createWithManuallyAdjustedEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public Worklog validateAndPerformAndSetNewEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogNewEstimateResult worklogResult = WorklogOperation.getWorklogService().validateCreateWithNewEstimate(serviceContext, (WorklogNewEstimateInputParameters)worklogInputParameters);
            return WorklogOperation.getWorklogService().createWithNewRemainingEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public WorklogInputParameters prepareData(JiraServiceContextImpl serviceContext, Issue issue, WorklogJsonBean request, IssueWorklogResource.WorklogAdjustmentRequest adjustment) {
            com.atlassian.jira.util.ErrorCollection errors = serviceContext.getErrorCollection();
            WorklogInputParametersImpl.Builder builder = WorklogInputParametersImpl.issue((Issue)issue);
            WorklogOperation.addAdjustmentParams(adjustment, builder, errors, ADD, (JiraServiceContext)serviceContext);
            if (!errors.hasAnyErrors()) {
                String timeSpent = request.getTimeSpent();
                Long timeSpentSeconds = request.getTimeSpentSeconds();
                if (timeSpent != null && timeSpentSeconds != null) {
                    errors.addError("timeSpent", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.manual.increaseBy.missing"));
                }
                if (timeSpent != null) {
                    builder.timeSpent(timeSpent);
                } else if (timeSpentSeconds != null) {
                    timeSpent = WorklogOperation.getTimeLoggedString(timeSpentSeconds);
                    builder.timeSpent(timeSpent);
                }
                builder.startDate(request.getStarted() != null ? request.getStarted() : new Date());
                builder.comment(request.getComment());
                builder.visibility(Visibilities.fromVisibilityBean((VisibilityJsonBean)request.getVisibility(), (ProjectRoleManager)WorklogOperation.getProjectRoleManager()));
                return builder.buildAll();
            }
            return null;
        }

        @Override
        public Response prepareSuccessfulResponse(WorklogJsonBean result) {
            return Response.created((URI)result.getSelf()).entity((Object)result).cacheControl(CacheControl.never()).build();
        }
    }
    ,
    DELETE{

        @Override
        public Worklog validateAndPerformAndLeaveEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogResult worklogResult = WorklogOperation.getWorklogService().validateDelete(serviceContext, worklogInputParameters.getWorklogId());
            boolean success = WorklogOperation.getWorklogService().deleteAndRetainRemainingEstimate(serviceContext, worklogResult, true);
            return success ? worklogResult.getWorklog() : null;
        }

        @Override
        public Worklog validateAndPerformAndAutoAdjustEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogResult worklogResult = WorklogOperation.getWorklogService().validateDelete(serviceContext, worklogInputParameters.getWorklogId());
            boolean success = WorklogOperation.getWorklogService().deleteAndAutoAdjustRemainingEstimate(serviceContext, worklogResult, true);
            return success ? worklogResult.getWorklog() : null;
        }

        @Override
        public Worklog validateAndPerformAndManualAdjustEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogAdjustmentAmountResult worklogResult = WorklogOperation.getWorklogService().validateDeleteWithManuallyAdjustedEstimate(serviceContext, worklogInputParameters.getWorklogId(), ((WorklogAdjustmentAmountInputParameters)worklogInputParameters).getAdjustmentAmount());
            boolean success = WorklogOperation.getWorklogService().deleteWithManuallyAdjustedEstimate(serviceContext, worklogResult, true);
            return success ? worklogResult.getWorklog() : null;
        }

        @Override
        public Worklog validateAndPerformAndSetNewEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogNewEstimateResult worklogResult = WorklogOperation.getWorklogService().validateDeleteWithNewEstimate(serviceContext, worklogInputParameters.getWorklogId(), ((WorklogNewEstimateInputParameters)worklogInputParameters).getNewEstimate());
            boolean success = WorklogOperation.getWorklogService().deleteWithNewRemainingEstimate(serviceContext, worklogResult, true);
            return success ? worklogResult.getWorklog() : null;
        }

        @Override
        public WorklogInputParameters prepareData(JiraServiceContextImpl serviceContext, Issue issue, WorklogJsonBean request, IssueWorklogResource.WorklogAdjustmentRequest adjustment) {
            com.atlassian.jira.util.ErrorCollection errors = serviceContext.getErrorCollection();
            Worklog existingWorklog = WorklogOperation.getAndValidateExistingWorklog(request, errors, (JiraServiceContext)serviceContext);
            if (!errors.hasAnyErrors()) {
                WorklogInputParametersImpl.Builder builder = WorklogInputParametersImpl.issue((Issue)issue);
                WorklogOperation.addAdjustmentParams(adjustment, builder, errors, DELETE, (JiraServiceContext)serviceContext);
                if (!errors.hasAnyErrors()) {
                    builder.worklogId(existingWorklog.getId());
                    return builder.buildAll();
                }
            }
            return null;
        }

        @Override
        public Response prepareSuccessfulResponse(WorklogJsonBean result) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
    }
    ,
    EDIT{

        @Override
        public Worklog validateAndPerformAndLeaveEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogResult worklogResult = WorklogOperation.getWorklogService().validateUpdate(serviceContext, worklogInputParameters);
            return WorklogOperation.getWorklogService().updateAndRetainRemainingEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public Worklog validateAndPerformAndAutoAdjustEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogResult worklogResult = WorklogOperation.getWorklogService().validateUpdate(serviceContext, worklogInputParameters);
            return WorklogOperation.getWorklogService().updateAndAutoAdjustRemainingEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public Worklog validateAndPerformAndManualAdjustEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            throw new UnsupportedOperationException(serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.manual.notapplicableforedit"));
        }

        @Override
        public Worklog validateAndPerformAndSetNewEstimate(JiraServiceContext serviceContext, Issue issue, WorklogInputParameters worklogInputParameters) {
            WorklogNewEstimateResult worklogResult = WorklogOperation.getWorklogService().validateUpdateWithNewEstimate(serviceContext, (WorklogNewEstimateInputParameters)worklogInputParameters);
            return WorklogOperation.getWorklogService().updateWithNewRemainingEstimate(serviceContext, worklogResult, true);
        }

        @Override
        public WorklogInputParameters prepareData(JiraServiceContextImpl serviceContext, Issue issue, WorklogJsonBean request, IssueWorklogResource.WorklogAdjustmentRequest adjustment) {
            com.atlassian.jira.util.ErrorCollection errors = serviceContext.getErrorCollection();
            Worklog existingWorklog = WorklogOperation.getAndValidateExistingWorklog(request, errors, (JiraServiceContext)serviceContext);
            if (!errors.hasAnyErrors()) {
                WorklogInputParametersImpl.Builder builder = WorklogInputParametersImpl.issue((Issue)issue);
                WorklogOperation.addAdjustmentParams(adjustment, builder, errors, EDIT, (JiraServiceContext)serviceContext);
                if (!errors.hasAnyErrors()) {
                    String timeSpent = request.getTimeSpent();
                    Long timeSpentSeconds = request.getTimeSpentSeconds();
                    if (timeSpent != null && timeSpentSeconds != null) {
                        errors.addError("timeSpent", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.manual.increaseBy.missing"));
                    }
                    if (timeSpent != null) {
                        builder.timeSpent(timeSpent);
                    } else if (timeSpentSeconds != null) {
                        timeSpent = WorklogOperation.getTimeLoggedString(timeSpentSeconds);
                        builder.timeSpent(timeSpent);
                    }
                    Date start = request.getStarted();
                    builder.worklogId(existingWorklog.getId());
                    builder.timeSpent(timeSpent != null ? timeSpent : WorklogOperation.getTimeLoggedString(existingWorklog.getTimeSpent()));
                    builder.startDate(start != null ? start : existingWorklog.getStartDate());
                    builder.comment(request.getComment() != null ? request.getComment() : existingWorklog.getComment());
                    if (request.getVisibility() != null) {
                        builder.visibility(Visibilities.fromVisibilityBean((VisibilityJsonBean)request.getVisibility(), (ProjectRoleManager)WorklogOperation.getProjectRoleManager()));
                    } else if (request.isVisibilitySet()) {
                        builder.visibility(Visibilities.publicVisibility());
                    } else {
                        builder.visibility(Visibilities.fromGroupAndRoleId((String)existingWorklog.getGroupLevel(), (Long)existingWorklog.getRoleLevelId()));
                    }
                    return builder.buildAll();
                }
            }
            return null;
        }

        @Override
        public Response prepareSuccessfulResponse(WorklogJsonBean result) {
            return Response.ok((Object)result).location(result.getSelf()).cacheControl(CacheControl.never()).build();
        }
    };


    public abstract WorklogInputParameters prepareData(JiraServiceContextImpl var1, Issue var2, WorklogJsonBean var3, IssueWorklogResource.WorklogAdjustmentRequest var4);

    public abstract Worklog validateAndPerformAndSetNewEstimate(JiraServiceContext var1, Issue var2, WorklogInputParameters var3);

    public abstract Worklog validateAndPerformAndLeaveEstimate(JiraServiceContext var1, Issue var2, WorklogInputParameters var3);

    public abstract Worklog validateAndPerformAndAutoAdjustEstimate(JiraServiceContext var1, Issue var2, WorklogInputParameters var3);

    public abstract Worklog validateAndPerformAndManualAdjustEstimate(JiraServiceContext var1, Issue var2, WorklogInputParameters var3);

    public abstract Response prepareSuccessfulResponse(WorklogJsonBean var1);

    private static void addAdjustmentParams(IssueWorklogResource.WorklogAdjustmentRequest adjustment, WorklogInputParametersImpl.Builder builder, com.atlassian.jira.util.ErrorCollection errors, WorklogOperation operation, JiraServiceContext serviceContext) {
        if (adjustment.getModeString() != null && adjustment.getMode() == null) {
            errors.addError("adjustEstimate", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.invalid", Arrays.toString(WorklogSystemField.WorklogValue.AdjustEstimate.values())));
            return;
        }
        WorklogSystemField.WorklogValue.AdjustEstimate mode = adjustment.getMode() != null ? adjustment.getMode() : WorklogSystemField.WorklogValue.AdjustEstimate.AUTO;
        switch (mode) {
            case NEW: {
                String newEstimate = adjustment.getNewEstimate();
                if (newEstimate == null) {
                    errors.addError("newEstimate", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.new.newEstimate.missing"));
                    break;
                }
                builder.newEstimate(newEstimate);
                break;
            }
            case MANUAL: {
                if (operation == EDIT) {
                    errors.addError("adjustEstimate", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.manual.notapplicableforedit"));
                    return;
                }
                if (operation == DELETE) {
                    String increaseBy = adjustment.getIncreaseBy();
                    if (increaseBy == null) {
                        errors.addError("increaseBy", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.manual.increaseBy.missing"));
                        break;
                    }
                    builder.adjustmentAmount(increaseBy);
                    break;
                }
                String reduceBy = adjustment.getReduceBy();
                if (reduceBy == null) {
                    errors.addError("reduceBy", serviceContext.getI18nBean().getText("rest.worklog.error.adjustEstimate.manual.reduceBy.missing"));
                    break;
                }
                builder.adjustmentAmount(reduceBy);
            }
        }
    }

    private static Worklog getAndValidateExistingWorklog(WorklogJsonBean request, com.atlassian.jira.util.ErrorCollection errors, JiraServiceContext serviceContext) {
        String id = request.getId();
        if (!errors.hasAnyErrors()) {
            if (id == null) {
                errors.addError("worklog", serviceContext.getI18nBean().getText("rest.worklog.error.id.missing"));
                return null;
            }
            Worklog existingWorklog = WorklogOperation.getWorklogService().getById(serviceContext, Long.valueOf(Long.parseLong(id)));
            if (existingWorklog == null) {
                throw new NotFoundWebException(ErrorCollection.of(serviceContext.getI18nBean().getText("worklog.service.error.no.worklog.for.id", id)));
            }
            return existingWorklog;
        }
        return null;
    }

    private static String getTimeLoggedString(long timeSpent) {
        BigDecimal hoursPerDay = WorklogOperation.getTimeTrackingConfiguration().getHoursPerDay();
        BigDecimal daysPerWeek = WorklogOperation.getTimeTrackingConfiguration().getDaysPerWeek();
        BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
        long secondsPerDay = hoursPerDay.multiply(secondsPerHour).longValueExact();
        long secondsPerWeek = daysPerWeek.multiply(hoursPerDay).multiply(secondsPerHour).longValueExact();
        return DateUtils.getDurationStringSeconds((long)timeSpent, (long)secondsPerDay, (long)secondsPerWeek);
    }

    private static TimeTrackingConfiguration getTimeTrackingConfiguration() {
        return (TimeTrackingConfiguration)ComponentAccessor.getComponent(TimeTrackingConfiguration.class);
    }

    private static WorklogService getWorklogService() {
        return (WorklogService)ComponentAccessor.getComponent(WorklogService.class);
    }

    private static ProjectRoleManager getProjectRoleManager() {
        return (ProjectRoleManager)ComponentAccessor.getComponent(ProjectRoleManager.class);
    }
}

