/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.worklog;

import com.atlassian.jira.rest.v2.issue.worklog.WorklogChangeBean;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class WorklogChangedSinceBean {
    private final List<WorklogChangeBean> values;
    @Schema(example="1438013671562")
    private final Long since;
    @Schema(example="1438013693136")
    private final Long until;
    @Schema(example="true")
    private final boolean isLastPage;
    @Schema(example="http://www.example.com/jira/rest/api/2/worklog/updated?since=1438013671136")
    private final URI self;
    @Schema(example="http://www.example.com/jira/rest/api/2/worklog/updated?since=1438013693136")
    private final URI nextPage;

    public WorklogChangedSinceBean(URI nextPage, boolean isLastPage, URI self, Long since, Long until, List<WorklogChangeBean> values) {
        this.nextPage = nextPage;
        this.isLastPage = isLastPage;
        this.self = self;
        this.since = since;
        this.until = until;
        this.values = values;
    }

    public List<WorklogChangeBean> getValues() {
        return this.values;
    }

    public Long getSince() {
        return this.since;
    }

    public Long getUntil() {
        return this.until;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public URI getSelf() {
        return this.self;
    }

    public URI getNextPage() {
        return this.nextPage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<WorklogChangeBean> values;
        private Long since;
        private Long until;
        private boolean isLastPage;
        private URI self;
        private URI nextPage;

        public Builder setValues(List<WorklogChangeBean> values) {
            this.values = values;
            return this;
        }

        public Builder setSince(Long since) {
            this.since = since;
            return this;
        }

        public Builder setUntil(Long until) {
            this.until = until;
            return this;
        }

        public Builder setIsLastPage(boolean isLastPage) {
            this.isLastPage = isLastPage;
            return this;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder setNextPage(URI nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public WorklogChangedSinceBean build() {
            return new WorklogChangedSinceBean(this.nextPage, this.isLastPage, this.self, this.since, this.until, this.values);
        }
    }
}

