/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.users;

import com.atlassian.jira.rest.v2.issue.users.IssueInvolvementBean;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
public class UserIssueRelevanceBean {
    @XmlElement
    @Schema(example="http://www.example.com/jira/rest/api/2/user?username=fred")
    private URI self;
    @XmlElement
    @Schema(example="fred")
    private String key;
    @XmlElement
    @Schema(example="fred")
    private String name;
    @XmlElement
    @Schema(example="fred@example.com")
    private String emailAddress;
    @XmlElement
    @Schema(example="{16x16=http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred, 24x24=http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred, 32x32=http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred, 48x48=http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred}")
    private Map<String, URI> avatarUrls;
    @XmlElement
    @Schema(example="Fred F. User")
    private String displayName;
    @XmlElement
    @Schema(example="true")
    private boolean active;
    @XmlElement
    @Schema(example="Australia/Sydney")
    private String timeZone;
    @XmlElement
    @Schema(example="en_US")
    private String locale;
    @XmlElement
    private List<IssueInvolvementBean> issueInvolvements;
    @XmlElement
    @Schema(example="0")
    private Integer highestIssueInvolvementRank;
    @XmlElement
    @Schema(example="1458688056272")
    private Long latestCommentCreationTime;

    UserIssueRelevanceBean() {
    }

    public UserIssueRelevanceBean(URI self, String key, String name, String displayName, boolean active, String emailAddress, Map<String, URI> avatarUrls, TimeZone timeZone, Locale locale, List<IssueInvolvementBean> issueInvolvements, Optional<Integer> highestIssueInvolvementRank, Optional<Date> latestCommentCreationTime) {
        this.self = Objects.requireNonNull(self);
        this.key = Objects.requireNonNull(key);
        this.name = Objects.requireNonNull(name);
        this.displayName = Objects.requireNonNull(displayName);
        this.active = active;
        this.emailAddress = emailAddress;
        this.avatarUrls = Objects.requireNonNull(avatarUrls);
        this.timeZone = timeZone != null ? timeZone.getID() : null;
        this.locale = locale != null ? locale.toString() : null;
        this.issueInvolvements = ImmutableList.copyOf(issueInvolvements);
        this.highestIssueInvolvementRank = highestIssueInvolvementRank.orElse(null);
        this.latestCommentCreationTime = latestCommentCreationTime.map(Date::getTime).orElse(null);
    }

    public UserIssueRelevanceBean(String name, String displayName, String emailAddress, Map<String, URI> avatarUrls) {
        this.name = Objects.requireNonNull(name);
        this.displayName = Objects.requireNonNull(displayName);
        this.emailAddress = emailAddress;
        this.avatarUrls = Objects.requireNonNull(avatarUrls);
    }

    public URI getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Map<String, URI> getAvatarUrls() {
        return this.avatarUrls;
    }

    public List<IssueInvolvementBean> getIssueInvolvements() {
        return this.issueInvolvements;
    }

    public Integer getHighestIssueInvolvementRank() {
        return this.highestIssueInvolvementRank;
    }

    public Long getLatestCommentCreationTime() {
        return this.latestCommentCreationTime;
    }
}

