/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.project.ActorInputBean;
import com.atlassian.jira.rest.v2.issue.project.CreateUpdateRoleRequestBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleActorsBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.DefaultRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Either;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="role")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@LicensedOnly
public class RoleResource {
    private final ProjectRoleService projectRoleService;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private final ResponseFactory responses;
    private final I18nHelper i18n;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;

    @Inject
    public RoleResource(ProjectRoleService projectRoleService, ProjectRoleBeanFactory projectRoleBeanFactory, ResponseFactory responses, I18nHelper i18n, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager) {
        this.projectRoleService = projectRoleService;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.responses = responses;
        this.i18n = i18n;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @GET
    @Operation(summary="Get all project roles", description="Get all the ProjectRoles available in Jira. Currently this list is global.", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns full details of the roles available in Jira.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403")})
    public Response getProjectRoles() {
        ArrayList<ProjectRoleBean> roles = new ArrayList<ProjectRoleBean>();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection projectRoles = this.projectRoleService.getProjectRoles((ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return this.responses.errorResponse((ErrorCollection)errorCollection);
        }
        for (ProjectRole projectRole : projectRoles) {
            DefaultRoleActors actors = this.projectRoleService.getDefaultRoleActors(projectRole, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return this.responses.errorResponse((ErrorCollection)errorCollection);
            }
            roles.add(this.projectRoleBeanFactory.projectRole(projectRole, actors));
        }
        return Response.ok(roles).build();
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get a specific project role", description="Get a specific ProjectRole available in Jira.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The role id", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns full details of the role available in Jira.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404")})
    public Response getProjectRolesById(@PathParam(value="id") long roleId) {
        return (Response)this.getProjectRole(roleId).left().on(projectRole -> (Response)this.withDefaultRoleActors((ProjectRole)projectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

            @Override
            @Nullable
            public Response apply(@Nullable DefaultRoleActors defaultRoleActors) {
                return Response.ok((Object)RoleResource.this.projectRoleBeanFactory.projectRole(projectRole, defaultRoleActors)).build();
            }
        }));
    }

    @POST
    @Operation(summary="Create a new project role", description="Creates a new ProjectRole to be available in Jira. The created role does not have any default actors assigned.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="The role to create", required=true, content={@Content(schema=@Schema(implementation=CreateUpdateRoleRequestBean.class))})
    @ApiResponses(value={@ApiResponse(description="Returns full details of the created role", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request json does not have a name field or the name field is invalid (empty or starts or ends with whitespace)", responseCode="400"), @ApiResponse(description="Returned if you are not logged in.", responseCode="401"), @ApiResponse(description="Returned if you do not have permissions to create a role.", responseCode="403"), @ApiResponse(description="Returned if a role with given name already exists.", responseCode="409")})
    public Response createProjectRole(CreateUpdateRoleRequestBean inputBean) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String description = inputBean.getDescription() == null ? "" : inputBean.getDescription();
        ProjectRole projectRole = this.projectRoleService.createProjectRole((ProjectRole)new ProjectRoleImpl(inputBean.getName(), description), (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return this.responses.errorResponse((ErrorCollection)errorCollection);
        }
        DefaultRoleActorsImpl actors = new DefaultRoleActorsImpl(projectRole.getId(), Collections.emptySet());
        return Response.ok((Object)this.projectRoleBeanFactory.projectRole(projectRole, (DefaultRoleActors)actors)).build();
    }

    @POST
    @Path(value="{id}")
    @Operation(summary="Partially updates a role's name or description", description="Partially updates a roles name or description.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The role id", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns updated role.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned when both name and description are not given or name field is invalid (empty or starts or ends with whitespace).", responseCode="400"), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404")})
    public Response partialUpdateProjectRole(@PathParam(value="id") long roleId, final CreateUpdateRoleRequestBean updateProjectRoleBean) {
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            @Nullable
            public Response apply(@Nullable ProjectRole projectRole) {
                RoleResource.this.validatePartialUpdate(updateProjectRoleBean, errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                ProjectRole updatedProjectRole = RoleResource.this.getPartiallyUpdatedProjectRole(projectRole, updateProjectRoleBean);
                RoleResource.this.projectRoleService.updateProjectRole(updatedProjectRole, (ErrorCollection)errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                return (Response)RoleResource.this.withDefaultRoleActors(updatedProjectRole).left().on(defaultRoleActors -> Response.ok((Object)RoleResource.this.projectRoleBeanFactory.projectRole(updatedProjectRole, (DefaultRoleActors)defaultRoleActors)).build());
            }
        });
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Fully updates a role's name and description", description="Fully updates a roles. Both name and description must be given.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The role id", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns updated role.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned when name or description is not given or the name field is invalid (empty or starts or ends with whitespace).", responseCode="400"), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404")})
    public Response fullyUpdateProjectRole(final @PathParam(value="id") long roleId, final CreateUpdateRoleRequestBean updateProjectRoleBean) {
        final SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on((Function)new Function<ProjectRole, Response>(){

            @Override
            @Nullable
            public Response apply(@Nullable ProjectRole projectRole) {
                RoleResource.this.validateFullUpdate(updateProjectRoleBean, errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                final ProjectRole updatedProjectRole = ProjectRoleImpl.Builder.from((ProjectRole)projectRole).id(Long.valueOf(roleId)).name(updateProjectRoleBean.getName()).description(updateProjectRoleBean.getDescription()).build();
                RoleResource.this.projectRoleService.updateProjectRole(updatedProjectRole, (ErrorCollection)errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return RoleResource.this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                return (Response)RoleResource.this.withDefaultRoleActors(updatedProjectRole).left().on((Function)new Function<DefaultRoleActors, Response>(){

                    @Override
                    @Nullable
                    public Response apply(@Nullable DefaultRoleActors defaultRoleActors) {
                        return Response.ok((Object)RoleResource.this.projectRoleBeanFactory.projectRole(updatedProjectRole, defaultRoleActors)).build();
                    }
                });
            }
        });
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Deletes a role", description="Deletes a role. May return 403 in the future", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The role id", required=true), @Parameter(name="swap", description="If given, removes a role even if it is used in scheme by replacing the role with the given one")})
    @ApiResponses(value={@ApiResponse(description="Returned if the delete was successful.", responseCode="204"), @ApiResponse(description="Returned if given role with given swap id does not exist.", responseCode="400"), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404"), @ApiResponse(description="Returned if the project role is used in schemes and roleToSwap query parameter is not given.", responseCode="409")})
    public Response deleteProjectRole(@PathParam(value="id") long roleId, @QueryParam(value="swap") Long roleIdToSwap) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on(projectRole -> {
            if (roleIdToSwap == null) {
                ServiceResult serviceResult = this.projectRoleService.validateNoRoleUsage(projectRole);
                if (!serviceResult.isValid()) {
                    return this.responses.errorResponse(serviceResult.getErrorCollection());
                }
            } else {
                ProjectRole roleToSwap = this.projectRoleService.getProjectRole(roleIdToSwap, (ErrorCollection)errorCollection);
                if (roleToSwap == null) {
                    errorCollection.addErrorMessage("rest.swap.role.not.found", ErrorCollection.Reason.VALIDATION_FAILED);
                }
                if (errorCollection.hasAnyErrors()) {
                    return this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                this.projectRoleService.swapRole(projectRole, roleToSwap);
            }
            this.projectRoleService.deleteProjectRole(projectRole, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return this.responses.errorResponse((ErrorCollection)errorCollection);
            }
            return Response.noContent().build();
        });
    }

    @GET
    @Path(value="{id}/actors")
    @Operation(summary="Get default actors for a role", description="Gets default actors for the given role.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The role id", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns actor list.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleActorsBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404")})
    public Response getProjectRoleActorsForRole(@PathParam(value="id") long roleId) {
        return (Response)this.getProjectRole(roleId).left().on(projectRole -> (Response)this.withDefaultRoleActors((ProjectRole)projectRole).left().on(defaultRoleActors -> Response.ok((Object)ProjectRoleActorsBean.from(defaultRoleActors.getRoleActors())).build()));
    }

    @POST
    @Path(value="{id}/actors")
    @Operation(summary="Adds default actors to a role", description="Adds default actors to the given role. The request data should contain a list of usernames or a list of groups to add.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="The role id", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns actor list.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleActorsBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request json does not have a user or group field or both user and group fields are given.", responseCode="400"), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404")})
    public Response addProjectRoleActorsToRole(@PathParam(value="id") long roleId, ActorInputBean actorsInput) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return (Response)this.getProjectRole(roleId).left().on(projectRole -> (Response)this.withValidationOfActorInputBean(actorsInput).left().on(validationResult -> {
            this.projectRoleService.addDefaultActorsToProjectRole((Collection)validationResult.roleEntity, projectRole, validationResult.roleType, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return this.responses.errorResponse((ErrorCollection)errorCollection);
            }
            return (Response)this.withDefaultRoleActors((ProjectRole)projectRole).left().on(defaultRoleActors -> Response.ok((Object)ProjectRoleActorsBean.from(defaultRoleActors.getRoleActors())).build());
        }));
    }

    @DELETE
    @Path(value="{id}/actors")
    @Operation(summary="Removes default actor from a role", description="Removes default actor from the given role.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="id", description="The role id to remove the actors from", required=true), @Parameter(name="user", description="If given, removes an actor from given role"), @Parameter(name="group", description="If given, removes an actor from given role")})
    @ApiResponses(value={@ApiResponse(description="Returns updated actors list.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleActorsBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if user and group are not given, both user and group are given or provided group or user does not exist.", responseCode="400"), @ApiResponse(description="Returned if the requesting user is not logged in.", responseCode="401"), @ApiResponse(description="Returned if the requesting user is not an admin or a sysadmin.", responseCode="403"), @ApiResponse(description="Returned if the role with the given id does not exist.", responseCode="404")})
    public Response deleteProjectRoleActorsFromRole(@PathParam(value="id") long roleId, @QueryParam(value="user") String user, @QueryParam(value="group") String group) {
        return (Response)this.getProjectRole(roleId).left().on(projectRole -> {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            return (Response)this.withValidationOfInputUserNamesAndGroupNames(user, group).left().on(validationResult -> {
                this.projectRoleService.removeDefaultActorsFromProjectRole(Collections.singleton((String)validationResult.roleEntity), projectRole, validationResult.roleType, (ErrorCollection)errorCollection);
                if (errorCollection.hasAnyErrors()) {
                    return this.responses.errorResponse((ErrorCollection)errorCollection);
                }
                return (Response)this.withDefaultRoleActors((ProjectRole)projectRole).left().on(defaultRoleActors -> Response.ok((Object)ProjectRoleActorsBean.from(defaultRoleActors.getRoleActors())).build());
            });
        });
    }

    private void validateFullUpdate(CreateUpdateRoleRequestBean updateProjectRoleBean, SimpleErrorCollection errorCollection) {
        if (updateProjectRoleBean.getName() == null || updateProjectRoleBean.getDescription() == null) {
            errorCollection.addErrorMessage(this.i18n.getText("rest.role.name.and.description.required"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private ProjectRole getPartiallyUpdatedProjectRole(ProjectRole projectRole, CreateUpdateRoleRequestBean updateProjectRoleBean) {
        ProjectRoleImpl.Builder builder = ProjectRoleImpl.Builder.from((ProjectRole)projectRole).id(projectRole.getId());
        if (updateProjectRoleBean.getName() != null) {
            builder.name(updateProjectRoleBean.getName());
        } else {
            builder.description(updateProjectRoleBean.getDescription());
        }
        return builder.build();
    }

    private void validatePartialUpdate(CreateUpdateRoleRequestBean updateProjectRoleBean, SimpleErrorCollection errorCollection) {
        if (updateProjectRoleBean.getName() == null && updateProjectRoleBean.getDescription() == null) {
            errorCollection.addErrorMessage(this.i18n.getText("rest.role.name.or.description.required"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Nonnull
    private Either<Response, ProjectRole> getProjectRole(long roleId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.hasAdminPermission(this.authContext.getLoggedInUser())) {
            return Either.left((Object)this.responses.forbidden("rest.authorization.admin.required", new String[0]));
        }
        ProjectRole projectRole = this.projectRoleService.getProjectRole(Long.valueOf(roleId), (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)this.responses.errorResponse((ErrorCollection)errorCollection));
        }
        if (projectRole == null) {
            return Either.left((Object)this.responses.notFound("rest.role.not.found", new String[0]));
        }
        return Either.right((Object)projectRole);
    }

    @Nonnull
    private Either<Response, DefaultRoleActors> withDefaultRoleActors(ProjectRole projectRole) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        DefaultRoleActors actors = this.projectRoleService.getDefaultRoleActors(projectRole, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)this.responses.errorResponse((ErrorCollection)errorCollection));
        }
        return Either.right((Object)actors);
    }

    private boolean hasAdminPermission(ApplicationUser currentUser) {
        return this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser);
    }

    private Either<Response, ValidationActorsResult<Collection<String>>> withValidationOfActorInputBean(ActorInputBean actorsInput) {
        return this.withValidationOfInputUserNamesAndGroupNames(actorsInput.getUsernames(), actorsInput.getGroupnames());
    }

    private <T> Either<Response, ValidationActorsResult<T>> withValidationOfInputUserNamesAndGroupNames(T usernames, T groupnames) {
        if (usernames != null && groupnames != null) {
            return Either.left((Object)this.responses.badRequest("rest.role.actors.add.username.or.groupname.both.cannot.be.provided", new String[0]));
        }
        if (usernames != null) {
            return Either.right(new ValidationActorsResult<T>("atlassian-user-role-actor", usernames));
        }
        if (groupnames != null) {
            return Either.right(new ValidationActorsResult<T>("atlassian-group-role-actor", groupnames));
        }
        return Either.left((Object)this.responses.badRequest("rest.role.actors.delete.username.or.groupname.required", new String[0]));
    }

    private static class ValidationActorsResult<T> {
        private final String roleType;
        private final T roleEntity;

        private ValidationActorsResult(String roleType, T roleEntity) {
            this.roleType = roleType;
            this.roleEntity = roleEntity;
        }
    }
}

