/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

public class ProjectUpdateBean {
    @JsonProperty
    @Schema(example="EX")
    private String key;
    @JsonProperty
    @Schema(example="Example")
    private String name;
    @JsonProperty
    @Schema(example="business")
    private String projectTypeKey;
    @JsonProperty
    @Schema(example="com.atlassian.jira-core-project-templates:jira-core-project-management")
    private String projectTemplateKey;
    @JsonProperty
    @Schema(example="Example Project description")
    private String description;
    @JsonProperty
    @Schema(example="Charlie")
    private String lead;
    @JsonProperty
    @Schema(example="http://atlassian.com")
    private String url;
    @JsonProperty
    @Schema(example="PROJECT_LEAD")
    private ProjectBean.AssigneeType assigneeType;
    @JsonProperty
    @Schema(example="10200")
    private Long avatarId;
    @JsonProperty
    @Schema(example="10001")
    private Long issueSecurityScheme;
    @JsonProperty
    @Schema(example="10011")
    private Long permissionScheme;
    @JsonProperty
    @Schema(example="10021")
    private Long notificationScheme;
    @JsonProperty
    @Schema(example="10120")
    private Long categoryId;

    public ProjectUpdateBean(String key, String name, String projectTypeKey, String projectTemplateKey, String description, String lead, String url, ProjectBean.AssigneeType assigneeType, Long avatarId, Long issueSecurityScheme, Long permissionScheme, Long notificationScheme, Long categoryId) {
        this.key = key;
        this.name = name;
        this.projectTypeKey = projectTypeKey;
        this.projectTemplateKey = projectTemplateKey;
        this.description = description;
        this.lead = lead;
        this.url = url;
        this.assigneeType = assigneeType;
        this.avatarId = avatarId;
        this.issueSecurityScheme = issueSecurityScheme;
        this.permissionScheme = permissionScheme;
        this.notificationScheme = notificationScheme;
        this.categoryId = categoryId;
    }

    public ProjectUpdateBean() {
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public String getProjectTemplateKey() {
        return this.projectTemplateKey;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLead() {
        return this.lead;
    }

    public String getUrl() {
        return this.url;
    }

    public ProjectBean.AssigneeType getAssigneeType() {
        return (ProjectBean.AssigneeType)((Object)MoreObjects.firstNonNull((Object)((Object)this.assigneeType), (Object)((Object)ProjectBean.AssigneeType.PROJECT_LEAD)));
    }

    @JsonIgnore
    public Long getAssigneeTypeOrNull() {
        return this.assigneeType != null ? Long.valueOf(this.assigneeType.getId()) : null;
    }

    public Long getAvatarId() {
        return this.avatarId;
    }

    public Long getIssueSecurityScheme() {
        return this.issueSecurityScheme;
    }

    public Long getPermissionScheme() {
        return this.permissionScheme;
    }

    public Long getNotificationScheme() {
        return this.notificationScheme;
    }

    @JsonIgnore
    public boolean isSchemesUpdate() {
        return this.issueSecurityScheme != null || this.permissionScheme != null || this.notificationScheme != null;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String key;
        private String name;
        private String description;
        private String leadName;
        private String url;
        private ProjectBean.AssigneeType defaultAssignee;
        private Long avatarId;
        private Long issueSecurityScheme;
        private Long permissionScheme;
        private Long notificationScheme;
        private Long categoryId;
        private String projectTypeKey;
        private String projectTemplateKey;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setLeadName(String leadName) {
            this.leadName = leadName;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setAssigneeType(ProjectBean.AssigneeType defaultAssignee) {
            this.defaultAssignee = defaultAssignee;
            return this;
        }

        public Builder setAvatarId(Long avatarId) {
            this.avatarId = avatarId;
            return this;
        }

        public Builder setIssueSecurityScheme(Long issueSecurityScheme) {
            this.issueSecurityScheme = issueSecurityScheme;
            return this;
        }

        public Builder setPermissionScheme(Long permissionScheme) {
            this.permissionScheme = permissionScheme;
            return this;
        }

        public Builder setNotificationScheme(Long notificationScheme) {
            this.notificationScheme = notificationScheme;
            return this;
        }

        public Builder setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder setProjectTypeKey(String projectTypeKey) {
            this.projectTypeKey = projectTypeKey;
            return this;
        }

        public Builder setProjectTemplateKey(String projectTemplateKey) {
            this.projectTemplateKey = projectTemplateKey;
            return this;
        }

        public ProjectUpdateBean build() {
            return new ProjectUpdateBean(this.key, this.name, this.projectTypeKey, this.projectTemplateKey, this.description, this.leadName, this.url, this.defaultAssignee, this.avatarId, this.issueSecurityScheme, this.permissionScheme, this.notificationScheme, this.categoryId);
        }
    }
}

