/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleActorsUpdateBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="project/{projectIdOrKey}/role")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectRoleResource {
    ProjectRoleService projectRoleService;
    AvatarService avatarService;
    ProjectFinder projectFinder;
    JiraAuthenticationContext authContext;
    UriInfo uriInfo;
    UserManager userManager;
    ProjectRoleBeanFactory projectRoleBeanFactory;
    GroupManager groupManager;

    private ProjectRoleResource() {
    }

    @Inject
    public ProjectRoleResource(ProjectRoleService projectRoleService, AvatarService avatarService, ProjectFinder projectFinder, JiraAuthenticationContext authContext, UriInfo uriInfo, UserManager userManager, ProjectRoleBeanFactory projectRoleBeanFactory, GroupManager groupManager) {
        this.projectRoleService = projectRoleService;
        this.avatarService = avatarService;
        this.projectFinder = projectFinder;
        this.authContext = authContext;
        this.uriInfo = uriInfo;
        this.userManager = userManager;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.groupManager = groupManager;
    }

    @GET
    @Operation(summary="Get all roles in project", description="Returns all roles in the given project Id or key, with links to full details on each role.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="projectIdOrKey", description="The project id or project key", required=true)
    @ApiResponses(value={@ApiResponse(description="List of roles and URIs to full details", responseCode="200"), @ApiResponse(description="Returned if the project is not found, or the calling user does not have permission to view it.", responseCode="404")})
    public Response getProjectRoles(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        HashMap<String, URI> roles = new HashMap<String, URI>();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection projectRoles = this.projectRoleService.getProjectRoles((com.atlassian.jira.util.ErrorCollection)errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            for (ProjectRole projectRole : projectRoles) {
                URI uri = this.projectRoleBeanFactory.projectRole((Project)project, (ProjectRole)projectRole).self;
                roles.put(projectRole.getName(), uri);
            }
        }
        return Response.ok(roles).build();
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get details for a project role", description="Returns the details for a given project role in a project.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project id or project key", required=true), @Parameter(name="id", description="The project role id", required=true)})
    @ApiResponses(value={@ApiResponse(description="Role details and its actors", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project or role is not found, or the calling user does not have permission to view it.", responseCode="404")})
    public Response getProjectRole(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        SimpleErrorCollection projectActorsErrorCollection = new SimpleErrorCollection();
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(projectRole, project, (com.atlassian.jira.util.ErrorCollection)projectActorsErrorCollection);
        this.checkForErrors(projectActorsErrorCollection);
        ProjectRoleBean projectRoleBean = this.projectRoleBeanFactory.projectRole(project, projectRole, projectRoleActors, this.authContext.getUser());
        return Response.ok((Object)projectRoleBean).build();
    }

    @PUT
    @Path(value="{id}")
    @Operation(summary="Update project role with actors", description="Updates a project role to include the specified actors (users or groups). Can be also used to clear roles to not include any users or groups. For user actors, their usernames should be used.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project id or project key", required=true), @Parameter(name="id", description="The project role id", required=true)})
    @RequestBody(description="The actors to set for the role", required=true, content={@Content(schema=@Schema(implementation=ProjectRoleActorsUpdateBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Role details and its actors after modification", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the actor could not be added to the project role", responseCode="404")})
    public Response setActors(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id, ProjectRoleActorsUpdateBean actors) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        Map<String, String[]> simpleActors = actors.getCategorisedActors();
        String[] usernames = simpleActors.get("atlassian-user-role-actor");
        String[] groupnames = simpleActors.get("atlassian-group-role-actor");
        if (usernames == null && groupnames == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set<String> userKeys = this.userkeysFromUsernames(usernames);
        Set<String> existingGroupnames = this.existingGroupNames(groupnames);
        HashMap newRoleActors = Maps.newHashMap();
        newRoleActors.put("atlassian-user-role-actor", userKeys);
        newRoleActors.put("atlassian-group-role-actor", existingGroupnames);
        SimpleErrorCollection setActorErrorCollection = new SimpleErrorCollection();
        this.projectRoleService.setActorsForProjectRole((Map)newRoleActors, projectRole, project, (com.atlassian.jira.util.ErrorCollection)setActorErrorCollection);
        this.checkForErrors(setActorErrorCollection);
        return this.getProjectRole(projectIdOrKey, id);
    }

    @POST
    @Path(value="{id}")
    @Operation(summary="Add actor to project role", description="Adds an actor (user or group) to a project role. For user actors, their usernames should be used.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project id or project key", required=true), @Parameter(name="id", description="The project role id", required=true)})
    @RequestBody(description="The actors to add to the role", required=true, content={@Content(schema=@Schema(implementation=ActorsMap.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Role details and its actors after modification", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectRoleBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the project or role is not found, the calling user does not have permission to view it or does not have permission to modify the actors in the project role.", responseCode="404"), @ApiResponse(description="Returned if none of the specified groups and users exist.", responseCode="410")})
    public Response addActorUsers(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id, ActorsMap actors) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        String[] usernames = (String[])actors.get("user");
        String[] groupnames = (String[])actors.get("group");
        if (usernames == null && groupnames == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set<String> userKeys = this.userkeysFromUsernames(usernames);
        Set<String> existingGroupnames = this.existingGroupNames(groupnames);
        if (userKeys.isEmpty() && existingGroupnames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        if (!userKeys.isEmpty()) {
            SimpleErrorCollection addActorUserErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.addActorsToProjectRole(userKeys, projectRole, project, "atlassian-user-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorUserErrorCollection);
            this.checkForErrors(addActorUserErrorCollection);
        }
        if (!existingGroupnames.isEmpty()) {
            SimpleErrorCollection addActorGroupnameErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.addActorsToProjectRole(existingGroupnames, projectRole, project, "atlassian-group-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorGroupnameErrorCollection);
            this.checkForErrors(addActorGroupnameErrorCollection);
        }
        return this.getProjectRole(projectIdOrKey, id);
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Delete actors from project role", description="Deletes actors (users or groups) from a project role.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="projectIdOrKey", description="The project id or project key", required=true), @Parameter(name="id", description="The project role id", required=true), @Parameter(name="user", description="The user name of the user to remove from the project role. Use either user or group, but not both"), @Parameter(name="group", description="The group name to remove from the project role. Use either user or group, but not both")})
    @ApiResponses(value={@ApiResponse(description="No content on success", responseCode="204"), @ApiResponse(description="Returned if the project or role is not found, the calling user does not have permission to view it or does not have permission to modify the actors in the project role.", responseCode="404"), @ApiResponse(description="Returned if none of the specified groups and users exist.", responseCode="410")})
    public Response deleteActor(@PathParam(value="projectIdOrKey") String projectIdOrKey, @PathParam(value="id") Long id, @QueryParam(value="user") String username, @QueryParam(value="group") String groupname) {
        Project project = this.getProjectByIdOrKey(projectIdOrKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = this.projectRoleService.getProjectRole(id, (com.atlassian.jira.util.ErrorCollection)errorCollection);
        this.checkForErrors(errorCollection);
        if (username == null && groupname == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Set<String> userKeys = this.userkeysFromUsernames(username);
        Set<String> existingGroupnames = this.existingGroupNames(groupname);
        if (userKeys.isEmpty() && existingGroupnames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        if (!userKeys.isEmpty()) {
            SimpleErrorCollection addActorUserErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.removeActorsFromProjectRole(userKeys, projectRole, project, "atlassian-user-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorUserErrorCollection);
            this.checkForErrors(addActorUserErrorCollection);
        }
        if (!existingGroupnames.isEmpty()) {
            SimpleErrorCollection addActorGroupnameErrorCollection = new SimpleErrorCollection();
            this.projectRoleService.removeActorsFromProjectRole(existingGroupnames, projectRole, project, "atlassian-group-role-actor", (com.atlassian.jira.util.ErrorCollection)addActorGroupnameErrorCollection);
            this.checkForErrors(addActorGroupnameErrorCollection);
        }
        return Response.noContent().build();
    }

    private Set<String> userkeysFromUsernames(String ... usernames) {
        if (usernames != null) {
            return Arrays.stream(usernames).map(arg_0 -> ((UserManager)this.userManager).getUserByName(arg_0)).filter(Objects::nonNull).map(ApplicationUser::getKey).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Set<String> existingGroupNames(String ... groupnames) {
        if (groupnames != null) {
            return Arrays.stream(groupnames).filter(Objects::nonNull).filter(group -> this.groupManager.groupExists(group)).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Project getProjectByIdOrKey(String projectIdOrKey) {
        ProjectService.GetProjectResult result = this.projectFinder.getGetProjectForActionByIdOrKey(this.authContext.getUser(), projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (result.getErrorCollection().hasAnyErrors()) {
            ErrorCollection errors = ErrorCollection.of(result.getErrorCollection());
            if (result.getErrorCollection().getReasons().contains(ErrorCollection.Reason.FORBIDDEN)) {
                throw new NotAuthorisedWebException(errors);
            }
            throw new NotFoundWebException(errors);
        }
        return result.getProject();
    }

    private void checkForErrors(SimpleErrorCollection errorCollection) {
        if (errorCollection.hasAnyErrors()) {
            throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
        }
    }

    public static class ActorsMap
    extends HashMap<String, String[]> {
    }
}

