/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.project.ProjectPicker;
import com.atlassian.jira.rest.v2.issue.project.ProjectPickerItem;
import com.atlassian.jira.rest.v2.issue.project.ProjectPickerResultWrapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="projects/picker")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectPickerResource {
    @VisibleForTesting
    static final String MORE_RESULTS_I18N_KEY = "jira.ajax.autocomplete.project.more.results";
    private static final int DEFAULT_MAX_LIMIT = 100;
    private final ProjectPicker projectPicker;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    @Inject
    public ProjectPickerResource(ProjectPicker projectPicker, JiraAuthenticationContext authenticationContext) {
        this.projectPicker = projectPicker;
        this.authenticationContext = authenticationContext;
    }

    @GET
    @Operation(summary="Get projects matching query", description="Returns a list of projects visible to the user where project name and/or key is matching the given query.\nPassing an empty (or whitespace only) query will match no projects. The project matches will\ncontain a field with the query highlighted.\nThe number of projects returned can be controlled by passing a value for 'maxResults', but a hard limit of no\nmore than 100 projects is enforced. The projects are wrapped in a single response object that contains\na header for use in the picker, specifically 'Showing X of Y matching projects' and the total number\nof matches for the query.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="query", description="A sequence of characters expected to be found in the word-prefix of project name and/or key.", required=false), @Parameter(name="maxResults", description="Maximum number of matches to return. Zero means a default limit of 100 and negative numbers return no results.", required=false), @Parameter(name="allowEmptyQuery", description="If true, and the query is empty, the method will return first results limited to the value of 'maxResults' or default limit of 100.", required=false)})
    @ApiResponse(description="Returned even when no projects match the given query.", responseCode="200", content={@Content(schema=@Schema(implementation=ProjectPickerResultWrapper.class), mediaType="application/json")})
    public Response searchForProjects(@QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="maxResults") @DefaultValue(value="0") int maxResults, @QueryParam(value="allowEmptyQuery") @DefaultValue(value="false") boolean allowEmptyQuery) {
        List<ProjectPickerItem> matchedProjects = this.projectPicker.findProjects(query, allowEmptyQuery);
        int matchedProjectsCount = matchedProjects.size();
        int limit = ProjectPickerResource.resolveLimit(maxResults);
        List<ProjectPickerItem> matchingProjectEntries = matchedProjects.subList(0, Math.min(limit, matchedProjectsCount));
        ProjectPickerResultWrapper result = new ProjectPickerResultWrapper(matchingProjectEntries, matchedProjectsCount, this.getHeader(matchingProjectEntries.size(), matchedProjectsCount));
        return Response.ok((Object)result).cacheControl(CacheControl.never()).build();
    }

    private String getHeader(int currentSize, int maxSize) {
        return this.authenticationContext.getI18nHelper().getText(MORE_RESULTS_I18N_KEY, String.valueOf(currentSize), String.valueOf(maxSize));
    }

    private static int resolveLimit(int maxResults) {
        if (maxResults < 0) {
            return 0;
        }
        if (maxResults == 0) {
            return 100;
        }
        return Math.min(100, maxResults);
    }
}

