/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.project.ProjectPicker;
import com.atlassian.jira.rest.v2.issue.project.ProjectPickerItem;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectPickerImpl
implements ProjectPicker {
    private static final String VALID_QUERY_MATCH_REGEX_PATTERN = "(^|.*?(\\s+|\\())(%s)(.*)";
    private static final String ALLOWED_PREFIX_CHARACTERS = "(";
    private static final String STRONG_OPEN_TAG = "<strong>";
    private static final String STRONG_CLOSED_TAG = "</strong>";
    private static final String HTML_MATCH_PATTERN = "%s&nbsp;(%s)";
    private static final DelimeterInserter delimeterInserter = DelimeterInserter.builder().setFrontDelimeter("<strong>").setEndDelimeter("</strong>").setPrefixMode(true).setCaseInsensitive(true).setPrefixNonRepeatableMatch(true).setConsideredWhitespace("(").build();
    private final InternalProjectPermissionHelper projectPermissionHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;

    @Autowired
    public ProjectPickerImpl(@ComponentImport InternalProjectPermissionHelper projectPermissionHelper, JiraAuthenticationContext authenticationContext, AvatarService avatarService) {
        this.projectPermissionHelper = projectPermissionHelper;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
    }

    @Override
    @Nonnull
    public List<ProjectPickerItem> findProjects(@Nonnull String query, boolean allowEmptyQuery) {
        String trimmedQuery = ProjectPickerImpl.trimOrThrow(query);
        if (!allowEmptyQuery && trimmedQuery.isEmpty()) {
            return Collections.emptyList();
        }
        Pattern pattern = this.createProjectMatchingPattern(trimmedQuery);
        return this.getProjectsVisibleForLoggedInUser().stream().filter(project -> ProjectPickerImpl.projectMatches(pattern, project)).map(project -> this.toProjectResult((Project)project, trimmedQuery)).collect(Collectors.toList());
    }

    private Pattern createProjectMatchingPattern(String query) {
        String regex = String.format(VALID_QUERY_MATCH_REGEX_PATTERN, Pattern.quote(query));
        return Pattern.compile(regex, 66);
    }

    private static String trimOrThrow(String query) {
        if (query == null) {
            throw new IllegalArgumentException("Parameter \"query\" must not be null");
        }
        return query.trim();
    }

    private Collection<Project> getProjectsVisibleForLoggedInUser() {
        return this.projectPermissionHelper.getBrowsableProjects(this.authenticationContext.getLoggedInUser());
    }

    private static boolean projectMatches(Pattern pattern, Project project) {
        return pattern.matcher(project.getKey()).matches() || pattern.matcher(project.getName()).matches();
    }

    private static String toHtml(Project project, String query) {
        String[] termsToWrap = new String[]{query};
        return String.format(HTML_MATCH_PATTERN, delimeterInserter.insert(TextUtils.htmlEncode((String)project.getName()), termsToWrap), delimeterInserter.insert(TextUtils.htmlEncode((String)project.getKey()), termsToWrap));
    }

    private ProjectPickerItem toProjectResult(Project project, String query) {
        return new ProjectPickerItem(ProjectPickerImpl.toHtml(project, query), String.valueOf(project.getId()), project.getKey(), project.getName(), this.avatarService.getProjectAvatarAbsoluteURL(project, Avatar.Size.SMALL).toString());
    }
}

