/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import javax.validation.constraints.NotNull;

public class ProjectIdentity {
    @JsonProperty
    @Schema(example="http://example/jira/rest/api/2/project/10042")
    private URI self;
    @JsonProperty
    @Schema(example="10010")
    private Long id;
    @JsonProperty
    @Schema(example="EX")
    private String key;

    public ProjectIdentity() {
    }

    public ProjectIdentity(@NotNull URI self, @NotNull Long id, @NotNull String key) {
        this.self = (URI)Preconditions.checkNotNull((Object)self);
        this.id = (Long)Preconditions.checkNotNull((Object)id);
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public URI getSelf() {
        return this.self;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.self, this.id, this.key});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectIdentity other = (ProjectIdentity)obj;
        return Objects.equal((Object)this.self, (Object)other.self) && Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.key, (Object)other.key);
    }

    public String toString() {
        return "ProjectIdentity{self=" + this.self + ", id=" + this.id + ", key='" + this.key + "'}";
    }
}

