/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBeanBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="customFieldOption")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomFieldOptionResource {
    private JiraAuthenticationContext authContext;
    private OptionsManager optionsManager;
    private I18nHelper i18n;
    private UriInfo contextUriInfo;
    private FieldManager fieldManager;
    private PermissionManager permissionManager;

    private CustomFieldOptionResource() {
    }

    @Inject
    public CustomFieldOptionResource(JiraAuthenticationContext authContext, OptionsManager optionsManager, I18nHelper i18n, UriInfo contextUriInfo, FieldManager fieldManager, PermissionManager permissionManager) {
        this.authContext = authContext;
        this.i18n = i18n;
        this.contextUriInfo = contextUriInfo;
        this.optionsManager = optionsManager;
        this.fieldManager = fieldManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get custom field option by ID", description="Returns a full representation of the Custom Field Option that has the given id.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="a String containing an Custom Field Option id.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Returned if the Custom Field Option exists and is visible by the calling user.", responseCode="200", content={@Content(schema=@Schema(implementation=CustomFieldOptionBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the Custom Field Option does not exist, or is not visible to the calling user.", responseCode="404")})
    public Response getCustomFieldOption(@PathParam(value="id") String id) {
        Option option = null;
        try {
            option = this.optionsManager.findByOptionId(Long.valueOf(id));
        }
        catch (NumberFormatException e) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.custom.field.option.not.found", id)));
        }
        if (option == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.custom.field.option.not.found", id)));
        }
        CustomField customField = null;
        if (option.getRelatedCustomField() != null) {
            customField = option.getRelatedCustomField().getCustomField();
        }
        if (customField != null && this.isCustomFieldInvisibleForUser(customField)) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.custom.field.option.not.found", id)));
        }
        Response.ResponseBuilder rb = Response.ok((Object)new CustomFieldOptionBeanBuilder().context(this.contextUriInfo).customFieldOption(option).build());
        return rb.cacheControl(CacheControl.never()).build();
    }

    private boolean isCustomFieldInvisibleForUser(CustomField customField) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        return this.fieldManager.isFieldHidden(loggedInUser, (Field)customField) || !this.userHasPermissionToCustomFieldProjects(customField, loggedInUser);
    }

    private boolean userHasPermissionToCustomFieldProjects(CustomField customField, ApplicationUser user) {
        if (customField.isAllProjects()) {
            return this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user);
        }
        for (Project project : customField.getAssociatedProjectObjects()) {
            boolean hasAtLeastToOneProject = this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
            if (!hasAtLeastToOneProject) continue;
            return true;
        }
        return false;
    }
}

