/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.customfield;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.customfield.CustomFieldDefinitionJsonBean;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="customField")
public class CustomFieldBean
extends CustomFieldDefinitionJsonBean {
    @JsonProperty
    @Schema(example="10000")
    private Long numericId;
    @JsonProperty
    @Schema(example="false")
    private boolean isLocked;
    @JsonProperty
    @Schema(example="false")
    private boolean isManaged;
    @JsonProperty
    @Schema(example="false")
    private boolean isAllProjects;
    @JsonProperty
    @Schema(example="true")
    private boolean isTrusted;
    @JsonProperty
    @Schema(example="2")
    private int projectsCount;
    @JsonProperty
    @Schema(example="3")
    private int screensCount;
    @JsonProperty
    @Schema(example="2018-11-01T12:00:00.000Z")
    private Timestamp lastValueUpdate;
    @JsonProperty
    @Schema(example="100")
    private Long issuesWithValue;

    private CustomFieldBean() {
    }

    public CustomFieldBean(CustomField customField, URI self, int screensCount) {
        this(customField, self, screensCount, false, false, false);
    }

    public CustomFieldBean(CustomField customField, URI self, int screensCount, boolean isManaged, boolean isLocked, boolean isTrusted) {
        super(customField.getId(), customField.getName(), customField.getDescriptionProperty().getViewHtml(), customField.getCustomFieldType().getName(), Optional.ofNullable(customField.getCustomFieldSearcher()).map(searcher -> searcher.getDescriptor().getKey()).orElse(null), customField.getAssociatedProjectObjects().stream().map(Project::getId).collect(Collectors.toList()), customField.getAssociatedIssueTypes().stream().filter(Objects::nonNull).map(IssueConstant::getId).collect(Collectors.toList()), self);
        this.numericId = customField.getIdAsLong();
        this.isAllProjects = customField.isAllProjects();
        this.projectsCount = customField.getAssociatedProjectObjects().size();
        this.screensCount = screensCount;
        this.isManaged = isManaged;
        this.isLocked = isLocked;
        this.isTrusted = isTrusted;
        this.lastValueUpdate = customField.getLastValueUpdate();
        this.issuesWithValue = customField.getIssuesWithValue();
    }

    public Timestamp lastValueUpdate() {
        return this.lastValueUpdate;
    }

    public Long issuesWithValue() {
        return this.issuesWithValue;
    }
}

