/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.component;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.ComponentResource;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.ofbiz.core.entity.GenericValue;

@XmlRootElement(name="component")
public class ComponentBean {
    @XmlElement
    @Schema(example="http://www.example.com/jira/rest/api/2/component/10000")
    private URI self;
    @XmlElement
    @Schema(example="10000")
    private String id;
    @XmlElement
    @Schema(example="Component 1")
    private String name;
    @XmlElement
    @Schema(example="This is a Jira component")
    private String description;
    @XmlElement
    private UserBean lead;
    @XmlElement
    @Schema(example="fred")
    private String leadUserName;
    @XmlElement
    @Schema(example="PROJECT_LEAD")
    private AssigneeType assigneeType;
    @XmlElement
    private UserBean assignee;
    @XmlElement
    @Schema(example="COMPONENT_LEAD")
    private AssigneeType realAssigneeType;
    @XmlElement
    private UserBean realAssignee;
    @XmlElement
    @Schema(example="true")
    private boolean isAssigneeTypeValid;
    @XmlElement
    @Schema(example="HSP")
    private String project;
    @XmlElement
    @Schema(example="10000")
    private Long projectId;
    @XmlElement
    @Schema(example="false")
    private Boolean archived;
    @XmlElement
    @Schema(example="false")
    private Boolean deleted;

    public static Collection<ComponentBean> asBeans(Collection<? extends ProjectComponent> components, JiraBaseUrls jiraBaseUrls) {
        ArrayList<ComponentBean> list = new ArrayList<ComponentBean>(components.size());
        for (ProjectComponent projectComponent : components) {
            list.add(ComponentBean.shortComponent(projectComponent, jiraBaseUrls));
        }
        return list;
    }

    public static Collection<ComponentBean> asFullBeans(Project project, Collection<? extends ProjectComponent> components, JiraBaseUrls jiraBaseUrls, UserManager userManager, AvatarService avatarService, PermissionManager permissionManager, ProjectManager projectManager) {
        ArrayList<ComponentBean> list = new ArrayList<ComponentBean>(components.size());
        for (ProjectComponent projectComponent : components) {
            list.add(ComponentBean.fullComponent(projectComponent, project, jiraBaseUrls, userManager, avatarService, permissionManager, projectManager));
        }
        return list;
    }

    public static ComponentBean shortComponent(ProjectComponent component, JiraBaseUrls jiraBaseUrls) {
        ComponentBean bean = new ComponentBean();
        bean.self = UriBuilder.fromPath((String)jiraBaseUrls.restApi2BaseUrl()).path(ComponentResource.class).path(component.getId().toString()).build(new Object[0]);
        bean.id = component.getId().toString();
        bean.description = component.getDescription();
        bean.name = component.getName();
        return bean;
    }

    public static ComponentBean fullComponent(ProjectComponent component, Project project, JiraBaseUrls jiraBaseUrls, UserManager userManager, AvatarService avatarService, PermissionManager permissionManager, ProjectManager projectManager) {
        String projectLeadUserKey;
        ComponentBean bean = ComponentBean.shortComponent(component, jiraBaseUrls);
        bean.description = component.getDescription();
        bean.project = project.getKey();
        bean.projectId = project.getId();
        bean.archived = component.isArchived();
        bean.deleted = component.isDeleted();
        long assigneeType = project.getAssigneeType() == null ? 2L : project.getAssigneeType();
        String lead = component.getLead();
        ApplicationUser user = userManager.getUserByKeyEvenWhenUnknown(lead);
        ApplicationUser projectLeadUser = userManager.getUserByName(project.getLeadUserName());
        String string = projectLeadUserKey = projectLeadUser == null ? null : projectLeadUser.getKey();
        if (user != null) {
            bean.lead = UserBeanBuilder.shortBuilder(jiraBaseUrls).user(user).buildShort();
        }
        ComponentBean.populateAssignee(bean, component, projectLeadUserKey, assigneeType, jiraBaseUrls, userManager, permissionManager, projectManager);
        return bean;
    }

    private static void populateAssignee(ComponentBean bean, ProjectComponent component, String projectLeadUserKey, long projectAssigneeType, JiraBaseUrls jiraBaseUrls, UserManager userManager, PermissionManager permissionManager, ProjectManager projectManager) {
        ApplicationUser user;
        String configuredAssigneeName = null;
        switch ((int)component.getAssigneeType()) {
            case 1: {
                configuredAssigneeName = component.getLead();
                break;
            }
            case 2: {
                configuredAssigneeName = projectLeadUserKey;
                break;
            }
            case 0: {
                configuredAssigneeName = projectAssigneeType == 2L ? projectLeadUserKey : null;
            }
        }
        long realAssigneeType = ComponentUtils.getAssigneeType((GenericValue)component.getGenericValue(), (Long)component.getAssigneeType());
        String realAssigneeName = null;
        switch ((int)realAssigneeType) {
            case 1: {
                realAssigneeName = component.getLead();
                break;
            }
            case 2: {
                realAssigneeName = projectLeadUserKey;
                break;
            }
            case 0: {
                realAssigneeName = projectAssigneeType == 2L ? projectLeadUserKey : null;
            }
        }
        bean.assigneeType = AssigneeType.getAssigneeType(component.getAssigneeType());
        if (configuredAssigneeName != null) {
            user = userManager.getUserByKeyEvenWhenUnknown(configuredAssigneeName);
            bean.assignee = user != null ? UserBeanBuilder.shortBuilder(jiraBaseUrls).user(user).buildShort() : null;
        }
        bean.realAssigneeType = AssigneeType.getAssigneeType(realAssigneeType);
        if (realAssigneeName != null) {
            boolean assignable;
            user = userManager.getUserByKeyEvenWhenUnknown(realAssigneeName);
            bean.realAssignee = user != null ? UserBeanBuilder.shortBuilder(jiraBaseUrls).user(user).buildShort() : null;
            Project project = projectManager.getProjectObj(component.getProjectId());
            bean.isAssigneeTypeValid = assignable = permissionManager.hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, user);
        }
        if (bean.realAssigneeType == AssigneeType.UNASSIGNED) {
            bean.isAssigneeTypeValid = ComponentAssigneeTypes.isAssigneeTypeValid((GenericValue)component.getGenericValue(), (Long)AssigneeType.UNASSIGNED.getId());
        }
        if (bean.assigneeType != bean.realAssigneeType) {
            bean.isAssigneeTypeValid = false;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UserBean getLead() {
        return this.lead;
    }

    public URI getSelf() {
        return this.self;
    }

    public String getLeadUserName() {
        return this.leadUserName;
    }

    public AssigneeType getAssigneeType() {
        return this.assigneeType;
    }

    public String getProject() {
        return this.project;
    }

    public Boolean isArchived() {
        return this.archived;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public static enum AssigneeType {
        PROJECT_DEFAULT(0L),
        COMPONENT_LEAD(1L),
        PROJECT_LEAD(2L),
        UNASSIGNED(3L);

        private final long id;

        private AssigneeType(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        static AssigneeType getAssigneeType(long assigneeType) {
            switch ((short)assigneeType) {
                case 0: {
                    return PROJECT_DEFAULT;
                }
                case 1: {
                    return COMPONENT_LEAD;
                }
                case 2: {
                    return PROJECT_LEAD;
                }
                case 3: {
                    return UNASSIGNED;
                }
            }
            return null;
        }
    }
}

