/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.operation;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.rest.factory.Responder;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentConfiguration;
import com.atlassian.jira.rest.v2.issue.attachment.format.ArchiveFormatter;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentOperation;
import io.atlassian.fugue.Option;
import javax.ws.rs.core.Response;

final class AttachmentExpansion
implements AttachmentOperation {
    private final AttachmentIndexManager attachmentIndexManager;
    private final Responder responder;
    private final AttachmentConfiguration configuration;
    private final ArchiveFormatter entityFormatter;

    AttachmentExpansion(AttachmentIndexManager attachmentIndexManager, Responder responder, AttachmentConfiguration configuration, ArchiveFormatter entityFormatter) {
        this.attachmentIndexManager = attachmentIndexManager;
        this.responder = responder;
        this.configuration = configuration;
        this.entityFormatter = entityFormatter;
    }

    @Override
    public Response perform(Attachment attachment, JiraServiceContext context) {
        Option<AttachmentArchive> contents = this.tryToExpand(attachment);
        if (contents.isDefined()) {
            AttachmentArchive archive = (AttachmentArchive)contents.get();
            Object entity = this.entityFormatter.format(archive, attachment);
            return this.responder.builder(Response.Status.OK).entity(entity).build();
        }
        return this.responder.builder(Response.Status.CONFLICT).build();
    }

    private Option<AttachmentArchive> tryToExpand(Attachment attachment) {
        Issue issue = attachment.getIssue();
        int maxEntries = this.configuration.getMaxEntriesToExpand();
        return this.attachmentIndexManager.getAttachmentContents(attachment, issue, maxEntries);
    }
}

