/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.format;

import com.atlassian.jira.rest.v2.issue.attachment.format.HumanReadableArchiveEntry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.concurrent.Immutable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@Immutable
public class HumanReadableArchive {
    @Schema(example="7237823")
    private final long id;
    @Schema(example="images.zip")
    private final String name;
    private final Iterable<HumanReadableArchiveEntry> entries;
    @Schema(example="39")
    private final long totalEntryCount;
    @Schema(example="application/zip")
    private final String mediaType;

    public HumanReadableArchive(long id, String name, Iterable<HumanReadableArchiveEntry> entries, long totalEntryCount, String mediaType) {
        this.id = id;
        this.name = name;
        this.entries = ImmutableList.copyOf(entries);
        this.totalEntryCount = totalEntryCount;
        this.mediaType = mediaType;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Iterable<HumanReadableArchiveEntry> getEntries() {
        return this.entries;
    }

    public long getTotalEntryCount() {
        return this.totalEntryCount;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.entries, this.totalEntryCount, this.mediaType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HumanReadableArchive other = (HumanReadableArchive)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.entries, other.entries) && Objects.equal((Object)this.totalEntryCount, (Object)other.totalEntryCount) && Objects.equal((Object)this.mediaType, (Object)other.mediaType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("entries", this.entries).add("totalEntryCount", this.totalEntryCount).add("mediaType", (Object)this.mediaType).toString();
    }
}

