/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.format;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.rest.v2.issue.PropertySetAdapter;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentResource;
import com.atlassian.jira.rest.v2.issue.attachment.format.AttachmentBean;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;

public class AttachmentBeanBuilder {
    private final Attachment attachment;
    private final JiraBaseUrls jiraBaseUrls;
    private final ThumbnailManager thumbnailManager;

    public AttachmentBeanBuilder(JiraBaseUrls jiraBaseUrls, ThumbnailManager thumbnailManager, Attachment attachment) {
        this.jiraBaseUrls = (JiraBaseUrls)Assertions.notNull((String)"jiraBaseUrls", (Object)jiraBaseUrls);
        this.thumbnailManager = (ThumbnailManager)Assertions.notNull((String)"thumbnailManager", (Object)thumbnailManager);
        this.attachment = (Attachment)Assertions.notNull((String)"attachment", (Object)attachment);
    }

    public AttachmentBean build() throws IllegalStateException {
        if (this.attachment == null) {
            throw new IllegalStateException("attachment not set");
        }
        try {
            URI self = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(AttachmentResource.class).path(this.attachment.getId().toString()).build(new Object[0]);
            String filename = this.attachment.getFilename();
            UserBean author = UserBeanBuilder.shortBuilder(this.jiraBaseUrls).user(this.attachment.getAuthorObject()).buildShort();
            Timestamp created = this.attachment.getCreated();
            Long size = this.attachment.getFilesize();
            String mimeType = this.attachment.getMimetype();
            HashMap<String, Object> properties = new PropertySetAdapter().marshal(this.attachment.getProperties());
            String encodedFilename = URLEncoder.encode(this.attachment.getFilename(), "UTF-8");
            String content = String.format("%s/secure/attachment/%s/%s", this.jiraBaseUrls.baseUrl(), this.attachment.getId(), encodedFilename);
            ThumbnailedImage thumbnail = this.thumbnailManager.toThumbnailedImage(this.thumbnailManager.getThumbnail(this.attachment));
            String thumbnailURL = thumbnail != null ? thumbnail.getImageURL() : null;
            return new AttachmentBean(self, filename, author, created, size, mimeType, properties, content, thumbnailURL);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding file name", e);
        }
    }
}

