/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveImpl;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentResourceStrategy;
import com.atlassian.jira.rest.v2.issue.attachment.AttachmentStrategyFactory;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentAuthorizer;
import com.atlassian.jira.rest.v2.issue.attachment.format.ArchiveFormatter;
import com.atlassian.jira.rest.v2.issue.attachment.format.AttachmentBean;
import com.atlassian.jira.rest.v2.issue.attachment.format.AttachmentMetaBean;
import com.atlassian.jira.rest.v2.issue.attachment.format.HumanReadableArchive;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentOperation;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import webwork.config.Configuration;

@Path(value="attachment")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AttachmentResource {
    private AttachmentStrategyFactory factory;
    private AttachmentConfigManager attachmentConfigManager;

    private AttachmentResource() {
    }

    @Inject
    public AttachmentResource(AttachmentStrategyFactory factory, AttachmentConfigManager attachmentConfigManager) {
        this.factory = factory;
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get the meta-data for an attachment, including the URI of the actual attached file", description="Returns the meta-data for an attachment, including the URI of the actual attached file.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="id of the attachment to view", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="JSON representation of the attachment meta-data. The representation does not contain the attachment itself, but contains a URI that can be used to download the actual attached file.", responseCode="200", content={@Content(schema=@Schema(implementation=AttachmentBean.class), mediaType="application/json")}), @ApiResponse(description="The calling user is not permitted to view the requested attachment.", responseCode="403"), @ApiResponse(description="Any of: there is no attachment with the requested id, attachments feature is disabled", responseCode="404")})
    public Response getAttachment(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().view();
        AttachmentOperation operation = this.factory.operation().view();
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }

    @DELETE
    @Path(value="{id}")
    @Operation(summary="Delete an attachment from an issue", description="Remove an attachment from an issue.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="id of the attachment to remove", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="Removal was successful", responseCode="204"), @ApiResponse(description="The calling user is not permitted to remove the requested attachment.", responseCode="403")})
    public Response removeAttachment(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().removal();
        AttachmentOperation operation = this.factory.operation().removal();
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }

    @GET
    @Path(value="meta")
    @Operation(summary="Get attachment capabilities", description="Returns the meta information for an attachments, specifically if they are enabled and the maximum upload size allowed.", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="JSON representation of the attachment capabilities. Consumers of this resource may also need to check if the logged in user has permission to upload or otherwise manipulate attachments using the com.atlassian.jira.rest.v2.permission.PermissionsResource", responseCode="200", content={@Content(schema=@Schema(implementation=AttachmentMetaBean.class), mediaType="application/json")})
    public Response getAttachmentMeta() {
        boolean enabled = this.attachmentConfigManager.isAttachmentsEnabled();
        long maxSize = Long.parseLong(Configuration.getString((String)"webwork.multipart.maxSize"));
        AttachmentMetaBean bean = new AttachmentMetaBean(enabled, maxSize);
        return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}/expand/raw")
    @ExperimentalApi
    @Operation(summary="Get raw attachment expansion", description="Tries to expand an attachment. Output is raw and should be backwards-compatible through the course of time.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="the id of the attachment to expand.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="JSON representation of the attachment expanded contents. Empty entry list means that attachment cannot be expanded. It's either empty, corrupt or not an archive at all.", responseCode="200", content={@Content(schema=@Schema(implementation=AttachmentArchiveImpl.class), mediaType="application/json")}), @ApiResponse(description="The calling user is not permitted to view the requested attachment.", responseCode="403"), @ApiResponse(description="Any of: there is no attachment with the requested id, attachments feature is disabled", responseCode="404"), @ApiResponse(description="The archive format is not supported. since v6.4", responseCode="409")})
    public Response expandForMachines(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().view();
        ArchiveFormatter<AttachmentArchive> formatter = this.factory.formatter().raw();
        AttachmentOperation operation = this.factory.operation().expansion(formatter);
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }

    @GET
    @Path(value="{id}/expand/human")
    @ExperimentalApi
    @Operation(summary="Get human-readable attachment expansion", description="Tries to expand an attachment. Output is human-readable and subject to change.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="the id of the attachment to expand.", in=ParameterIn.PATH, required=true)
    @ApiResponses(value={@ApiResponse(description="JSON representation of the attachment expanded contents. Empty entry list means that attachment cannot be expanded. It's either empty, corrupt or not an archive at all.", responseCode="200", content={@Content(schema=@Schema(implementation=HumanReadableArchive.class), mediaType="application/json")}), @ApiResponse(description="The calling user is not permitted to view the requested attachment.", responseCode="403"), @ApiResponse(description="Any of: there is no attachment with the requested id, attachments feature is disabled", responseCode="404"), @ApiResponse(description="The archive format is not supported. since v6.4", responseCode="409")})
    public Response expandForHumans(@PathParam(value="id") String id) {
        AttachmentAuthorizer authorizer = this.factory.authorizer().view();
        ArchiveFormatter<HumanReadableArchive> formatter = this.factory.formatter().human();
        AttachmentOperation operation = this.factory.operation().expansion(formatter);
        AttachmentResourceStrategy strategy = this.factory.resourceStrategy(authorizer, operation);
        return strategy.processAttachment(id);
    }
}

