/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserWriteBean {
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/user?username=charlie")
    private String self;
    @JsonProperty
    @Schema(example="charlie")
    private String key;
    @JsonProperty
    @Schema(example="charlie")
    private String name;
    @JsonProperty
    @Schema(example="abracadabra")
    private String password;
    @JsonProperty
    @Schema(example="charlie@atlassian.com")
    private String emailAddress;
    @JsonProperty
    @Schema(example="Charlie of Atlassian")
    private String displayName;
    @JsonProperty
    @Schema(example="HTML")
    private String notification;
    @JsonProperty
    @Schema(example="true")
    private Boolean active;
    @JsonProperty
    @Schema(example="[\"jira-core\"]")
    private List<String> applicationKeys;

    private UserWriteBean() {
    }

    public UserWriteBean(String self, String key, String name, String password, String emailAddress, String displayName, String notification, Boolean active, List<String> applicationKeys) {
        this.self = self;
        this.key = key;
        this.name = name;
        this.password = password;
        this.emailAddress = emailAddress;
        this.displayName = displayName;
        this.notification = notification;
        this.active = active;
        this.applicationKeys = applicationKeys;
    }

    public String getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getNotification() {
        return this.notification;
    }

    public Boolean isActive() {
        return this.active;
    }

    public List<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    public static final class Builder {
        private String self;
        private String key;
        private String name;
        private String password;
        private String emailAddress;
        private String displayName;
        private String notification;
        private Boolean active;
        private List<String> applicationKeys;

        public UserWriteBean toUserBean() {
            return new UserWriteBean(this.self, this.key, this.name, this.password, this.emailAddress, this.displayName, this.notification, this.active, this.applicationKeys);
        }

        public Builder self(String self) {
            this.self = self;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder notification(String notification) {
            this.notification = notification;
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder applicationKeys(List<String> applicationKeys) {
            this.applicationKeys = applicationKeys;
            return this;
        }
    }
}

