/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.bc.user.search.UserSearchIssueContext;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.user.UserAvatarUpdatedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.permission.UserSearchConfiguration;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.issue.ColumnsBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.exception.ServerErrorWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.UpdateUserApplicationHelper;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBeanConverter;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.PasswordBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UserPickerResultsBean;
import com.atlassian.jira.rest.v2.issue.UserWriteBean;
import com.atlassian.jira.rest.v2.issue.users.DuplicatedUsersCountBean;
import com.atlassian.jira.rest.v2.issue.users.DuplicatedUsersHelper;
import com.atlassian.jira.rest.v2.issue.users.DuplicatedUsersMapBeanFactory;
import com.atlassian.jira.rest.v2.issue.users.UserPickerResourceHelper;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class UserResource {
    public static final int DEPRECATION_WARNING_LOG_INTERVAL_MINUTES = 5;
    public static final int DEFAULT_USERS_RETURNED = 50;
    public static final int MAX_USERS_RETURNED = 1000;
    public static final int MAX_USERS_RETURNED_FOR_OPTIMISED_LOOKUP = UserSearchConfiguration.getMaxTopReturnedUsersValue();
    static final String USER_SEARCH_RESULTS_LIMIT = "jira.user.search.maxresults.limit";
    private static final Logger log = LoggerFactory.getLogger(UserResource.class);
    private static final int MAX_LENGTH = 255;
    private volatile long lastLogTime = 0L;
    private final UserService userService;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final PasswordPolicyManager passwordPolicyManager;
    private final I18nHelper i18n;
    private final EmailFormatter emailFormatter;
    private final JiraAuthenticationContext authContext;
    private final TimeZoneManager timeZoneManager;
    private final AvatarService avatarService;
    private final AvatarResourceHelper avatarResourceHelper;
    private final UserPropertyManager userPropertyManager;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectService projectService;
    private final IssueService issueService;
    private final ProjectManager projectManager;
    private final AvatarManager avatarManager;
    private final EventPublisher eventPublisher;
    private final UserPickerResourceHelper userPickerHelper;
    private final JiraBaseUrls jiraBaseUrls;
    private final ColumnService columnService;
    private final XsrfInvocationChecker xsrfChecker;
    private final I18nHelper.BeanFactory beanFactory;
    private final ApplicationRoleManager applicationRoleManager;
    private final ApplicationRoleBeanConverter applicationRoleBeanConverter;
    private final UpdateUserApplicationHelper updateUserApplicationHelper;
    private final ResponseFactory responseFactory;
    private final ApplicationProperties applicationProperties;
    private final DuplicatedUsersHelper duplicatedUsersHelper;
    private final LoginService loginService;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    @Inject
    public UserResource(UserService userService, UserUtil userUtil, PasswordPolicyManager passwordPolicyManager, I18nHelper i18n, EmailFormatter emailFormatter, JiraAuthenticationContext authContext, TimeZoneManager timeZoneManager, AvatarPickerHelper avatarPickerHelper, AvatarManager avatarManager, AvatarService avatarService, AttachmentHelper attachmentHelper, UserPropertyManager userPropertyManager, PermissionManager permissionManager, GlobalPermissionManager globalPermissionManager, ProjectService projectService, IssueService issueService, ProjectManager projectManager, EventPublisher eventPublisher, UserPickerResourceHelper userPickerHelper, JiraBaseUrls jiraBaseUrls, ColumnService columnService, XsrfInvocationChecker xsrfChecker, UserManager userManager, I18nHelper.BeanFactory beanFactory, ApplicationRoleManager applicationRoleManager, ApplicationRoleBeanConverter applicationRoleBeanConverter, UpdateUserApplicationHelper updateUserApplicationHelper, ResponseFactory responseFactory, ApplicationProperties applicationProperties, DuplicatedUsersHelper duplicatedUsersHelper, LoginService loginService, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.userService = userService;
        this.userManager = userManager;
        this.passwordPolicyManager = passwordPolicyManager;
        this.userPropertyManager = userPropertyManager;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.projectService = projectService;
        this.issueService = issueService;
        this.projectManager = projectManager;
        this.avatarManager = avatarManager;
        this.eventPublisher = eventPublisher;
        this.userPickerHelper = userPickerHelper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.columnService = columnService;
        this.beanFactory = beanFactory;
        this.updateUserApplicationHelper = updateUserApplicationHelper;
        this.responseFactory = responseFactory;
        this.duplicatedUsersHelper = duplicatedUsersHelper;
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarService, avatarPickerHelper, attachmentHelper, userManager);
        this.userUtil = userUtil;
        this.i18n = i18n;
        this.emailFormatter = emailFormatter;
        this.authContext = authContext;
        this.timeZoneManager = timeZoneManager;
        this.avatarService = avatarService;
        this.xsrfChecker = xsrfChecker;
        this.applicationRoleManager = applicationRoleManager;
        this.applicationRoleBeanConverter = applicationRoleBeanConverter;
        this.applicationProperties = applicationProperties;
        this.loginService = loginService;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @GET
    @Operation(summary="Get user by username or key", description="Returns a user.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="name", description="the username", required=true), @Parameter(name="key", description="user key"), @Parameter(name="includeDeleted", description="whether deleted users should be returned (flag available to users with global ADMIN rights)")})
    @ApiResponses(value={@ApiResponse(description="Returns a user.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller does not have permission to perform operation.", responseCode="403"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Response getUser(@QueryParam(value="username") String name, @QueryParam(value="key") String key, @QueryParam(value="includeDeleted") @DefaultValue(value="false") boolean includeDeleted) {
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        if (loggedInUser == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        if (includeDeleted) {
            this.mustBeAdmin(loggedInUser);
        }
        return Response.ok((Object)this.buildUserBean(name, key, includeDeleted, loggedInUser)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="search")
    @Operation(summary="Find users by username", description="Finds users.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="A query string used to search username, name or e-mail address", required=true), @Parameter(name="startAt", description="The index of the first user to return (0-based)"), @Parameter(name="maxResults", description="The maximum number of users to return (defaults to 50). The maximum allowed value is 1000. If you specify a value that is higher than this number, your search results will be truncated."), @Parameter(name="includeActive", description="If true, then active users are included in the results (default true)"), @Parameter(name="includeInactive", description="If true, then inactive users are included in the results (default false)"), @Parameter(name="uriInfo", description="Context used for creating urls in user objects")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if an invalid parameter value was provided with more details in the response body.", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Response findUsers(@QueryParam(value="username") String username, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="includeActive") Boolean includeActive, @QueryParam(value="includeInactive") Boolean includeInactive, @Context UriInfo uriInfo) {
        maxResults = this.verifyAndAdjustMaxResults(maxResults);
        startAt = this.verifyAndAdjustStartAt(startAt);
        int searchLimit = this.getSearchLimit(startAt, maxResults);
        List<ApplicationUser> allResults = this.userPickerHelper.findUsers(username, includeActive, includeInactive, false, null, searchLimit);
        List<ApplicationUser> limitedResult = this.userPickerHelper.limitUserSearch(startAt, maxResults, allResults, null);
        return Response.ok(this.makeUserBeans(limitedResult)).cacheControl(CacheControl.never()).build();
    }

    private int getSearchLimit(int startAt, int maxResults) {
        int maxAllowedLimit;
        String searchLimitProperty = this.applicationProperties.getDefaultBackedString(USER_SEARCH_RESULTS_LIMIT);
        try {
            maxAllowedLimit = Integer.parseInt(searchLimitProperty);
        }
        catch (NumberFormatException e) {
            log.error("The user search limit value '{}' can't be parsed to an integer, using {} as the limit. Adjust the '{}' property to remove this message.", new Object[]{searchLimitProperty, 1000, USER_SEARCH_RESULTS_LIMIT});
            maxAllowedLimit = 1000;
        }
        int requestedLimit = startAt + maxResults;
        if (requestedLimit < 0 || requestedLimit > maxAllowedLimit) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.user.search.requested.limit.too.big", String.valueOf(requestedLimit), String.valueOf(maxAllowedLimit)));
        }
        return requestedLimit;
    }

    @GET
    @Path(value="picker")
    @AnonymousSiteAccess
    @Operation(summary="Find users for picker by query", description="Returns a list of users matching query with highlighting.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="query", description="A string used to search username, Name or e-mail address", required=true), @Parameter(name="maxResults", description="The maximum number of users to return (defaults to 50). The maximum allowed value is 1000. If you specify a value that is higher than this number, your search results will be truncated."), @Parameter(name="showAvatar", description="If true, then avatars are included in the results"), @Parameter(name="exclude", description="List of users to be excluded from the search results")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users matching query with highlighting.", responseCode="200", content={@Content(schema=@Schema(implementation=UserPickerResultsBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Response findUsersForPicker(@QueryParam(value="query") String query, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="showAvatar") Boolean showAvatar, @QueryParam(value="exclude") List<String> excludeUsers) {
        return Response.ok((Object)this.userPickerHelper.findUsersAsBean(query, maxResults, showAvatar, excludeUsers)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="assignable/search")
    @Operation(summary="Find assignable users by username", description="Returns a list of users that match the search string. This resource cannot be accessed anonymously. Please note that this resource should be called with an issue key when a list of assignable users is retrieved. For create only a project key should be supplied. The list of assignable users may be incorrect if it's called with the project key for editing.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username", required=true), @Parameter(name="issueKey", description="the issue key for the issue being edited we need to find assignable users for."), @Parameter(name="projectKey", description="the key of the project we are finding assignable users for"), @Parameter(name="maxResults", description="the maximum number of users to return (defaults to 50). The maximum allowed value is 100. If you specify a value that is higher than this number, your search results will be truncated.")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users that match the search string.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Response findAssignableUsers(@QueryParam(value="username") String name, @QueryParam(value="project") String projectKey, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="maxResults") @DefaultValue(value="50") Integer maxResults, @QueryParam(value="actionDescriptorId") Integer actionDescriptorId, @Context UriInfo uriInfo) {
        boolean defaultStartAt = false;
        maxResults = this.verifyAndAdjustMaxResults(maxResults, MAX_USERS_RETURNED_FOR_OPTIMISED_LOOKUP);
        List<ApplicationUser> usersWithPermission = this.findAssignableUsers(name, projectKey, issueKey, maxResults);
        List<ApplicationUser> usersAfterLimit = this.userPickerHelper.limitUserSearch(0, maxResults, usersWithPermission, null);
        return Response.ok(this.makeUserBeans(usersAfterLimit)).cacheControl(CacheControl.never()).build();
    }

    @Path(value="duplicated/count")
    @ExperimentalApi
    @GET
    @Operation(summary="Get duplicated users count", description="Returns a list of users that match the search string. This resource cannot be accessed anonymously.\nDuplicated means that the user has an account in more than one directory\nand either more than one account is active or the only active account does not belong to the directory\nwith the highest priority.\nThe data returned by this endpoint is cached for 10 minutes and the cache is flushed when any User Directory\nis added, removed, enabled, disabled, or synchronized.\nA System Administrator can also flush the cache manually.\nRelated JAC ticket: https://jira.atlassian.com/browse/JRASERVER-68797", security={@SecurityRequirement(name="basic")})
    @Parameter(name="flush", description="if set to true forces cache flush, user must be sysadmin for this parameter to have an effect.")
    @ApiResponses(value={@ApiResponse(description="Returns a list of users that match the search string.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Response getDuplicatedUsersCount(@QueryParam(value="flush") boolean flush) {
        ApplicationUser currentUser = this.authContext.getLoggedInUser();
        this.mustBeAdmin(currentUser);
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, currentUser) && flush) {
            this.duplicatedUsersHelper.flushCache();
        }
        DuplicatedUsersCountBean response = new DuplicatedUsersCountBean(this.duplicatedUsersHelper.getDuplicatedUserToDirectoryMapping().userCount());
        return Response.ok((Object)response).build();
    }

    @Path(value="duplicated/list")
    @ExperimentalApi
    @GET
    @Operation(summary="Get duplicated users mapping", description="Returns duplicated users mapped to their directories with an indication if their accounts are active or not.\nDuplicated means that the user has an account in more than one directory and either more than one account is active\nor the only active account does not belong to the directory with the highest priority.\nThe data returned by this endpoint is cached for 10 minutes and the cache is flushed when any User Directory\nis added, removed, enabled, disabled, or synchronized.\nA System Administrator can also flush the cache manually.\nRelated JAC ticket: https://jira.atlassian.com/browse/JRASERVER-68797", security={@SecurityRequirement(name="basic")})
    @Parameter(name="flush", description="if set to true forces cache flush, user must be sysadmin for this parameter to have an effect.")
    @ApiResponses(value={@ApiResponse(description="Returns all avatars which are visible for the currently logged in user.", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if user is not an admin.", responseCode="403"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Response getDuplicatedUsersMapping(@QueryParam(value="flush") boolean flush) {
        ApplicationUser currentUser = this.authContext.getLoggedInUser();
        this.mustBeAdmin(currentUser);
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, currentUser) && flush) {
            this.duplicatedUsersHelper.flushCache();
        }
        Map<String, List<DuplicatedUsersMapBeanFactory.DirectoryWithUserActiveBean>> response = DuplicatedUsersMapBeanFactory.getBean(this.duplicatedUsersHelper.getDuplicatedUserToDirectoryMapping());
        return Response.ok(response).build();
    }

    @POST
    @WebSudoRequired
    @ExperimentalApi
    @Operation(summary="Create new user", description="Create user. By default created user will not be notified with email. If password field is not set then password will be randomly generated.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="User details", required=true, content={@Content(schema=@Schema(implementation=UserWriteBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the user was created.", responseCode="201", content={@Content(schema=@Schema(implementation=UserWriteBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to create the user.", responseCode="403"), @ApiResponse(description="Returned if the user was not created because of other error.", responseCode="500")})
    public Response createUser(UserWriteBean userBean) {
        UserService.CreateUserValidationResult validationResult;
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        boolean sendNotification = userBean.getNotification() != null && Boolean.parseBoolean(userBean.getNotification());
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)loggedUser, (String)userBean.getName(), (String)userBean.getPassword(), (String)userBean.getEmailAddress(), (String)userBean.getDisplayName()).confirmPassword(userBean.getPassword()).sendNotification(sendNotification);
        if (userBean.getApplicationKeys() != null) {
            ImmutableList applicationKeys = ImmutableList.copyOf((Iterable)Iterables.transform(userBean.getApplicationKeys(), (Function)ApplicationKeys.TO_APPLICATION_KEY));
            ImmutableList nonValidKeysMessages = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Eithers.filterLeft((Iterable)applicationKeys), input -> this.i18n.getText("application.role.rest.bad.key", input)));
            if (!nonValidKeysMessages.isEmpty()) {
                throw new BadRequestWebException(ErrorCollection.of((Collection<String>)nonValidKeysMessages));
            }
            createUserRequest = createUserRequest.withApplicationAccess((Set)ImmutableSet.copyOf((Iterable)Eithers.filterRight((Iterable)applicationKeys)));
        }
        if (!(validationResult = this.userService.validateCreateUser(createUserRequest)).isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        try {
            this.userService.createUser(validationResult);
            UserBean responseUserBean = this.buildUserBean(userBean.getName(), null, false, loggedUser);
            return Response.status((Response.Status)Response.Status.CREATED).location(responseUserBean.getSelf()).entity((Object)responseUserBean).cacheControl(CacheControl.never()).build();
        }
        catch (PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
        catch (CreateException e) {
            throw new ServerErrorWebException(ErrorCollection.of(e.getLocalizedMessage()));
        }
    }

    @PUT
    @WebSudoRequired
    @ExperimentalApi
    @Operation(summary="Update user details", description="Modify user. The 'value' fields present will override the existing value. Fields skipped in request will not be changed.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username", required=true), @Parameter(name="key", description="user key")})
    @RequestBody(description="User details", required=true, content={@Content(schema=@Schema(implementation=UserWriteBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the user exists and the caller has permission to edit it.", responseCode="200", content={@Content(schema=@Schema(implementation=UserWriteBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to edit the user.", responseCode="403"), @ApiResponse(description="Returned if the caller does have permission to edit the user but the user does not exist.", responseCode="404")})
    public Response updateUser(@QueryParam(value="username") String name, @QueryParam(value="key") String key, UserWriteBean userBean) {
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        if (StringUtils.isBlank((CharSequence)userBean.getName()) && StringUtils.isBlank((CharSequence)userBean.getEmailAddress()) && StringUtils.isBlank((CharSequence)userBean.getDisplayName()) && Objects.isNull(userBean.isActive())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.no.value.found.to.be.changed")));
        }
        if (StringUtils.length((CharSequence)userBean.getDisplayName()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.field.too.long", "displayName", Integer.toString(255))));
        }
        if (StringUtils.length((CharSequence)userBean.getEmailAddress()) > 255) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("rest.myself.error.field.too.long", "emailAddress", Integer.toString(255))));
        }
        if (StringUtils.isNotBlank((CharSequence)userBean.getEmailAddress()) && !TextUtils.verifyEmail((String)userBean.getEmailAddress())) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("admin.errors.invalid.email")));
        }
        ApplicationUser changedUser = this.getUserByUsernameOrKey(name, key, false);
        ImmutableUser.Builder userBuilder = ImmutableUser.newUser((User)changedUser.getDirectoryUser());
        userBuilder.name((String)StringUtils.defaultIfBlank((CharSequence)userBean.getName(), (CharSequence)changedUser.getName()));
        userBuilder.emailAddress((String)StringUtils.defaultIfBlank((CharSequence)userBean.getEmailAddress(), (CharSequence)changedUser.getEmailAddress()));
        userBuilder.displayName((String)StringUtils.defaultIfBlank((CharSequence)userBean.getDisplayName(), (CharSequence)changedUser.getDisplayName()));
        userBuilder.active(Optional.ofNullable(userBean.isActive()).orElse(changedUser.isActive()).booleanValue());
        UserService.UpdateUserValidationResult validationResult = this.userService.validateUpdateUser((ApplicationUser)new DelegatingApplicationUser(changedUser.getId(), changedUser.getKey(), (User)userBuilder.toUser()));
        if (!validationResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.userService.updateUser(validationResult);
        return Response.ok((Object)this.buildUserBean(null, changedUser.getKey(), false, loggedUser)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="password")
    @Operation(summary="Update user password", description="Modify user password.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username", required=true), @Parameter(name="key", description="user key")})
    @RequestBody(description="Password details", required=true, content={@Content(schema=@Schema(implementation=PasswordBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned if the user exists and the caller has permission to edit it.", responseCode="204"), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller does not have permission to change the user password.", responseCode="403"), @ApiResponse(description="Returned if the caller does have permission to change user password but the user does not exist.", responseCode="404")})
    public Response changeUserPassword(@QueryParam(value="username") String name, @QueryParam(value="key") String key, PasswordBean passwordBean) {
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        ApplicationUser changedUser = this.getUserByUsernameOrKey(name, key, false);
        this.nonSysAdminCannotModifySysAdmin(loggedUser, changedUser);
        String password = passwordBean.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.required")));
        }
        Collection messages = this.passwordPolicyManager.checkPolicy(changedUser, null, password);
        if (!messages.isEmpty()) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        try {
            this.userUtil.changePassword(changedUser, password);
        }
        catch (UserNotFoundException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.could.not.find.user")));
        }
        catch (InvalidCredentialException e) {
            throw new BadRequestWebException(ErrorCollection.of(this.i18n.getText("changepassword.new.password.rejected")));
        }
        catch (OperationNotPermittedException | PermissionException e) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("admin.errors.cannot.edit.user.directory.read.only")));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @WebSudoRequired
    @ExperimentalApi
    @Operation(summary="Delete user", description="Removes user and its references (like project roles associations, watches, history). Note: user references will not be removed if multiple User Directories are used and there is a user with the same name existing in another directory (shadowing user).", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username", required=true), @Parameter(name="key", description="user key")})
    @ApiResponses(value={@ApiResponse(description="Returned if the user was deleted successfully.", responseCode="204"), @ApiResponse(description="Returned if the request is invalid or some other server error occurred.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller does not have permission to remove the user.", responseCode="403"), @ApiResponse(description="Returned if the caller does have permission to remove user but the user does not exist.", responseCode="404")})
    public Response removeUser(@QueryParam(value="username") String name, @QueryParam(value="key") String key) {
        ApplicationUser loggedUser = this.authContext.getUser();
        this.mustBeAdmin(loggedUser);
        ApplicationUser removedUser = this.getUserByUsernameOrKey(name, key, false);
        UserService.DeleteUserValidationResult validationResult = this.userService.validateDeleteUser(loggedUser, removedUser);
        if (!validationResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        try {
            this.userService.removeUser(loggedUser, validationResult);
        }
        catch (Exception e) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void mustBeAdmin(ApplicationUser user) {
        if (user == null) {
            throw new NotAuthorisedWebException(ErrorCollection.of(this.i18n.getText("rest.authentication.no.user.logged.in")));
        }
        boolean isGlobalAdmin = this.permissionManager.hasPermission(0, user);
        if (!isGlobalAdmin) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("rest.authorization.admin.required")));
        }
    }

    private void nonSysAdminCannotModifySysAdmin(ApplicationUser loggedUser, ApplicationUser changedUser) {
        boolean isSystemAdminLogged = this.permissionManager.hasPermission(44, loggedUser);
        boolean isSystemAdminEdited = this.permissionManager.hasPermission(44, changedUser);
        if (isSystemAdminEdited && !isSystemAdminLogged) {
            throw new ForbiddenWebException(ErrorCollection.of(this.i18n.getText("error.no-permission")));
        }
    }

    private List<ApplicationUser> findAssignableUsers(String name, String projectKey, String issueKey, int resultsNumber) {
        UserSearchIssueContext context;
        ApplicationUser loggedInUser = this.authContext.getLoggedInUser();
        if (!this.checkLoggedUserPermission(loggedInUser, context = this.getIssueContext(issueKey, projectKey), ProjectPermissions.ASSIGN_ISSUES)) {
            throw new NotAuthorisedWebException();
        }
        return this.userPickerHelper.findTopAssignableUsers(name, context, resultsNumber, true);
    }

    private boolean checkLoggedUserPermission(ApplicationUser user, UserSearchIssueContext issueContext, ProjectPermissionKey permissionKey) {
        Project project = issueContext.getProject();
        return this.permissionManager.hasPermission(permissionKey, project, user);
    }

    @GET
    @Path(value="viewissue/search")
    @Operation(summary="Find users with browse permission", description="Returns a list of active users that match the search string. This resource cannot be accessed anonymously and requires the Browse Users global permission. Given an issue key this resource will provide a list of users that match the search string and have the browse issue permission for the issue provided.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username filter, no users returned if left blank", required=true), @Parameter(name="issueKey", description="the issue key for the issue being edited we need to find viewable users for."), @Parameter(name="projectKey", description="the optional project key to search for users with if no issueKey is supplied."), @Parameter(name="maxResults", description="the maximum number of users to return (defaults to 50). The maximum allowed value is 100. If you specify a value that is higher than this number, your search results will be truncated.")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users that match the search string.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if no project or issue key was provided", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested issue or project is not found.", responseCode="404")})
    public Response findUsersWithBrowsePermission(@QueryParam(value="username") String username, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="projectKey") String projectKey, @QueryParam(value="maxResults") Integer maxResults, @Context UriInfo uriInfo) {
        maxResults = this.verifyAndAdjustMaxResults(maxResults, MAX_USERS_RETURNED_FOR_OPTIMISED_LOOKUP);
        boolean defaultStartAt = false;
        UserSearchIssueContext issueContext = this.getIssueContext(issueKey, projectKey);
        List<ApplicationUser> usersWithPermission = this.userPickerHelper.findUsersWithBrowsePermission(username, issueContext, maxResults, false);
        List<ApplicationUser> usersAfterLimit = this.userPickerHelper.limitUserSearch(0, maxResults, usersWithPermission, null);
        List<UserBean> responseBeans = this.makeUserBeans(usersAfterLimit);
        return Response.ok(responseBeans).cacheControl(CacheControl.never()).build();
    }

    @VisibleForTesting
    List<ApplicationUser> findUsersWithPermission(Iterable<Integer> permissions, String name, Either<Project, Issue> projectOrIssue, boolean allowEmptyQuery, Integer maxResults) {
        Predicate permissionPredicate = (Predicate)projectOrIssue.fold(project -> this.createProjectPredicate(permissions, (Project)project), issue -> this.createIssuePredicate(permissions, (Issue)issue));
        return this.userPickerHelper.findUsers(name, true, false, allowEmptyQuery, (Predicate<User>)permissionPredicate, maxResults);
    }

    @VisibleForTesting
    UserSearchIssueContext getIssueContext(String issueKey, String projectKey) {
        if (StringUtils.isNotBlank((CharSequence)issueKey)) {
            IssueService.IssueResult issueResult = this.issueService.getIssue(this.authContext.getUser(), issueKey);
            if (!issueResult.isValid()) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(issueResult.getErrorCollection()));
            }
            return UserSearchIssueContext.create((Issue)issueResult.getIssue());
        }
        if (StringUtils.isNotBlank((CharSequence)projectKey)) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.authContext.getI18nHelper().getText("rest.must.provide.valid.project")));
            }
            return UserSearchIssueContext.createForNewIssue(Collections.singleton(project));
        }
        throw this.createWebException(this.authContext.getI18nHelper().getText("rest.must.provide.project.or.issue"), ErrorCollection.Reason.VALIDATION_FAILED);
    }

    @VisibleForTesting
    Either<Project, Issue> getIssueOrProject(String issueKey, String projectKey) {
        if (StringUtils.isNotBlank((CharSequence)issueKey)) {
            IssueService.IssueResult issueResult = this.issueService.getIssue(this.authContext.getUser(), issueKey);
            if (!issueResult.isValid()) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(issueResult.getErrorCollection()));
            }
            return Either.right((Object)issueResult.getIssue());
        }
        if (StringUtils.isNotBlank((CharSequence)projectKey)) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.authContext.getI18nHelper().getText("rest.must.provide.valid.project")));
            }
            return Either.left((Object)project);
        }
        throw this.createWebException(this.authContext.getI18nHelper().getText("rest.must.provide.project.or.issue"), ErrorCollection.Reason.VALIDATION_FAILED);
    }

    @VisibleForTesting
    Predicate<User> createProjectPredicate(Iterable<Integer> permissions, Project project) {
        return user -> {
            for (Integer permission : permissions) {
                if (this.permissionManager.hasPermission(new ProjectPermissionKey(permission.intValue()), project, ApplicationUsers.from((User)user), true)) continue;
                return false;
            }
            return true;
        };
    }

    @VisibleForTesting
    Predicate<User> createIssuePredicate(Iterable<Integer> permissions, Issue issue) {
        return user -> {
            for (Integer permission : permissions) {
                if (this.permissionManager.hasPermission(permission.intValue(), issue, ApplicationUsers.from((User)user))) continue;
                return false;
            }
            return true;
        };
    }

    private Integer verifyAndAdjustMaxResults(Integer maxResults, Integer maxResultsLimit) {
        if (maxResults == null) {
            return 50;
        }
        if (maxResults > maxResultsLimit) {
            return maxResultsLimit;
        }
        if (maxResults < 0) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.negative.maxresults", (Object)maxResults));
        }
        return maxResults;
    }

    private Integer verifyAndAdjustMaxResults(Integer maxResults) {
        return this.verifyAndAdjustMaxResults(maxResults, 1000);
    }

    private Integer verifyAndAdjustStartAt(Integer startAt) {
        if (startAt == null) {
            return 0;
        }
        if (startAt < 0) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.negative.startat", (Object)startAt));
        }
        return startAt;
    }

    @GET
    @Path(value="permission/search")
    @Deprecated
    @Operation(summary="Find users with all specified permissions", description="Returns a list of active users that match the search string and have all specified permissions for the project or issue. This resource can be accessed by users with ADMINISTER_PROJECT permission for the project or global ADMIN or SYSADMIN rights. This endpoint can cause serious performance issues and will be removed in Jira 9.0.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username filter, list includes all users if unspecified", required=true), @Parameter(name="permissions", description="comma separated list of permissions for project or issue returned users must have"), @Parameter(name="issueKey", description="the issue key for the issue for which returned users have specified permissions."), @Parameter(name="projectKey", description="the optional project key to search for users with if no issueKey is supplied."), @Parameter(name="startAt", description="the index of the first user to return (0-based)"), @Parameter(name="maxResults", description="the maximum number of users to return (defaults to 50). The maximum allowed value is 1000. If you specify a value that is higher than this number, your search results will be truncated.")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users that match the search string.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if no project or issue key was provided or when permissions list is empty or contains an invalid entry", responseCode="400"), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the current user does not have admin rights for the project.", responseCode="403"), @ApiResponse(description="Returned if the requested issue or project is not found.", responseCode="404")})
    public Response findUsersWithAllPermissions(@QueryParam(value="username") String name, @QueryParam(value="permissions") String permissions, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="projectKey") String projectKey, @QueryParam(value="startAt") Integer startAt, @QueryParam(value="maxResults") Integer maxResults) {
        this.logDeprecationWarningRespectingMinimumInterval();
        if (StringUtils.isBlank((CharSequence)permissions)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.missing.permission.string"));
        }
        maxResults = this.verifyAndAdjustMaxResults(maxResults);
        startAt = this.verifyAndAdjustStartAt(startAt);
        Either<Project, Issue> issueOrProject = this.getIssueOrProject(issueKey, projectKey);
        Project project = (Project)issueOrProject.left().on(Issue::getProjectObject);
        ApplicationUser currentUser = this.authContext.getUser();
        if (!(this.permissionManager.hasPermission(44, currentUser) || this.permissionManager.hasPermission(0, currentUser) || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, currentUser))) {
            throw new ForbiddenWebException();
        }
        ImmutableList<Integer> permissionIds = this.parsePermissions(permissions);
        Integer maxResultsForQuery = startAt + maxResults;
        List<ApplicationUser> usersWithPermission = this.findUsersWithPermission((Iterable<Integer>)permissionIds, name, issueOrProject, true, maxResultsForQuery);
        List<ApplicationUser> page = this.userPickerHelper.limitUserSearch(startAt, maxResults, usersWithPermission, null);
        return Response.ok(this.makeUserBeans(page)).cacheControl(CacheControl.never()).build();
    }

    private synchronized void logDeprecationWarningRespectingMinimumInterval() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastLogTime >= TimeUnit.MINUTES.toMillis(5L)) {
            log.warn("Endpoint /rest/user/permission/search can cause serious performance issues and will be removed in Jira 9.0.");
            this.lastLogTime = currentTime;
        }
    }

    @VisibleForTesting
    ImmutableList<Integer> parsePermissions(String permissions) {
        ImmutableList requestedPermissions = ImmutableList.copyOf((Object[])StringUtils.split((String)permissions, (String)","));
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)requestedPermissions, permission -> {
            try {
                return Permissions.Permission.valueOf((String)permission).getId();
            }
            catch (IllegalArgumentException e) {
                throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.invalid.permission.string", permission));
            }
        }));
    }

    @GET
    @Path(value="assignable/multiProjectSearch")
    @AnonymousSiteAccess
    @Operation(summary="Find bulk assignable users", description="Returns a list of users that match the search string and can be assigned issues for all the given projects.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="the username", required=true), @Parameter(name="projectKeys", description="the keys of the projects we are finding assignable users for, comma-separated"), @Parameter(name="maxResults", description="the maximum number of users to return (defaults to 50). The maximum allowed value is 100. If you specify a value that is higher than this number, your search results will be truncated."), @Parameter(name="uriInfo", description="Context used for constructing user objects")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of users that match the search string.", responseCode="200", content={@Content(schema=@Schema(implementation=UserBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404"), @ApiResponse(description="Returned if the current user has no permission to browse project.", responseCode="403")})
    public Response findBulkAssignableUsers(@QueryParam(value="username") String name, @QueryParam(value="projectKeys") String projectKeysStr, @QueryParam(value="maxResults") @DefaultValue(value="50") Integer maxResults, @Context UriInfo uriInfo) {
        if (StringUtils.isBlank((CharSequence)projectKeysStr)) {
            throw new RESTException(Response.Status.BAD_REQUEST, this.authContext.getI18nHelper().getText("rest.missing.field", "projectKeys"));
        }
        String[] projectKeys = projectKeysStr.split(",");
        ArrayList<Project> projects = new ArrayList<Project>(projectKeys.length);
        for (String projectKey : projectKeys) {
            ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.authContext.getUser(), projectKey, ProjectAction.VIEW_PROJECT);
            if (projectResult.getErrorCollection().hasAnyErrors()) {
                ErrorCollection errors = ErrorCollection.of(projectResult.getErrorCollection());
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errors).cacheControl(CacheControl.never()).build();
            }
            if (!this.permissionManager.hasPermission(ProjectPermissions.ASSIGN_ISSUES, projectResult.getProject(), this.authContext.getLoggedInUser())) continue;
            projects.add(projectResult.getProject());
        }
        maxResults = this.verifyAndAdjustMaxResults(maxResults, MAX_USERS_RETURNED_FOR_OPTIMISED_LOOKUP);
        boolean defaultStartAt = false;
        int maxResultsRequired = (int)Math.min(Integer.MAX_VALUE, (long)maxResults.intValue() + 100L);
        List page = projects.stream().map(project -> this.findAssignableUsers(name, project.getKey(), null, maxResultsRequired)).reduce(UserSearchUtilities::intersectionRespectingLowerUsername).orElseGet(ImmutableList::of);
        return Response.ok(this.makeUserBeans(this.userPickerHelper.limitUserSearch(0, maxResults, page, null))).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="avatars")
    @Operation(summary="Get all avatars for user", description="Returns all avatars which are visible for the currently logged in user.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="username", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a map containing a list of avatars for both custom an system avatars", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if an error occurs while retrieving the list of avatars.", responseCode="500"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404")})
    public Map<String, List<AvatarBean>> getAllAvatars(@QueryParam(value="username") String name) {
        ApplicationUser user = this.getApplicationUser(name);
        Long selectedAvatarId = null;
        Avatar selectedAvatar = this.avatarService.getAvatar(this.authContext.getUser(), user);
        if (selectedAvatar != null) {
            selectedAvatarId = selectedAvatar.getId();
        }
        return this.avatarResourceHelper.getAllAvatars(IconType.USER_ICON_TYPE, user.getKey(), selectedAvatarId);
    }

    @POST
    @Path(value="avatar")
    @Operation(summary="Create avatar from temporary", description="Converts temporary avatar into a real avatar", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="username", required=true)
    @RequestBody(description="Cropping instructions", required=true, content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns created avatar", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the cropping coordinates are invalid", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to pick avatar", responseCode="403"), @ApiResponse(description="Returned if user from parameter does not exist", responseCode="404"), @ApiResponse(description="Returned if an error occurs while converting temporary avatar to real avatar", responseCode="500")})
    public Response createAvatarFromTemporary(@QueryParam(value="username") String username, AvatarCroppingBean croppingInstructions) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.getApplicationUser(username);
        return this.avatarResourceHelper.createAvatarFromTemporary(IconType.USER_ICON_TYPE, user.getKey(), croppingInstructions);
    }

    @PUT
    @Path(value="avatar")
    @Operation(summary="Update user avatar", description="Updates the avatar for the user.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="username", required=true)
    @RequestBody(description="New avatar details", required=true, content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returns updated avatar", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the avatar details are invalid", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to update avatar", responseCode="403"), @ApiResponse(description="Returned if user from parameter does not exist", responseCode="404"), @ApiResponse(description="Returned if an error occurs while updating the avatar", responseCode="500")})
    public Response updateUserAvatar(@QueryParam(value="username") String username, AvatarBean avatarBean) {
        Long avatarId;
        ApplicationUser userObject = this.getApplicationUser(username);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(userObject);
        String id = avatarBean.getId();
        try {
            avatarId = id == null ? null : Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            avatarId = null;
        }
        if (!this.avatarManager.hasPermissionToEdit(this.authContext.getUser(), userObject)) {
            throw new ForbiddenWebException();
        }
        propertySet.setLong("user.avatar.id", avatarId.longValue());
        this.eventPublisher.publish((Object)new UserAvatarUpdatedEvent(userObject, avatarId));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="avatar/temporary")
    @Operation(summary="Store temporary avatar", description="Creates temporary avatar. Creating a temporary avatar is part of a 3-step process in uploading a new\navatar for a user: upload, crop, confirm.\nThe following examples shows these three steps using curl.\nThe cookies (session) need to be preserved between requests, hence the use of -b and -c.\nThe id created in step 2 needs to be passed to step 3\n(you can simply pass the whole response of step 2 as the request of step 3).\ncurl -c cookiejar.txt -X POST -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: image/png\" --data-binary @mynewavatar.png \\\n  'http://localhost:8090/jira/rest/api/2/user/avatar/temporary?username=admin&amp;filename=mynewavatar.png'\ncurl -b cookiejar.txt -X POST -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: application/json\" --data '{\"cropperWidth\": \"65\",\"cropperOffsetX\": \"10\",\"cropperOffsetY\": \"16\"}' \\\n  -o tmpid.json \\\n  http://localhost:8090/jira/rest/api/2/user/avatar?username=admin\ncurl -b cookiejar.txt -X PUT -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -H \"Content-Type: application/json\" --data-binary @tmpid.json \\\n  http://localhost:8090/jira/rest/api/2/user/avatar?username=admin", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="username", required=true), @Parameter(name="filename", description="name of file being uploaded", required=true), @Parameter(name="size", description="size of file", required=true)})
    @RequestBody(description="The file data", required=true, content={@Content(mediaType="application/octet-stream")})
    @ApiResponses(value={@ApiResponse(description="Returns temporary avatar cropping instructions", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to store the avatar or XSRF token is invalid.", responseCode="403"), @ApiResponse(description="Returned if the user passed in parameter does not exist.", responseCode="404"), @ApiResponse(description="Returned if an error occurs while converting temporary avatar to real avatar", responseCode="500")})
    public Response storeTemporaryAvatar(@QueryParam(value="username") String username, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.getApplicationUser(username);
        return this.avatarResourceHelper.storeTemporaryAvatar(IconType.USER_ICON_TYPE, user.getKey(), filename, size, request);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="avatar/temporary")
    @Produces(value={"text/html"})
    @Operation(summary="Store temporary avatar using multipart", description="Creates temporary avatar using multipart. The response is sent back as JSON stored in a textarea. This is because the client uses remote iframing to submit avatars using multipart. So we must send them a valid HTML page back from which the client parses the JSON from.\nCreating a temporary avatar is part of a 3-step process in uploading a new avatar for a user: upload, crop, confirm. This endpoint allows you to use a multipart upload instead of sending the image directly as the request body.\nYou *must* use \"avatar\" as the name of the upload parameter:\ncurl -c cookiejar.txt -X POST -u admin:admin -H \"X-Atlassian-Token: no-check\" \\\n  -F \"avatar=@mynewavatar.png;type=image/png\" \\\n  'http://localhost:8090/jira/rest/api/2/user/avatar/temporary?username=admin'", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="username", required=true)
    @RequestBody(description="The file data", required=true, content={@Content(mediaType="multipart/form-data")})
    @ApiResponses(value={@ApiResponse(description="Returns temporary avatar cropping instructions embeded in HTML page. Error messages will also be embeded in the page.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="text/html")}), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to store the avatar or XSRF token is invalid.", responseCode="403"), @ApiResponse(description="Returned if user does NOT exist", responseCode="404"), @ApiResponse(description="Returned if an error occurs while converting temporary avatar to real avatar", responseCode="500")})
    public Response storeTemporaryAvatarUsingMultiPart(@QueryParam(value="username") String username, @MultipartFormParam(value="avatar") FilePart filePart, @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ApplicationUser user = this.getApplicationUser(username);
        return this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(IconType.USER_ICON_TYPE, user.getKey(), filePart, request);
    }

    @DELETE
    @Path(value="avatar/{id}")
    @Operation(summary="Delete avatar", description="Deletes avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="username", required=true), @Parameter(name="id", description="database id for avatar", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the avatar is successfully deleted.", responseCode="204"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the currently authenticated user does not have permission to delete the avatar.", responseCode="403"), @ApiResponse(description="Returned if the avatar does not exist.", responseCode="404")})
    public Response deleteAvatar(@QueryParam(value="username") String username, @PathParam(value="id") Long id) {
        return this.avatarResourceHelper.deleteAvatar(id);
    }

    @GET
    @Path(value="columns")
    @Operation(summary="Get default columns for user", description="Returns the default columns for the given user. Admin permission will be required to get columns for a user other than the currently logged in user.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="username", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of columns for configured for the given user", responseCode="200", content={@Content(schema=@Schema(implementation=ColumnOptions.class), mediaType="application/json")}), @ApiResponse(description="Returned if the current user is not permitted to request the columns for the given user.", responseCode="401"), @ApiResponse(description="Returned if the requested user is not found.", responseCode="404"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response defaultColumns(@QueryParam(value="username") String username) {
        ApplicationUser columnUser;
        ApplicationUser currentUser = this.authContext.getUser();
        ServiceOutcome outcome = this.columnService.getColumnLayout(currentUser, columnUser = username == null ? currentUser : this.getApplicationUser(username));
        if (outcome.isValid()) {
            List columnLayoutItems = ((ColumnLayout)outcome.getReturnedValue()).getColumnLayoutItems();
            return Response.ok(ColumnOptions.toColumnOptions(columnLayoutItems)).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @Path(value="columns")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AnonymousSiteAccess
    @Operation(summary="Set default columns for user", description="Sets the default columns for the given user. Admin permission will be required to get columns for a user other than the currently logged in user.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="username", required=true), @Parameter(name="columns", description="list of column ids", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned when the columns is saved successfully", responseCode="200"), @ApiResponse(description="Returned if an error occurs while retrieving the column configuration.", responseCode="500")})
    public Response setColumnsUrlEncoded(@FormParam(value="username") String username, @FormParam(value="columns") List<String> fields) {
        ApplicationUser columnUser;
        ApplicationUser currentUser = this.authContext.getUser();
        ServiceResult outcome = this.columnService.setColumns(currentUser, columnUser = username == null ? currentUser : this.getApplicationUser(username), fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @Path(value="columns")
    @Consumes(value={"application/json"})
    @AnonymousSiteAccess
    @Operation(summary="Set columns for logged in user", description="Sets the default columns for the currently logged in user.", security={@SecurityRequirement(name="basic")})
    @RequestBody(description="List of column ids", required=true, content={@Content(schema=@Schema(implementation=ColumnsBean.class), mediaType="application/json")})
    @ApiResponses(value={@ApiResponse(description="Returned when the columns are saved successfully", responseCode="200"), @ApiResponse(description="Returned if an error occurs while setting the column configuration.", responseCode="500")})
    public Response setColumns(ColumnsBean columns) {
        ApplicationUser columnUser = this.authContext.getLoggedInUser();
        ServiceResult outcome = this.columnService.setColumns(columnUser, columnUser, columns.getColumns());
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @DELETE
    @Path(value="columns")
    @Consumes(value={"*/*"})
    @Operation(summary="Reset default columns to system default", description="Reset the default columns for the given user to the system default. Admin permission will be required to get columns for a user other than the currently logged in user.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="username", description="username", required=true)
    @ApiResponses(value={@ApiResponse(description="Returned when the columns are reset successfully", responseCode="204"), @ApiResponse(description="Returned if the current user is not permitted to request the columns for the given user.", responseCode="401"), @ApiResponse(description="Returned if an error occurs while resetting the column configuration.", responseCode="500")})
    public Response resetColumns(@QueryParam(value="username") String username) {
        ApplicationUser columnUser;
        ApplicationUser currentUser = this.authContext.getUser();
        ServiceResult outcome = this.columnService.resetColumns(currentUser, columnUser = username == null ? currentUser : this.getApplicationUser(username));
        if (outcome.isValid()) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @POST
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="application")
    @Operation(summary="Add user to application", description="Add user to given application. Admin permission will be required to perform this operation.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="username", required=true), @Parameter(name="applicationKey", description="application key", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the user exists, the caller has permission to add user to application and user was successfully added to application.", responseCode="200"), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to add user to application.", responseCode="403")})
    public Response addUserToApplication(@QueryParam(value="username") String username, @QueryParam(value="applicationKey") String applicationKey) {
        UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult = this.updateUserApplicationHelper.addUserToApplication(username, applicationKey);
        if (!applicationUpdateResult.isValid()) {
            return this.responseFactory.errorResponse(applicationUpdateResult.getErrorCollection());
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @WebSudoRequired
    @ExperimentalApi
    @Path(value="application")
    @Operation(summary="Remove user from application", description="Remove user from given application. Admin permission will be required to perform this operation.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="username", description="username", required=true), @Parameter(name="applicationKey", description="application key", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returned if the user exists, the caller has permission to remove user from application and the user was successfully removed from application.", responseCode="204"), @ApiResponse(description="Returned if the request is invalid.", responseCode="400"), @ApiResponse(description="Returned if the user is not authenticated.", responseCode="401"), @ApiResponse(description="Returned if the caller user does not have permission to remove user from application.", responseCode="403")})
    public Response removeUserFromApplication(@QueryParam(value="username") String username, @QueryParam(value="applicationKey") String applicationKey) {
        UpdateUserApplicationHelper.ApplicationUpdateResult applicationUpdateResult = this.updateUserApplicationHelper.removeUserFromApplication(username, applicationKey);
        if (!applicationUpdateResult.isValid()) {
            return this.responseFactory.errorResponse(applicationUpdateResult.getErrorCollection());
        }
        return this.responseFactory.noContent();
    }

    private UserBean buildUserBean(String name, String key, boolean includeDeleted, ApplicationUser loggedInUser) {
        ApplicationUser user = this.getUserByUsernameOrKey(name, key, includeDeleted);
        String username = user.getUsername();
        UserBeanBuilder builder = UserBeanBuilder.fullBuilder(this.jiraBaseUrls, this.emailFormatter, this.avatarService, this.beanFactory, this.userManager, loggedInUser).user(user).groups(new ArrayList<String>(this.userUtil.getGroupNamesForUser(username))).timeZone(this.timeZoneManager.getTimeZoneforUser(user)).applicationRoles(this.applicationRoleManager.getRolesForUser(user)).lastLoginTime(this.getFormattedLastLoginTime(username));
        return builder.buildFull(this.applicationRoleBeanConverter);
    }

    private ApplicationUser getUserByUsernameOrKey(String name, String key, boolean includeDeleted) {
        if (name == null && key == null) {
            throw new RESTException(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.or.key.param")));
        }
        if (name != null && key != null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.too.many.params")));
        }
        ApplicationUser user = includeDeleted ? (key != null ? this.userManager.getUserByKeyEvenWhenUnknown(key) : this.userManager.getUserByNameEvenWhenUnknown(name)) : (key != null ? this.userManager.getUserByKey(key) : this.userManager.getUserByName(name));
        if (user == null) {
            if (name != null) {
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found", name)));
            }
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found.with.key", key)));
        }
        if (includeDeleted) {
            boolean userNotExitingAndNotDeleted;
            boolean bl = userNotExitingAndNotDeleted = !this.userManager.isUserExisting(user) && !this.userManager.isUserDeleted(user);
            if (userNotExitingAndNotDeleted) {
                if (name != null) {
                    throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found", name)));
                }
                throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found.with.key", key)));
            }
        }
        return user;
    }

    private ApplicationUser getApplicationUser(String name) {
        if (name == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.param")));
        }
        ApplicationUser user = this.userManager.getUserByName(name);
        if (user == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.user.error.not.found", name)));
        }
        return user;
    }

    private List<UserBean> makeUserBeans(Collection<ApplicationUser> users) {
        ArrayList<UserBean> beans = new ArrayList<UserBean>(users.size());
        for (ApplicationUser user : users) {
            UserBeanBuilder builder = UserBeanBuilder.midBuilder(this.jiraBaseUrls, this.emailFormatter, this.beanFactory, this.userManager, this.authContext.getLoggedInUser()).user(user).timeZone(this.timeZoneManager.getTimeZoneforUser(user));
            beans.add(builder.buildMid());
        }
        return beans;
    }

    private String getFormattedLastLoginTime(String username) {
        LoginInfo loginInfo = this.loginService.getLoginInfo(username);
        if (loginInfo == null) {
            return "";
        }
        Long lastLoginTime = loginInfo.getLastLoginTime();
        if (lastLoginTime == null) {
            return "";
        }
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser();
        return dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(new Date(lastLoginTime));
    }

    private RESTException createWebException(String message, ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message, reason);
        return new RESTException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
    }
}

