/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarUrls;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBean;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBeanConverter;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserResource;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;

public class UserBeanBuilder {
    private final JiraBaseUrls jiraBaseUrls;
    private ApplicationUser user;
    private String username;
    private List<String> groups;
    private ApplicationUser loggedInUser;
    private boolean loggedInUserIsSet;
    private EmailFormatter emailFormatter;
    private TimeZone timeZone;
    private Set<ApplicationRole> applicationRoles;
    private AvatarService avatarService;
    private UserManager userManager;
    private I18nHelper.BeanFactory beanFactory;
    private URI self;
    private String lastLoginTime;

    public UserBeanBuilder(@Nonnull JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = (JiraBaseUrls)Preconditions.checkNotNull((Object)jiraBaseUrls, (Object)"JiraBaseUrls cannot be null!");
    }

    public static UserBeanBuilder fullBuilder(@Nonnull JiraBaseUrls jiraBaseUrls, @Nonnull EmailFormatter emailFormatter, @Nonnull AvatarService avatarService, @Nonnull I18nHelper.BeanFactory beanFactory, @Nonnull UserManager userManager, @Nullable ApplicationUser loggedInUser) {
        return new UserBeanBuilder(Objects.requireNonNull(jiraBaseUrls)).emailFormatter(Objects.requireNonNull(emailFormatter)).avatarService(Objects.requireNonNull(avatarService)).i18nBeanFactory(Objects.requireNonNull(beanFactory)).userManager(Objects.requireNonNull(userManager)).loggedInUser(loggedInUser);
    }

    public static UserBeanBuilder midBuilder(@Nonnull JiraBaseUrls jiraBaseUrls, @Nonnull EmailFormatter emailFormatter, @Nonnull I18nHelper.BeanFactory beanFactory, @Nonnull UserManager userManager, @Nullable ApplicationUser loggedInUser) {
        return new UserBeanBuilder(Objects.requireNonNull(jiraBaseUrls)).emailFormatter(Objects.requireNonNull(emailFormatter)).userManager(Objects.requireNonNull(userManager)).i18nBeanFactory(Objects.requireNonNull(beanFactory)).loggedInUser(loggedInUser);
    }

    public static UserBeanBuilder shortBuilder(@Nonnull JiraBaseUrls jiraBaseUrls) {
        return new UserBeanBuilder(jiraBaseUrls);
    }

    public UserBeanBuilder user(ApplicationUser user) {
        this.user = user;
        return this;
    }

    public UserBeanBuilder user(String username, UserManager userManager) {
        this.username = username;
        this.user = userManager.getUserByName(username);
        return this;
    }

    public UserBeanBuilder groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public UserBeanBuilder self(URI self) {
        this.self = self;
        return this;
    }

    public UserBeanBuilder loggedInUser(ApplicationUser loggedInUser) {
        this.loggedInUser = loggedInUser;
        this.loggedInUserIsSet = true;
        return this;
    }

    public UserBeanBuilder timeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
        return this;
    }

    public UserBeanBuilder i18nBeanFactory(I18nHelper.BeanFactory beanFactory) {
        if (beanFactory != null) {
            this.beanFactory = beanFactory;
        }
        return this;
    }

    public UserBeanBuilder emailFormatter(EmailFormatter emailFormatter) {
        this.emailFormatter = emailFormatter;
        return this;
    }

    public UserBeanBuilder avatarService(AvatarService avatarService) {
        this.avatarService = avatarService;
        return this;
    }

    public UserBeanBuilder userManager(UserManager userManager) {
        this.userManager = userManager;
        return this;
    }

    public UserBeanBuilder applicationRoles(Set<ApplicationRole> applicationRoles) {
        this.applicationRoles = applicationRoles;
        return this;
    }

    public UserBeanBuilder lastLoginTime(String lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        return this;
    }

    public UserBean buildShort() {
        if (this.user != null) {
            return new UserBean(this.self != null ? this.self : this.createSelfLink(false), this.user.getKey(), this.user.getUsername(), this.user.getDisplayName(), this.user.isActive(), UserBeanBuilder.getAvatarURLs(this.user));
        }
        return this.buildSimple();
    }

    public UserBean buildFull(ApplicationRoleBeanConverter applicationRoleBeanConverter) {
        if (this.user == null) {
            return this.buildMid();
        }
        if (this.groups == null) {
            throw new IllegalStateException("groups not set");
        }
        if (this.emailFormatter == null) {
            throw new IllegalStateException("emailFormatter not set");
        }
        if (!this.loggedInUserIsSet) {
            throw new IllegalStateException("loggedInUser not set");
        }
        if (this.timeZone == null) {
            throw new IllegalStateException("timeZone not set");
        }
        if (this.avatarService == null) {
            throw new IllegalStateException("avatarService not set");
        }
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory not set");
        }
        if (this.userManager == null) {
            throw new IllegalStateException("userManager not set");
        }
        ImmutableList userRoles = this.applicationRoles != null ? ImmutableList.copyOf((Iterable)Iterables.transform(this.applicationRoles, applicationRoleBeanConverter.toShortBean())) : null;
        boolean userDeleted = this.userManager.isUserDeleted(this.user);
        return new UserBean(this.self != null ? this.self : this.createSelfLink(userDeleted), this.user.getKey(), this.user.getUsername(), this.user.getDisplayName(), this.user.isActive(), userDeleted, this.emailFormatter.formatEmail(this.user.getEmailAddress(), this.loggedInUser), (List<GroupJsonBean>)ImmutableList.copyOf((Iterable)Iterables.transform(this.groups, (Function)new GroupNameToGroupJsonBean(this.jiraBaseUrls))), UserBeanBuilder.getAvatarURLs(this.user), this.timeZone, this.beanFactory.getInstance(this.user).getLocale(), (List<ApplicationRoleBean>)userRoles, this.lastLoginTime);
    }

    public UserBean buildMid() {
        if (this.user == null) {
            return this.buildSimple();
        }
        if (!this.loggedInUserIsSet) {
            throw new IllegalStateException("loggedInUser not set");
        }
        if (this.emailFormatter == null) {
            throw new IllegalStateException("emailFormatter not set");
        }
        if (this.timeZone == null) {
            throw new IllegalStateException("timeZone not set");
        }
        if (this.userManager == null) {
            throw new IllegalStateException("userManager not set");
        }
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory not set");
        }
        boolean userDeleted = this.userManager.isUserDeleted(this.user);
        return new UserBean(this.self != null ? this.self : this.createSelfLink(userDeleted), this.user.getKey(), this.user.getUsername(), this.user.getDisplayName(), this.user.isActive(), userDeleted, this.emailFormatter.formatEmail(this.user.getEmailAddress(), this.loggedInUser), null, UserBeanBuilder.getAvatarURLs(this.user), this.timeZone, this.beanFactory.getInstance(this.user).getLocale(), null, this.lastLoginTime);
    }

    private UserBean buildSimple() {
        if (this.username == null) {
            return null;
        }
        return new UserBean(null, null, this.username, null, false, null);
    }

    protected URI createSelfLink(boolean userDeleted) {
        UriBuilder urlBuilder = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(UserResource.class).queryParam("username", new Object[]{"{0}"});
        if (userDeleted) {
            urlBuilder = urlBuilder.queryParam("includeDeleted", new Object[]{true});
        }
        return urlBuilder.build(new Object[]{this.user.getUsername()});
    }

    static Map<String, URI> getAvatarURLs(ApplicationUser forUser) {
        Avatar avatar = ComponentAccessor.getAvatarService().getAvatar(forUser, forUser);
        return avatar != null ? AvatarUrls.getAvatarURLs((ApplicationUser)forUser, (Avatar)avatar) : null;
    }

    private static class GroupNameToGroupJsonBean
    implements Function<String, GroupJsonBean> {
        private final JiraBaseUrls jiraBaseUrls;

        public GroupNameToGroupJsonBean(JiraBaseUrls jiraBaseUrls) {
            this.jiraBaseUrls = jiraBaseUrls;
        }

        public GroupJsonBean apply(@Nullable String groupName) {
            return new GroupJsonBeanBuilder(this.jiraBaseUrls).name(groupName).build();
        }
    }
}

