/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.rest.api.expand.SimpleListWrapper;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBean;
import com.atlassian.plugins.rest.api.expand.annotation.Expandable;
import com.google.common.base.Objects;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
public class UserBean {
    @XmlElement
    @Schema(example="http://www.example.com/jira/rest/api/2.0/user?username=fred")
    private URI self;
    @XmlElement
    @Schema(example="JIRAUSER10100")
    private String key;
    @XmlElement
    @Schema(example="fred")
    private String name;
    @XmlElement
    @Schema(example="fred@example.com")
    private String emailAddress;
    @XmlElement
    @Schema(example="{\n    \"48x48\": \"http://www.example.com/jira/secure/useravatar?size=large&ownerId=fred\",\n    \"24x24\": \"http://www.example.com/jira/secure/useravatar?size=small&ownerId=fred\",\n    \"16x16\": \"http://www.example.com/jira/secure/useravatar?size=xsmall&ownerId=fred\",\n    \"32x32\": \"http://www.example.com/jira/secure/useravatar?size=medium&ownerId=fred\"\n}")
    private Map<String, URI> avatarUrls;
    @XmlElement
    @Schema(example="Fred F. User")
    private String displayName;
    @XmlElement
    @Schema(example="true")
    private boolean active;
    @XmlElement
    @Schema(example="false")
    private Boolean deleted;
    @XmlElement
    @Schema(example="Australia/Sydney")
    private String timeZone;
    @XmlElement
    @Schema(example="en_AU")
    private String locale;
    @Expandable
    @XmlElement
    private SimpleListWrapper<GroupJsonBean> groups;
    @Expandable
    @XmlElement
    @Schema(example="[\"jira-core\", \"jira-admin\", \"important\"]")
    private SimpleListWrapper<ApplicationRoleBean> applicationRoles;
    @XmlAttribute(name="expand")
    private String expand;
    @XmlElement
    @Schema(example="2023-08-30T16:37:01+1000")
    private String lastLoginTime;

    UserBean() {
    }

    public UserBean(URI self, String key, String name, String displayName, boolean active, Map<String, URI> avatarUrls) {
        this(self, key, name, displayName, active, null, null, avatarUrls, null);
    }

    public UserBean(URI self, String key, String name, String displayName, boolean active, String emailAddress, List<GroupJsonBean> groups, Map<String, URI> avatarUrls, TimeZone timeZone) {
        this(self, key, name, displayName, active, null, emailAddress, groups, avatarUrls, timeZone, null, null, null);
    }

    public UserBean(URI self, String key, String name, String displayName, boolean active, Boolean deleted, String emailAddress, List<GroupJsonBean> groups, Map<String, URI> avatarUrls, TimeZone timeZone, Locale locale, List<ApplicationRoleBean> applicationRoles, String lastLoginTime) {
        this.key = key;
        this.name = name;
        this.self = self;
        this.displayName = displayName;
        this.active = active;
        this.deleted = deleted;
        this.emailAddress = emailAddress;
        this.groups = groups != null ? SimpleListWrapper.of(groups) : null;
        this.avatarUrls = avatarUrls;
        this.timeZone = timeZone != null ? timeZone.getID() : null;
        this.locale = locale != null ? locale.toString() : null;
        this.applicationRoles = applicationRoles != null ? SimpleListWrapper.of(applicationRoles) : null;
        this.lastLoginTime = lastLoginTime;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserBean userBean = (UserBean)o;
        return Objects.equal((Object)this.displayName, (Object)userBean.displayName) && Objects.equal((Object)this.active, (Object)userBean.active) && Objects.equal((Object)this.deleted, (Object)userBean.deleted) && Objects.equal((Object)this.emailAddress, (Object)userBean.emailAddress) && Objects.equal((Object)this.name, (Object)userBean.name) && Objects.equal((Object)this.timeZone, (Object)userBean.timeZone);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.emailAddress, this.active, this.deleted, this.displayName, this.timeZone, this.name});
    }

    public URI getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Map<String, URI> getAvatarUrls() {
        return this.avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getLocale() {
        return this.locale;
    }

    public SimpleListWrapper<GroupJsonBean> getGroups() {
        return this.groups;
    }

    public String getExpand() {
        return this.expand;
    }

    public SimpleListWrapper<ApplicationRoleBean> getApplicationRoles() {
        return this.applicationRoles;
    }

    public String getLastLoginTime() {
        return this.lastLoginTime;
    }
}

