/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageResolver;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.avatar.AvatarUrls;
import com.atlassian.jira.rest.v2.avatar.TemporaryAvatarHelper;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="universal_avatar")
@UnrestrictedAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UniversalAvatarResource {
    public static final String SYSTEM_AVATARS_FIELD = "system";
    public static final String CUSTOM_AVATARS_FIELD = "custom";
    private final JiraAuthenticationContext authContext;
    private final AvatarUrls avatarUrls;
    private final AvatarResourceHelper avatarResourceHelper;
    private final TemporaryAvatarHelper avatarTemporaryHelper;
    private final AvatarManager avatarManager;
    private final AvatarImageResolver avatarImageResolver;

    @Inject
    public UniversalAvatarResource(JiraAuthenticationContext authContext, AvatarUrls avatarUrls, AvatarResourceHelper avatarResourceHelper, TemporaryAvatarHelper avatarTemporaryHelper, @ComponentImport AvatarManager avatarManager, @ComponentImport AvatarImageResolver avatarImageResolver) {
        this.authContext = authContext;
        this.avatarUrls = avatarUrls;
        this.avatarResourceHelper = avatarResourceHelper;
        this.avatarTemporaryHelper = avatarTemporaryHelper;
        this.avatarManager = avatarManager;
        this.avatarImageResolver = avatarImageResolver;
    }

    @GET
    @Path(value="type/{type}/owner/{owningObjectId}")
    @Operation(summary="Get all avatars for a type and owner", description="Returns a list of all avatars", security={@SecurityRequirement(name="basic")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all Jira avatars in JSON format, that are visible to the user.", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if no avatars are found, or the user does not have permission to view them.", responseCode="404")})
    public Response getAvatars(@PathParam(value="type") String avatarType, @PathParam(value="owningObjectId") String owningObjectId) {
        IconType iconType = IconType.of((String)avatarType);
        if (!this.avatarManager.isValidIconType(iconType)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"iconType").build();
        }
        ApplicationUser remoteUser = this.authContext.getUser();
        Predicate<Avatar> isAvatarVisibleFn = avatar -> this.avatarManager.userCanView(remoteUser, avatar);
        List systemAvatars = this.avatarManager.getAllSystemAvatars(iconType);
        List<Avatar> avatarsForOwner = this.avatarManager.getCustomAvatarsForOwner(iconType, owningObjectId).stream().filter(isAvatarVisibleFn::test).collect(Collectors.toList());
        List<AvatarBean> systemAvatarBeans = this.createAvatarBeans(systemAvatars, remoteUser);
        List<AvatarBean> customAvatarBeans = this.createAvatarBeans(avatarsForOwner, remoteUser);
        ImmutableMap result = ImmutableMap.builder().put((Object)SYSTEM_AVATARS_FIELD, systemAvatarBeans).put((Object)CUSTOM_AVATARS_FIELD, customAvatarBeans).build();
        return Response.ok((Object)result).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Path(value="type/{type}/owner/{owningObjectId}/temp")
    @Operation(summary="Create temporary avatar from uploaded file", description="Creates temporary avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="avatarType", description="Type of entity where to change avatar", required=true), @Parameter(name="owningObjectId", description="Entity id where to change avatar", required=true), @Parameter(name="filename", description="name of file being uploaded", required=true), @Parameter(name="size", description="size of file", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns temporary avatar cropping instructions.", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the provided data isn't valid.", responseCode="400"), @ApiResponse(description="Returned if the user doesn't have admin permissions.", responseCode="403"), @ApiResponse(description="Returned if the feature is turned off via a feature flag.", responseCode="404")})
    public Response storeTemporaryAvatar(@PathParam(value="type") String avatarType, @PathParam(value="owningObjectId") String owningObjectId, @QueryParam(value="filename") String filename, @QueryParam(value="size") Long size, @Context HttpServletRequest request) {
        try {
            IconType iconType = IconType.of((String)avatarType);
            if (!this.avatarManager.isValidIconType(iconType)) {
                throw new NoSuchElementException("avatarType");
            }
            ApplicationUser remoteUser = this.authContext.getUser();
            Avatar.Size avatarTargetSize = Avatar.Size.LARGE;
            Response storeTemporaryAvatarResponse = this.avatarTemporaryHelper.storeTemporaryAvatar(remoteUser, iconType, owningObjectId, avatarTargetSize, filename, size, request);
            return storeTemporaryAvatarResponse;
        }
        catch (NoSuchElementException x) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)x.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="type/{type}/owner/{owningObjectId}/temp")
    @Produces(value={"text/html"})
    @Operation(summary="Create temporary avatar using multipart upload", description="Creates temporary avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="avatarType", description="Type of entity where to change avatar", required=true), @Parameter(name="owningObjectId", description="Entity id where to change avatar", required=true), @Parameter(name="filename", description="name of file being uploaded", required=true), @Parameter(name="size", description="size of file", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns temporary avatar cropping instructions.", responseCode="200", content={@Content(schema=@Schema(implementation=AvatarCroppingBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the provided data isn't valid.", responseCode="400"), @ApiResponse(description="Returned if the user doesn't have admin permissions.", responseCode="403"), @ApiResponse(description="Returned if the feature is turned off via a feature flag.", responseCode="404")})
    public Response storeTemporaryAvatarUsingMultiPart(@PathParam(value="type") String avatarType, @PathParam(value="owningObjectId") String owningObjectId, @MultipartFormParam(value="avatar") FilePart filePart, @Context HttpServletRequest request) {
        try {
            try {
                IconType iconType = IconType.of((String)avatarType);
                if (null == iconType) {
                    throw new NoSuchElementException("avatarType");
                }
                ApplicationUser remoteUser = this.authContext.getUser();
                Avatar.Size avatarTargetSize = Avatar.Size.LARGE;
                Response storeTemporaryAvatarResponse = this.avatarTemporaryHelper.storeTemporaryAvatar(remoteUser, iconType, owningObjectId, avatarTargetSize, filePart, request);
                return storeTemporaryAvatarResponse;
            }
            catch (NoSuchElementException x) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)x.getMessage()).build();
            }
        }
        catch (RESTException x) {
            String errorMsgs = x.toString();
            String sep = "";
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("<html><body><textarea>{\"errorMessages\": [" + errorMsgs + "]}</textarea></body></html>")).cacheControl(CacheControl.never()).build();
        }
    }

    @POST
    @Path(value="type/{type}/owner/{owningObjectId}/avatar")
    @Operation(summary="Create avatar from temporary", description="Creates avatar from temporary", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="avatarType", description="Type of entity where to change avatar", required=true), @Parameter(name="owningObjectId", description="Entity id where to change avatar", required=true), @Parameter(name="croppingInstructions", description="Cropping instructions for the avatar", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns the created avatar.", responseCode="201", content={@Content(schema=@Schema(implementation=AvatarBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the provided data isn't valid.", responseCode="400"), @ApiResponse(description="Returned if the user doesn't have admin permissions.", responseCode="403"), @ApiResponse(description="Returned if the feature is turned off via a feature flag.", responseCode="404")})
    public Response createAvatarFromTemporary(@PathParam(value="type") String avatarType, @PathParam(value="owningObjectId") String owningObjectId, AvatarCroppingBean croppingInstructions) {
        try {
            IconType iconType = IconType.of((String)avatarType);
            if (!this.avatarManager.isValidIconType(iconType)) {
                throw new NoSuchElementException("avatarType");
            }
            ApplicationUser remoteUser = this.authContext.getUser();
            AvatarBean avatarFromTemporary = this.avatarTemporaryHelper.createAvatarFromTemporary(remoteUser, iconType, owningObjectId, croppingInstructions);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)avatarFromTemporary).cacheControl(CacheControl.never()).build();
        }
        catch (NoSuchElementException x) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)x.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="type/{type}/owner/{owningObjectId}/avatar/{id}")
    @Operation(summary="Delete avatar by ID", description="Deletes avatar", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="avatarType", description="Type of entity where to change avatar", required=true), @Parameter(name="owningObjectId", description="Entity id where to change avatar", required=true), @Parameter(name="id", description="database id for avatar", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns the status of the deletion.", responseCode="200"), @ApiResponse(description="Returned if the provided data isn't valid.", responseCode="400"), @ApiResponse(description="Returned if the user doesn't have admin permissions.", responseCode="403"), @ApiResponse(description="Returned if the feature is turned off via a feature flag.", responseCode="404")})
    public Response deleteAvatar(@PathParam(value="type") String avatarType, @PathParam(value="owningObjectId") String owningObjectId, @PathParam(value="id") Long id) {
        IconType iconType = IconType.of((String)avatarType);
        if (!this.avatarManager.isValidIconType(iconType)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.avatarManager.userCanCreateFor(this.authContext.getLoggedInUser(), iconType, new IconOwningObjectId(owningObjectId))) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Response avatarFromTemporaryResponse = this.avatarResourceHelper.deleteAvatar(id);
        return avatarFromTemporaryResponse;
    }

    private List<AvatarBean> createAvatarBeans(Iterable<Avatar> avatars, ApplicationUser remoteUser) {
        ArrayList beans = Lists.newArrayList();
        for (Avatar avatar : avatars) {
            AvatarBean bean = new AvatarBean(avatar.getId().toString(), avatar.getOwner(), avatar.isSystemAvatar(), this.avatarManager.userCanDelete(remoteUser, avatar), this.avatarUrls.getAvatarURLs(remoteUser, avatar, this.avatarImageResolver));
            beans.add(bean);
        }
        return beans;
    }
}

