/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.comparator.ConstantsComparator;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.StatusHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="status")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusResource {
    private ConstantsService constantsService;
    private JiraAuthenticationContext authContext;
    private StatusHelper statusHelper;
    private JiraBaseUrls jiraBaseUrls;
    private StatusService statusService;

    private StatusResource() {
    }

    @Inject
    public StatusResource(JiraAuthenticationContext authContext, ConstantsService constantsService, StatusHelper statusHelper, JiraBaseUrls jiraBaseUrls, StatusService statusService) {
        this.authContext = authContext;
        this.constantsService = constantsService;
        this.statusHelper = statusHelper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.statusService = statusService;
    }

    @GET
    @Operation(summary="Get all statuses", description="Returns a list of all statuses", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="request", description="a Request", required=true), @Parameter(name="uriInfo", description="a UriInfo", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all Jira issue statuses in JSON format, that are visible to the user.", responseCode="200", content={@Content(schema=@Schema(implementation=StatusJsonBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the requested issue status is not found, or the user does not have permission to view it.", responseCode="404")})
    public Response getStatuses(@Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome outcome = this.constantsService.getAllStatuses(this.authContext.getUser());
        if (!outcome.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        Collection returnedValue = (Collection)outcome.getReturnedValue();
        ArrayList<StatusJsonBean> beans = new ArrayList<StatusJsonBean>(returnedValue.size());
        for (Status status : returnedValue) {
            StatusJsonBean statusBean = this.statusHelper.createStatusBean(status, uriInfo, StatusResource.class);
            beans.add(statusBean);
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{idOrName}")
    @Operation(summary="Get status by ID or name", description="Returns a full representation of the Status having the given id or name.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="idOrName", description="A numeric Status id or a status name", required=true), @Parameter(name="request", description="A Request", required=true), @Parameter(name="uriInfo", description="A UriInfo", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of a Jira issue status in JSON format.", responseCode="200", content={@Content(schema=@Schema(implementation=StatusJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requested issue status is not found, or the user does not have permission to view it.", responseCode="404")})
    public Response getStatus(@PathParam(value="idOrName") String idOrName, @Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome statusOutcome = this.constantsService.getStatusById(this.authContext.getUser(), idOrName);
        if (!statusOutcome.isValid() && !(statusOutcome = this.constantsService.getStatusByTranslatedName(this.authContext.getUser(), idOrName)).isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(statusOutcome.getErrorCollection()));
        }
        return Response.ok((Object)this.statusHelper.createStatusBean((Status)statusOutcome.getReturnedValue(), uriInfo, StatusResource.class)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="page")
    @Produces(value={"application/json"})
    @ExperimentalApi
    @Operation(summary="Get paginated filtered statuses", description="Returns paginated list of filtered statuses", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="startAt", description="The index of the first status to return."), @Parameter(name="maxResults", description="The maximum number of statuses to return."), @Parameter(name="query", description="The string that status names will be matched with."), @Parameter(name="projectIds", description="The list of project ids to filter statuses."), @Parameter(name="issueTypeIds", description="The list of issue type ids to filter statuses.")})
    @ApiResponse(description="Returns paginated list of statuses.", responseCode="200", content={@Content(schema=@Schema(implementation=StatusJsonBean.class, type="array"), mediaType="application/json")})
    public Response getPaginatedStatuses(@DefaultValue(value="0") @QueryParam(value="startAt") Long startAt, @DefaultValue(value="100") @QueryParam(value="maxResults") Integer maxResults, @DefaultValue(value="") @QueryParam(value="query") String query, @QueryParam(value="projectIds") Set<Long> projectIds, @QueryParam(value="issueTypeIds") Set<String> issueTypeIds) {
        Set statuses = this.statusService.findStatuses(this.authContext.getLoggedInUser(), query, projectIds, issueTypeIds).collect(Collectors.toCollection(() -> new TreeSet(ConstantsComparator.COMPARATOR)));
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page statusPage = Pages.toPage((Iterable)statuses, (PageRequest)pageRequest);
        PageBean<StatusJsonBean> bean = PageBean.from(pageRequest, statusPage).build(status -> StatusJsonBean.bean((Status)status, (JiraBaseUrls)this.jiraBaseUrls));
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }
}

