/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusCategoryJsonBean;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.StatusCategoryHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="statuscategory")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusCategoryResource {
    private JiraAuthenticationContext authContext;
    private ConstantsService constantsService;
    private StatusCategoryHelper statusCategoryHelper;

    @Inject
    public StatusCategoryResource(JiraAuthenticationContext authContext, ConstantsService constantsService, StatusCategoryHelper statusCategoryHelper) {
        this.authContext = authContext;
        this.constantsService = constantsService;
        this.statusCategoryHelper = statusCategoryHelper;
    }

    private StatusCategoryResource() {
    }

    @GET
    @Operation(summary="Get all status categories", description="Returns a list of all status categories", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="request", in=ParameterIn.QUERY, description="a Request"), @Parameter(name="uriInfo", in=ParameterIn.QUERY, description="a UriInfo")})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all Jira issue status categories in JSON format, that are visible to the user.", responseCode="200", content={@Content(schema=@Schema(implementation=StatusCategoryJsonBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if no status categories are found, or the user does not have permission to view them.", responseCode="404")})
    public Response getStatusCategories(@Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome outcome = this.constantsService.getAllStatusCategories(this.authContext.getUser());
        if (!outcome.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(outcome.getErrorCollection()));
        }
        Collection returnedValue = (Collection)outcome.getReturnedValue();
        ArrayList<StatusCategoryJsonBean> beans = new ArrayList<StatusCategoryJsonBean>(returnedValue.size());
        for (StatusCategory statusCategory : returnedValue) {
            StatusCategoryJsonBean statusCategoryBean = this.statusCategoryHelper.createStatusCategoryBean(statusCategory, uriInfo, StatusCategoryResource.class);
            beans.add(statusCategoryBean);
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{idOrKey}")
    @Operation(summary="Get status category by ID or key", description="Returns a full representation of the StatusCategory having the given id or key", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="idOrKey", description="A numeric StatusCategory id or a status category key", required=true), @Parameter(name="request", description="A Request", required=true), @Parameter(name="uriInfo", description="A UriInfo", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns a full representation of a Jira issue status category in JSON format.", responseCode="200", content={@Content(schema=@Schema(implementation=StatusCategoryJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the requested issue status category is not found, or the user does not have permission to view it.", responseCode="404")})
    public Response getStatusCategory(@PathParam(value="idOrKey") String idOrKey, @Context Request request, @Context UriInfo uriInfo) {
        ServiceOutcome statusCategoryOutcome = this.constantsService.getStatusCategoryById(this.authContext.getUser(), idOrKey);
        if (!statusCategoryOutcome.isValid() && !(statusCategoryOutcome = this.constantsService.getStatusCategoryByKey(this.authContext.getUser(), idOrKey)).isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(statusCategoryOutcome.getErrorCollection()));
        }
        return Response.ok((Object)this.statusCategoryHelper.createStatusCategoryBean((StatusCategory)statusCategoryOutcome.getReturnedValue(), uriInfo, StatusCategoryResource.class)).cacheControl(CacheControl.never()).build();
    }
}

