/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenLayoutItemId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenOperationContext;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenTabId;
import com.atlassian.jira.bc.issue.fields.screen.MoveFieldInfo;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.FieldWithShowWhenEmpty;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.AddFieldBean;
import com.atlassian.jira.rest.v2.issue.MoveFieldBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.ScreenBean;
import com.atlassian.jira.rest.v2.issue.ScreenableFieldBean;
import com.atlassian.jira.rest.v2.issue.ScreenableTabBean;
import com.atlassian.jira.rest.v2.issue.ScreensWithPaginationJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.api.internal.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.api.internal.expand.resolver.SelfExpandingEntityExpanderResolver;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@Path(value="screens")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ScreensResource {
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final CustomFieldService customFieldService;
    private final ProjectManager projectManager;
    private final FieldScreenService fieldScreenService;
    private final AccessDisablingHelper accessDisablingHelper;
    private final XsrfInvocationChecker xsrfInvocationChecker;
    private final SelfExpandingEntityExpanderResolver selfExpandingEntityExpanderResolver;
    private final EntityCrawler entityCrawler;

    @Inject
    public ScreensResource(FieldScreenManager fieldScreenManager, FieldManager fieldManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, CustomFieldService customFieldService, ProjectManager projectManager, @ComponentImport FieldScreenService fieldScreenService, @ComponentImport AccessDisablingHelper accessDisablingHelper, XsrfInvocationChecker xsrfInvocationChecker, @ComponentImport SelfExpandingEntityExpanderResolver selfExpandingEntityExpanderResolver, @ComponentImport EntityCrawler entityCrawler) {
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.customFieldService = customFieldService;
        this.projectManager = projectManager;
        this.fieldScreenService = fieldScreenService;
        this.accessDisablingHelper = accessDisablingHelper;
        this.xsrfInvocationChecker = xsrfInvocationChecker;
        this.selfExpandingEntityExpanderResolver = selfExpandingEntityExpanderResolver;
        this.entityCrawler = entityCrawler;
    }

    @GET
    @Path(value="{screenId}/tabs")
    @Operation(summary="Get all tabs for a screen", description="Returns a list of all tabs for the given screen.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="projectKey", description="the key of the project; this parameter is optional", required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns a list of Jira issue tabs.", responseCode="200", content={@Content(schema=@Schema(implementation=ScreenableTabBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the screen does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to view the tabs.", responseCode="401")})
    public Response getAllTabs(@PathParam(value="screenId") Long screenId, @QueryParam(value="projectKey") String projectKey) {
        FieldScreenOperationContext context = FieldScreenOperationContext.ofUserAndProject((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser(), (Project)this.getProjectByKey(projectKey));
        ServiceOutcome tabsResult = this.fieldScreenService.getAllTabs(FieldScreenId.byId((long)screenId), context);
        List tabs = (List)ScreensResource.throwWebExceptionOrGetResult(tabsResult);
        ArrayList<ScreenableTabBean> tabBeans = new ArrayList<ScreenableTabBean>(tabs.size());
        for (FieldScreenTab tab : tabs) {
            tabBeans.add(new ScreenableTabBean(tab));
        }
        return Response.ok(tabBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs")
    @Operation(summary="Create tab for a screen", description="Creates tab for given screen.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="screenId", description="id of screen", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns newly created tab.", responseCode="200", content={@Content(schema=@Schema(implementation=ScreenableTabBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the screen does not exist or the user is not authorized to create a tab.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to create a tab.", responseCode="401")})
    public Response addTab(@PathParam(value="screenId") Long screenId, ScreenableTabBean tab) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.addTab(FieldScreenId.byId((long)screenId), tab.name, this.userContext());
        FieldScreenTab fieldScreenTab = (FieldScreenTab)ScreensResource.throwWebExceptionOrGetResult(serviceOutcome);
        return Response.ok((Object)new ScreenableTabBean(fieldScreenTab)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{screenId}/tabs/{tabId}")
    @Operation(summary="Rename a tab on a screen", description="Renames tab on given screen.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns renamed tab.", responseCode="200", content={@Content(schema=@Schema(implementation=ScreenableTabBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the screen does not exist or the user is not authorized to rename a tab.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to rename a tab.", responseCode="401")})
    public Response renameTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, ScreenableTabBean tab) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.renameTab(FieldScreenTabId.byId((long)tabId), tab.name, this.userContext());
        FieldScreenTab tabResult = (FieldScreenTab)ScreensResource.throwWebExceptionOrGetResult(serviceOutcome);
        return Response.ok((Object)new ScreenableTabBean(tabResult)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{screenId}/tabs/{tabId}")
    @Operation(summary="Delete a tab from a screen", description="Deletes tab from given screen.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns response indicating tab deletion.", responseCode="204"), @ApiResponse(description="Returned if the screen does not exist or the user is not authorized to delete a tab.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to delete a tab.", responseCode="401"), @ApiResponse(description="Returned if tab can not be deleted due to a pre-condition (there has to be at least one tab left).", responseCode="412")})
    public Response deleteTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId) {
        ServiceResult serviceResult = this.fieldScreenService.removeTab(FieldScreenTabId.byId((long)tabId), this.userContext());
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs/{tabId}/move/{pos}")
    @Operation(summary="Move tab position", description="Moves tab position.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true), @Parameter(name="pos", description="position of tab", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns response indicating tab movement.", responseCode="204"), @ApiResponse(description="Returned if the screen does not exist or the user is not authorized to move a tab.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to move a tab.", responseCode="401")})
    public Response moveTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="pos") Integer pos) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.moveTab(FieldScreenTabId.byId((long)tabId), pos, this.userContext());
        ScreensResource.throwWebExeptionFromResult((ServiceResult)serviceOutcome);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{screenId}/tabs/{tabId}/fields")
    @Operation(summary="Get all fields for a tab", description="Gets all fields for a given tab.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true), @Parameter(name="projectKey", description="the key of the project; this parameter is optional", required=false)})
    @ApiResponses(value={@ApiResponse(description="Returns a list of all fields for the given tab.", responseCode="200", content={@Content(schema=@Schema(implementation=ScreenableFieldBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the screen or tab does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to view the fields.", responseCode="401")})
    public Response getAllFields(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @QueryParam(value="projectKey") String projectKey) {
        Project project = this.getProjectByKey(projectKey);
        ServiceOutcome fieldsOnTab = this.fieldScreenService.getFieldsWithShowWhenEmpty(FieldScreenTabId.byId((long)tabId), FieldScreenOperationContext.ofUserAndProject((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser(), (Project)project));
        List fields = (List)ScreensResource.throwWebExceptionOrGetResult(fieldsOnTab);
        List fieldBeans = fields.stream().map(this::toScreenableFieldBean).collect(Collectors.toList());
        return Response.ok(fieldBeans).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}/updateShowWhenEmptyIndicator/{newValue}")
    @Operation(summary="Update 'showWhenEmptyIndicator' for a field", description="Update 'showWhenEmptyIndicator' for given field on screen.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true), @Parameter(name="id", description="id of field", required=true), @Parameter(name="newValue", description="new value of 'showWhenEmptyIndicator'", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns response indicating the update of 'showWhenEmptyIndicator'.", responseCode="204"), @ApiResponse(description="Returned if the screen, tab or field does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to update 'showWhenEmptyIndicator'.", responseCode="401")})
    public Response updateShowWhenEmptyIndicator(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String fieldId, @PathParam(value="newValue") boolean newValue) {
        XsrfCheckResult xsrfCheckResult = this.xsrfInvocationChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        ServiceResult serviceResult = this.fieldScreenService.updateShowWhenEmpty(FieldScreenLayoutItemId.byIds((FieldScreenTabId)FieldScreenTabId.byId((long)tabId), (String)fieldId), this.userContext(), newValue);
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{screenId}/availableFields")
    @Operation(summary="Get available fields for screen", description="Gets available fields for screen. i.e ones that haven't already been added.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="screenId", description="id of screen", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a list of available fields for the screen.", responseCode="200", content={@Content(schema=@Schema(implementation=ScreenableFieldBean.class, type="array"), mediaType="application/json")}), @ApiResponse(description="Returned if the screen does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to view the available fields.", responseCode="401")})
    public Response getFieldsToAdd(@PathParam(value="screenId") Long screenId) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.getAvailableFieldsForScreen(FieldScreenId.byId((long)screenId), this.userContext());
        List addableFields = (List)ScreensResource.throwWebExceptionOrGetResult(serviceOutcome);
        ArrayList<ScreenableFieldBean> fieldBeans = new ArrayList<ScreenableFieldBean>();
        for (OrderableField addableField : addableFields) {
            fieldBeans.add(new ScreenableFieldBean(addableField.getId(), addableField.getName(), this.getFieldType((Field)addableField), false));
        }
        return Response.ok(fieldBeans).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}")
    @Operation(summary="Remove field from tab", description="Removes field from given tab.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true), @Parameter(name="id", description="id of field", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns response indicating field removal.", responseCode="204"), @ApiResponse(description="Returned if the screen or tab does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to remove a field.", responseCode="401")})
    public Response removeField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String id) {
        ServiceResult serviceResult = this.fieldScreenService.removeField(FieldScreenLayoutItemId.byIds((FieldScreenTabId)FieldScreenTabId.byId((long)tabId), (String)id), this.userContext());
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}/move")
    @Operation(summary="Move field on a tab", description="Moves field on the given tab.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true), @Parameter(name="id", description="id of field", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns response indicating field movement.", responseCode="204"), @ApiResponse(description="Returned if the screen, tab or field does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to move a field.", responseCode="401")})
    public Response moveField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String id, MoveFieldBean moveField) {
        MoveFieldInfo moveInfo;
        if (moveField.after != null) {
            String[] split = moveField.after.getPath().split("/");
            String afterField = split[split.length - 1];
            moveInfo = MoveFieldInfo.after((String)afterField);
        } else if (moveField.position == MoveFieldBean.Position.Last) {
            moveInfo = MoveFieldInfo.ofPosition((MoveFieldInfo.MoveFieldPosition)MoveFieldInfo.MoveFieldPosition.Last);
        } else if (moveField.position == MoveFieldBean.Position.First) {
            moveInfo = MoveFieldInfo.ofPosition((MoveFieldInfo.MoveFieldPosition)MoveFieldInfo.MoveFieldPosition.First);
        } else {
            this.throwWebException("Unimplemented behaviour of moving field: " + moveField.position);
            return null;
        }
        ServiceResult serviceResult = this.fieldScreenService.moveField(FieldScreenLayoutItemId.byIds((FieldScreenTabId)FieldScreenTabId.byId((long)tabId), (String)id), moveInfo, this.userContext());
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs/{tabId}/fields")
    @Operation(summary="Add field to a tab", description="Adds field to the given tab.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns newly added field.", responseCode="200", content={@Content(schema=@Schema(implementation=ScreenableFieldBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the screen, tab or field does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to add a field.", responseCode="401")})
    public Response addField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, AddFieldBean field) {
        ServiceOutcome fieldServiceOutcome = this.fieldScreenService.addFieldToScreen(FieldScreenTabId.byId((long)tabId), field.getFieldId(), this.userContext());
        Field resultField = (Field)ScreensResource.throwWebExceptionOrGetResult(fieldServiceOutcome);
        ScreenableFieldBean screenableFieldBean = new ScreenableFieldBean(resultField.getId(), resultField.getName(), this.getFieldType(resultField), false);
        return Response.ok((Object)screenableFieldBean).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="addToDefault/{fieldId}")
    @Operation(summary="Add field to default screen", description="Moves field on the given tab.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="screenId", description="id of screen", required=true), @Parameter(name="tabId", description="id of tab", required=true), @Parameter(name="id", description="id of field", required=true)})
    @ApiResponses(value={@ApiResponse(description="Returns response indicating field movement.", responseCode="204"), @ApiResponse(description="Returned if the screen, tab or field does not exist.", responseCode="400"), @ApiResponse(description="Returned if the user is not authorized to move a field.", responseCode="401")})
    public Response addFieldToDefaultScreen(@PathParam(value="fieldId") String fieldId) {
        FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(FieldScreen.DEFAULT_SCREEN_ID);
        List<FieldScreenTab> sortedTabs = this.sortFieldScreenTabs(fieldScreen.getTabs());
        FieldScreenTab defaultTabOfDefaultScreen = sortedTabs.iterator().next();
        Field field = this.fieldManager.getField(fieldId);
        if (field instanceof CustomField) {
            this.administerPermissionCheck();
            this.addCustomField(fieldId, defaultTabOfDefaultScreen);
        } else {
            ServiceOutcome fieldServiceOutcome = this.fieldScreenService.addFieldToScreen(FieldScreenTabId.byId((long)defaultTabOfDefaultScreen.getId()), fieldId, this.userContext());
            ScreensResource.throwWebExeptionFromResult((ServiceResult)fieldServiceOutcome);
        }
        return Response.ok((Object)Response.Status.CREATED).cacheControl(CacheControl.never()).build();
    }

    @GET
    @WebSudoRequired
    @Operation(summary="Get available field screens", description="Adds field or custom field to the default tab.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="fieldId", description="id of field / custom field", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns response indicating successful addition of field to default screen / default tab.", responseCode="201"), @ApiResponse(description="Returned if the user does not have administrator permissions.", responseCode="401"), @ApiResponse(description="Returned if screen, tab or field does not exist or field is already present on a selected tab.", responseCode="400")})
    public Response getAllScreens(@QueryParam(value="startAt") String startAt, @QueryParam(value="maxResults") String maxResults, @QueryParam(value="expand") String expand, @QueryParam(value="search") String searchQuery) {
        boolean isRequestingAllScreens;
        if (!this.jiraAuthenticationContext.isLoggedInUser()) {
            throw new NotAuthorisedWebException();
        }
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(AccessDisablingHelperConfig.builder().blockForAnyoneWithoutPermission(GlobalPermissionKey.ADMINISTER).build())) {
            throw new ForbiddenWebException();
        }
        boolean bl = isRequestingAllScreens = startAt == null && maxResults == null;
        if (isRequestingAllScreens) {
            return this.getAllFieldScreens(expand, searchQuery);
        }
        return this.getPaginatedFieldScreens(startAt, maxResults, expand, searchQuery);
    }

    private ScreenableFieldBean toScreenableFieldBean(FieldWithShowWhenEmpty fieldWithShowWhenEmpty) {
        Field field = fieldWithShowWhenEmpty.getField();
        return new ScreenableFieldBean(field.getId(), field.getName(), this.getFieldType(field), fieldWithShowWhenEmpty.isShownWhenEmpty());
    }

    private Response getAllFieldScreens(String expand, String searchQuery) {
        List<ScreenBean> fieldScreens = this.prepareScreenBeans(this.fieldScreenManager.getFieldScreens(searchQuery), expand);
        return Response.ok(fieldScreens).cacheControl(CacheControl.never()).build();
    }

    private Response getPaginatedFieldScreens(String startAt, String maxResults, String expand, String searchQuery) {
        if (!this.isParamNonNegativeInteger(startAt) || !this.isParamNonNegativeInteger(maxResults)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"\"startAt\" and \"maxResults\" parameters must be numeric and can't be negative").build();
        }
        int totalScreensCount = this.fieldScreenManager.getFieldScreens(searchQuery).size();
        int normStartAt = NumberUtils.toInt((String)startAt, (int)0);
        int normMaxResults = NumberUtils.toInt((String)maxResults, (int)20);
        List<ScreenBean> fieldScreens = this.prepareScreenBeans(this.fieldScreenManager.getFieldScreens(normStartAt, normMaxResults, searchQuery), expand);
        ScreensWithPaginationJsonBean pageBean = new ScreensWithPaginationJsonBean(normStartAt, normMaxResults, totalScreensCount, fieldScreens);
        return Response.ok((Object)pageBean).cacheControl(CacheControl.never()).build();
    }

    private List<FieldScreenTab> sortFieldScreenTabs(List<FieldScreenTab> tabs) {
        ArrayList sortedTabs = Lists.newArrayList(tabs);
        if (sortedTabs.size() > 1) {
            sortedTabs.sort(Comparator.comparing(FieldScreenTab::getId));
        }
        return sortedTabs;
    }

    private void addCustomField(String fieldId, FieldScreenTab defaultTabOfDefaultScreen) {
        ServiceOutcome outcome = this.customFieldService.addToScreenTabs(this.jiraAuthenticationContext.getUser(), CustomFieldUtils.getCustomFieldId((String)fieldId), (List)Lists.newArrayList((Object[])new Long[]{defaultTabOfDefaultScreen.getId()}));
        if (outcome.getErrorCollection().hasAnyErrors()) {
            ScreensResource.throwWebException(outcome.getErrorCollection());
        }
    }

    private String getFieldType(Field field) {
        if (this.fieldManager.isCustomField(field)) {
            return ((CustomField)field).getCustomFieldType().getName();
        }
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.screens.system.field");
    }

    private void throwWebException(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        ScreensResource.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private static void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private static <T> T throwWebExceptionOrGetResult(ServiceOutcome<T> outcome) {
        if (outcome.isValid()) {
            return (T)outcome.get();
        }
        ScreensResource.throwWebExeptionFromResult(outcome);
        return null;
    }

    private static void throwWebExeptionFromResult(ServiceResult result) {
        if (result.isValid()) {
            return;
        }
        com.atlassian.jira.util.ErrorCollection ec = result.getErrorCollection();
        if (ec.getReasons().contains(ErrorCollection.Reason.FORBIDDEN) || ec.getReasons().contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
            throw new NotAuthorisedWebException();
        }
        ScreensResource.throwWebException(ec);
    }

    private void administerPermissionCheck() {
        if (!this.permissionManager.hasPermission(0, this.jiraAuthenticationContext.getLoggedInUser())) {
            throw new NotAuthorisedWebException();
        }
    }

    private Project getProjectByKey(String projectKey) {
        if (StringUtils.isBlank((CharSequence)projectKey)) {
            return null;
        }
        return this.projectManager.getProjectObjByKey(projectKey);
    }

    private FieldScreenOperationContext userContext() {
        return FieldScreenOperationContext.ofUser((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser());
    }

    private boolean isParamNonNegativeInteger(String param) {
        if (param == null) {
            return false;
        }
        try {
            int number = Integer.parseInt(param);
            return number >= 0;
        }
        catch (NumberFormatException err) {
            return false;
        }
    }

    private Consumer<ScreenBean> getScreenBeanCrawler(String expand) {
        StringList expandList = StringList.fromQueryParam(expand);
        ImmutableList<String> expandItems = expandList.asList();
        DefaultExpandParameter expandParameter = new DefaultExpandParameter(expandItems);
        return arg_0 -> this.lambda$getScreenBeanCrawler$0((ExpandParameter)expandParameter, arg_0);
    }

    private List<ScreenBean> prepareScreenBeans(Collection<FieldScreen> fieldScreens, String expand) {
        Consumer<ScreenBean> crawler = this.getScreenBeanCrawler(expand);
        return fieldScreens.stream().map(fieldScreen -> new ScreenBean((FieldScreen)fieldScreen, StringUtils.defaultString((String)expand))).peek(arg_0 -> crawler.consume(arg_0)).collect(Collectors.toList());
    }

    private /* synthetic */ void lambda$getScreenBeanCrawler$0(ExpandParameter expandParameter, ScreenBean screenBean) {
        this.entityCrawler.crawl((Object)screenBean, expandParameter, (EntityExpanderResolver)this.selfExpandingEntityExpanderResolver);
    }
}

