/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ResolutionJsonBean;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.ResolutionBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AccessDisablingHelper;
import com.atlassian.jira.util.AccessDisablingHelperConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="resolution")
@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ResolutionResource {
    private ConstantsManager constantsManager;
    private I18nHelper i18n;
    private JiraBaseUrls baseUrls;
    private JiraAuthenticationContext authContext;
    private AccessDisablingHelper accessDisablingHelper;
    private PermissionManager permissionManager;
    @ComponentImport
    private ResolutionManager resolutionManager;

    private ResolutionResource() {
    }

    @Inject
    public ResolutionResource(ConstantsManager constantsManager, I18nHelper i18n, JiraBaseUrls baseUrls, JiraAuthenticationContext authContext, AccessDisablingHelper accessDisablingHelper, PermissionManager permissionManager, ResolutionManager resolutionManager) {
        this.constantsManager = constantsManager;
        this.i18n = i18n;
        this.baseUrls = baseUrls;
        this.authContext = authContext;
        this.accessDisablingHelper = accessDisablingHelper;
        this.permissionManager = permissionManager;
        this.resolutionManager = resolutionManager;
    }

    @GET
    @Operation(summary="Get all resolutions", description="Returns a list of all resolutions.", security={@SecurityRequirement(name="basic")})
    @ApiResponse(description="Returns a list of Jira issue resolutions.", responseCode="200", content={@Content(schema=@Schema(implementation=ResolutionJsonBean.class, type="array"), mediaType="application/json")})
    public Response getResolutions() {
        this.blockAnonymousUsersIfNeeded();
        Collection resolutions = this.constantsManager.getResolutions();
        ArrayList<ResolutionJsonBean> beans = new ArrayList<ResolutionJsonBean>(resolutions.size());
        for (Resolution resolution : resolutions) {
            beans.add(ResolutionJsonBean.shortBean((Resolution)resolution, (JiraBaseUrls)this.baseUrls));
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="page")
    @Produces(value={"application/json"})
    @ExperimentalApi
    @Operation(summary="Get paginated filtered resolutions", description="Returns paginated list of filtered resolutions.", security={@SecurityRequirement(name="basic")})
    @Parameters(value={@Parameter(name="startAt", description="The index of the first status to return."), @Parameter(name="maxResults", description="The maximum number of statuses to return."), @Parameter(name="query", description="The string that status names will be matched with.")})
    @ApiResponse(description="Returns paginated list of resolutions.", responseCode="200", content={@Content(schema=@Schema(implementation=ResolutionBean.class, type="array"), mediaType="application/json")})
    public Response getPaginatedResolutions(@DefaultValue(value="0") @QueryParam(value="startAt") Long startAt, @DefaultValue(value="100") @QueryParam(value="maxResults") Integer maxResults, @DefaultValue(value="") @QueryParam(value="query") String query) {
        this.blockAnonymousUsersIfNeededWithFF();
        Set statuses = this.resolutionManager.findResolutions(query).collect(Collectors.toCollection(() -> new TreeSet<Resolution>(Comparator.comparing(IssueConstant::getId))));
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)maxResults);
        Page statusPage = Pages.toPage((Iterable)statuses, (PageRequest)pageRequest);
        PageBean<ResolutionJsonBean> bean = PageBean.from(pageRequest, statusPage).build(resolution -> ResolutionJsonBean.shortBean((Resolution)resolution, (JiraBaseUrls)this.baseUrls));
        return Response.ok(bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{id}")
    @Operation(summary="Get a resolution by ID", description="Returns a resolution.", security={@SecurityRequirement(name="basic")})
    @Parameter(name="id", description="A String containing the resolution id.", required=true)
    @ApiResponses(value={@ApiResponse(description="Returns a Jira issue resolution.", responseCode="200", content={@Content(schema=@Schema(implementation=ResolutionJsonBean.class), mediaType="application/json")}), @ApiResponse(description="Returned if the resolution does not exist or the user does not have permission to view it.", responseCode="404")})
    public Response getResolution(@PathParam(value="id") String id) {
        this.blockAnonymousUsersIfNeeded();
        Resolution resolution = this.constantsManager.getResolution(id);
        if (resolution == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.resolution.error.not.found", id)));
        }
        return Response.ok((Object)ResolutionJsonBean.shortBean((Resolution)resolution, (JiraBaseUrls)this.baseUrls)).cacheControl(CacheControl.never()).build();
    }

    private void blockAnonymousUsersIfNeeded() {
        AccessDisablingHelperConfig accessConfig = AccessDisablingHelperConfig.builder().blockAnyoneNotFulfillingCondition(this::canUserAccess).build();
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(accessConfig)) {
            throw new NotAuthorisedWebException();
        }
    }

    private void blockAnonymousUsersIfNeededWithFF() {
        AccessDisablingHelperConfig accessConfig = AccessDisablingHelperConfig.builder().logDeprecatedSinceVersion("10.5.0").blockAccessSinceVersion("10.0.0").blockAnyoneNotFulfillingCondition(this::canUserAccess).featureFlag(JiraFeatureFlagRegistrar.RESOLUTION_PAGE_ANONYMOUS_ACCESS.featureKey()).build();
        if (!this.accessDisablingHelper.canBeAccessedByCurrentUser(accessConfig)) {
            throw new NotAuthorisedWebException();
        }
    }

    private boolean canUserAccess(ApplicationUser user) {
        return user != null || this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null);
    }
}

